/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.AliasFileXmlBean;
import net.sourceforge.squirrel_sql.client.gui.recentfiles.RecentFilesJsonBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RecentFilesManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentFilesManager.class);
    private RecentFilesJsonBean _recentFilesJsonBean = new RecentFilesJsonBean();

    public void fileTouched(String absolutePath, ISQLAliasExt alias) {
        ArrayList<String> recentFiles = this._recentFilesJsonBean.getRecentFiles();
        this.adjustFileArray(absolutePath, recentFiles);
        ArrayList<String> recentAliasFiles = this.findOrCreateAliasFile(alias).getRecentFiles();
        this.adjustFileArray(absolutePath, recentAliasFiles);
    }

    private void adjustFileArray(String newAbsolutePath, ArrayList<String> fileArray) {
        fileArray.remove(newAbsolutePath);
        fileArray.add(0, newAbsolutePath);
        while (this._recentFilesJsonBean.getMaxRecentFiles() < fileArray.size()) {
            fileArray.remove(fileArray.size() - 1);
        }
    }

    private AliasFileXmlBean findOrCreateAliasFile(ISQLAlias alias) {
        AliasFileXmlBean ret = this.findAliasFile(alias);
        if (null == ret) {
            ret = new AliasFileXmlBean();
            ret.setAlisaIdentifierString(alias.getIdentifier().toString());
            this._recentFilesJsonBean.getAliasFileXmlBeans().add(ret);
        }
        return ret;
    }

    private AliasFileXmlBean findAliasFile(ISQLAlias alias) {
        AliasFileXmlBean ret = null;
        ArrayList<AliasFileXmlBean> aliasFileXmlBeans = this._recentFilesJsonBean.getAliasFileXmlBeans();
        for (AliasFileXmlBean aliasFileXmlBean : aliasFileXmlBeans) {
            if (!aliasFileXmlBean.getAlisaIdentifierString().equals(alias.getIdentifier().toString())) continue;
            ret = aliasFileXmlBean;
            break;
        }
        return ret;
    }

    public void saveJsonBean(File recentFilesBeanFile) {
        try {
            FileOutputStream fos = new FileOutputStream(recentFilesBeanFile);
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter objectWriter = mapper.writerWithDefaultPrettyPrinter();
            objectWriter.writeValue((OutputStream)fos, (Object)this._recentFilesJsonBean);
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initJSonBean(File recentFilesJsonBeanFile) {
        try {
            this.checkIfOlderVersionWarningIsNeeded();
            if (!recentFilesJsonBeanFile.exists()) {
                return;
            }
            FileInputStream is = new FileInputStream(recentFilesJsonBeanFile);
            InputStreamReader isr = new InputStreamReader((InputStream)is, JsonEncoding.UTF8.getJavaName());
            ObjectMapper mapper = new ObjectMapper();
            this._recentFilesJsonBean = (RecentFilesJsonBean)mapper.readValue((Reader)isr, (JavaType)SimpleType.construct(RecentFilesJsonBean.class));
            isr.close();
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkIfOlderVersionWarningIsNeeded() {
        File oldVerionFile = new ApplicationFiles().getRecentFilesXmlBeanFile_oldXmlVersion();
        if (oldVerionFile.exists()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("RecentFilesManager.old.version.warning", oldVerionFile.getPath()));
        }
    }

    public ArrayList<String> getRecentFiles() {
        return this._recentFilesJsonBean.getRecentFiles();
    }

    public ArrayList<String> getFavouriteFiles() {
        return this._recentFilesJsonBean.getFavouriteFiles();
    }

    public ArrayList<String> getRecentFilesForAlias(ISQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getRecentFiles();
    }

    public ArrayList<String> getFavouriteFilesForAlias(ISQLAlias selectedAlias) {
        return this.findOrCreateAliasFile(selectedAlias).getFavouriteFiles();
    }

    public int getMaxRecentFiles() {
        return this._recentFilesJsonBean.getMaxRecentFiles();
    }

    public void setMaxRecentFiles(int n) {
        this._recentFilesJsonBean.setMaxRecentFiles(n);
    }

    public void adjustFavouriteFiles(File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this._recentFilesJsonBean.getFavouriteFiles());
    }

    public void adjustFavouriteAliasFiles(ISQLAlias alias, File selectedFile) {
        this.adjustFileArray(selectedFile.getAbsolutePath(), this.findOrCreateAliasFile(alias).getFavouriteFiles());
    }

    public void setRecentFiles(ArrayList<String> files) {
        this._recentFilesJsonBean.setRecentFiles(files);
    }

    public void setFavouriteFiles(ArrayList<String> files) {
        this._recentFilesJsonBean.setFavouriteFiles(files);
    }

    public void setRecentFilesForAlias(ISQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setRecentFiles(files);
    }

    public void setFavouriteFilesForAlias(ISQLAlias alias, ArrayList<String> files) {
        this.findOrCreateAliasFile(alias).setFavouriteFiles(files);
    }
}

