/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.CatalogsPanel;
import net.sourceforge.squirrel_sql.client.gui.session.IMainPanelFactory;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanel;
import net.sourceforge.squirrel_sql.client.gui.session.RowColumnLabel;
import net.sourceforge.squirrel_sql.client.gui.session.SchemaPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.gui.session.ToolbarItem;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteAllSqlsAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.FileDetachAction;
import net.sourceforge.squirrel_sql.client.session.action.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenRecentAction;
import net.sourceforge.squirrel_sql.client.session.action.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.FileReloadAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.IObjectTreeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(SessionPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionPanel.class);
    private final transient IApplication _app;
    private transient IIdentifier _sessionId;
    private transient PropertyChangeListener _propsListener;
    private transient MainPanel _mainTabPane;
    private transient IMainPanelFactory _mainPanelFactory;
    private MyToolBar _toolBar;
    private Vector<ToolbarItem> _externallyAddedToolbarActionsAndSeparators = new Vector();
    private StatusBar _statusBar = new StatusBar();
    private boolean _hasBeenVisible;
    private transient ObjectTreeSelectionListener _objTreeSelectionLis = null;

    public SessionPanel(ISession session) {
        super(new BorderLayout());
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._app = session.getApplication();
        this._sessionId = session.getIdentifier();
        SessionColoringUtil.colorStatusbar(session, this._statusBar);
    }

    protected void initialize(ISession session) {
        this.createGUI(session);
        this.propertiesHaveChanged(null);
        this._propsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SessionPanel.this.propertiesHaveChanged(evt.getPropertyName());
            }
        };
        session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this.getSQLPaneAPI().addToToolsPopUp(selectionString, action);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._hasBeenVisible) {
            this._hasBeenVisible = true;
            this._mainTabPane.getObjectTreePanel().refreshTree();
        }
    }

    public boolean hasConnection() {
        return this.getSession().getSQLConnection() != null;
    }

    public ISession getSession() {
        return this._app.getSessionManager().getSession(this._sessionId);
    }

    public void sessionHasClosed() {
        ISession session;
        if (this._objTreeSelectionLis != null) {
            this.getObjectTreePanel().removeTreeSelectionListener(this._objTreeSelectionLis);
            this._objTreeSelectionLis = null;
        }
        if ((session = this.getSession()) != null) {
            if (this._propsListener != null) {
                session.getProperties().removePropertyChangeListener(this._propsListener);
                this._propsListener = null;
            }
            this._mainTabPane.sessionClosing(session);
            this._sessionId = null;
        }
    }

    public void sessionWindowClosing() {
        this._mainTabPane.sessionWindowClosing();
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._mainTabPane.getObjectTreePanel();
    }

    void closeConnection() {
        try {
            this.getSession().closeSQLConnection();
        }
        catch (SQLException ex) {
            this.showError(ex);
        }
    }

    public void selectMainTab(int tabIndex) {
        JTabbedPane tabPnl = this._mainTabPane.getTabbedPane();
        if (tabIndex >= tabPnl.getTabCount()) {
            throw new IllegalArgumentException("" + tabIndex + " is not a valid index into the main tabbed pane.");
        }
        if (tabPnl.getSelectedIndex() != tabIndex) {
            tabPnl.setSelectedIndex(tabIndex);
        }
    }

    public int getSelectedMainTabIndex() {
        return this._mainTabPane.getTabbedPane().getSelectedIndex();
    }

    public IMainPanelTab getSelectedMainTab() {
        return this._mainTabPane.getSelectedMainTab();
    }

    public int addMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("IMainPanelTab == null");
        }
        return this._mainTabPane.addMainPanelTab(tab);
    }

    public void insertMainTab(IMainPanelTab tab, int idx) {
        this.insertMainTab(tab, idx, true);
    }

    public void insertMainTab(IMainPanelTab tab, int idx, boolean selectInsertedTab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        if (idx == 1 || idx == 0) {
            throw new IllegalArgumentException("Index " + idx + "conflicts with standard tabs");
        }
        this._mainTabPane.insertMainPanelTab(tab, idx, selectInsertedTab);
    }

    public int removeMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        return this._mainTabPane.removeMainPanelTab(tab);
    }

    public void setStatusBarMessage(final String msg) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                SessionPanel.this._statusBar.setText(msg);
            }
        });
    }

    public void setStatusBarProgress(final String msg, final int minimum, final int maximum, final int value) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                SessionPanel.this._statusBar.setStatusBarProgress(msg, minimum, maximum, value);
            }
        });
    }

    public void setStatusBarProgressFinished() {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                SessionPanel.this._statusBar.setStatusBarProgressFinished();
            }
        });
    }

    public String getStatusBarMessage() {
        return this._statusBar.getText();
    }

    SQLPanel getSQLPanel() {
        return this._mainTabPane.getSQLPanel();
    }

    public ISQLPanelAPI getSQLPaneAPI() {
        return this._mainTabPane.getSQLPanel().getSQLPanelAPI();
    }

    public ISQLEntryPanel getSQLEntryPanel() {
        return this.getSQLPanel().getSQLEntryPanel();
    }

    public synchronized void addToToolbar(Action action) {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem(action));
        if (null != this._toolBar) {
            this._toolBar.add(action);
        }
    }

    public synchronized void addSeparatorToToolbar() {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem());
        if (null != this._toolBar) {
            this._toolBar.addSeparator();
        }
    }

    public void addToStatusBar(JComponent comp) {
        this._statusBar.addJComponent(comp);
    }

    public void removeFromStatusBar(JComponent comp) {
        this._statusBar.remove(comp);
    }

    private void showError(Exception ex) {
        this._app.showErrorDialog(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertiesHaveChanged(String propertyName) {
        final ISession session = this.getSession();
        final SessionProperties props = session.getProperties();
        if (propertyName == null || propertyName.equals("commitOnClosingConnection")) {
            this._app.getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    session.getSQLConnection().setCommitOnClose(props.getCommitOnClosingConnection());
                }
            });
        }
        if (propertyName == null || propertyName.equals("showToolBar")) {
            SessionPanel sessionPanel = this;
            synchronized (sessionPanel) {
                boolean show = props.getShowToolBar();
                if (show != (this._toolBar != null)) {
                    if (show) {
                        if (this._toolBar == null) {
                            this._toolBar = new MyToolBar(session);
                            for (int i = 0; i < this._externallyAddedToolbarActionsAndSeparators.size(); ++i) {
                                ToolbarItem toolbarItem = this._externallyAddedToolbarActionsAndSeparators.get(i);
                                if (toolbarItem.isSeparator()) {
                                    this._toolBar.addSeparator();
                                    continue;
                                }
                                this._toolBar.add(toolbarItem.getAction());
                            }
                            this.add((Component)this._toolBar, "North");
                        }
                    } else if (this._toolBar != null) {
                        this.remove(this._toolBar);
                        this._toolBar = null;
                    }
                }
            }
        }
    }

    private void createGUI(ISession session) {
        IApplication app = session.getApplication();
        this._mainTabPane = this._mainPanelFactory.createMainPanel(session);
        this.add((Component)this._mainTabPane, "Center");
        Font fn = app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        this.add((Component)this._statusBar, "South");
        this._objTreeSelectionLis = new ObjectTreeSelectionListener();
        this.getObjectTreePanel().addTreeSelectionListener(this._objTreeSelectionLis);
        this.addToStatusBar(new SchemaPanel(session));
        this.addToStatusBar(new RowColumnLabel(this._mainTabPane.getSQLPanel().getSQLEntryPanel()));
        this.validate();
    }

    public boolean isSQLTabSelected() {
        return 1 == this._mainTabPane.getTabbedPane().getSelectedIndex();
    }

    public boolean isObjectTreeTabSelected() {
        return 0 == this._mainTabPane.getTabbedPane().getSelectedIndex();
    }

    public void setMainPanelFactory(IMainPanelFactory panelFactory) {
        this._mainPanelFactory = panelFactory;
    }

    public int getTabCount() {
        return this._mainTabPane.getTabbedPane().getTabCount();
    }

    public int getMainTabIndex(IMainPanelTab mainPanelTab) {
        return this._mainTabPane.getTabIndex(mainPanelTab);
    }

    public String getSelectedCatalogFromCatalogsComboBox() {
        if (null == this._toolBar) {
            return null;
        }
        return this._toolBar._catalogsPanel.getSelectedCatalog();
    }

    private final class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private ObjectTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            TreePath selPath = evt.getNewLeadSelectionPath();
            if (selPath != null) {
                StringBuffer buf = new StringBuffer();
                Object[] fullPath = selPath.getPath();
                for (int i = 0; i < fullPath.length; ++i) {
                    if (!(fullPath[i] instanceof ObjectTreeNode)) continue;
                    ObjectTreeNode node = (ObjectTreeNode)fullPath[i];
                    buf.append('/').append(node.toString());
                }
                SessionPanel.this.setStatusBarMessage(buf.toString());
            }
        }
    }

    private final class CatalogsComboListener
    implements ActionListener {
        private CatalogsComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String selectedCatalog = SessionPanel.this._toolBar._catalogsPanel.getSelectedCatalog();
            if (selectedCatalog != null) {
                try {
                    ISession session = SessionPanel.this.getSession();
                    session.getSQLConnection().setCatalog(selectedCatalog);
                    this.refreshSchemaInBackground();
                }
                catch (SQLException ex) {
                    SessionPanel.this.getSession().showErrorMessage(ex);
                    SessionPanel.this._toolBar._catalogsPanel.refreshCatalogs();
                }
            }
        }

        private void refreshSchemaInBackground() {
            final ISession session = SessionPanel.this.getSession();
            session.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    session.getSchemaInfo().reloadAll();
                    CatalogsComboListener.this.expandTreeInForeground();
                }
            });
        }

        private void expandTreeInForeground() {
            final ISession session = SessionPanel.this.getSession();
            final String selectedCatalog = SessionPanel.this._toolBar._catalogsPanel.getSelectedCatalog();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    CatalogsComboListener.this.expandTablesForCatalog(session, selectedCatalog);
                }
            });
        }

        private void expandTablesForCatalog(ISession session, String selectedCatalog) {
            ObjectTreeNode[] nodes;
            IObjectTreeAPI api = session.getObjectTreeAPIOfActiveSessionWindow();
            api.refreshTree(true);
            if (api.selectInObjectTree(selectedCatalog, null, new FilterMatcher("TABLE", null)) && (nodes = api.getSelectedNodes()).length > 0) {
                ObjectTreeNode tableNode = nodes[0];
                api.expandNode(tableNode);
            }
        }
    }

    private class MyToolBar
    extends ToolBar {
        private static final long serialVersionUID = 1L;
        private IObjectTreeListener _lis;
        private CatalogsPanel _catalogsPanel;

        MyToolBar(ISession session) {
            this.createGUI(session);
            SessionColoringUtil.colorToolbar(session, this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!SessionPanel.this._hasBeenVisible) {
                SessionPanel.this._hasBeenVisible = true;
                SessionPanel.this._mainTabPane.getObjectTreePanel().refreshTree();
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this._lis != null) {
                SessionPanel.this.getObjectTreePanel().removeObjectTreeListener(this._lis);
                this._lis = null;
            }
        }

        private void createGUI(ISession session) {
            this._catalogsPanel = new CatalogsPanel(session, this);
            this._catalogsPanel.addActionListener(new CatalogsComboListener());
            this.add(this._catalogsPanel);
            ActionCollection actions = session.getApplication().getActionCollection();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add(actions.get(SessionPropertiesAction.class));
            this.add(actions.get(RefreshSchemaInfoAction.class));
            this.addSeparator();
            this.add(actions.get(ExecuteSqlAction.class));
            this.addSeparator();
            this.add(actions.get(ExecuteAllSqlsAction.class));
            this.addSeparator();
            this.add(actions.get(SQLFilterAction.class));
            this.addSeparator();
            this.add(actions.get(FileNewAction.class));
            this.add(actions.get(FileDetachAction.class));
            this.add(actions.get(FileOpenAction.class));
            this.add(actions.get(FileOpenRecentAction.class));
            this.add(actions.get(FileAppendAction.class));
            this.add(actions.get(FileSaveAction.class));
            this.add(actions.get(FileSaveAsAction.class));
            this.add(actions.get(FileCloseAction.class));
            this.add(actions.get(FilePrintAction.class));
            this.add(actions.get(FileReloadAction.class));
            this.addSeparator();
            this.add(actions.get(PreviousSqlAction.class));
            this.add(actions.get(NextSqlAction.class));
            this.add(actions.get(SelectSqlAction.class));
        }
    }
}

