/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.FindAliasListCellRenderer;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewAliasesAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.CloseByEscapeListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindAliasesCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindAliasesCtrl.class);
    public static final String PREF_KEY_FIND_ALIAS_SHEET_WIDTH = "Squirrel.findAliasSheet.width";
    public static final String PREF_KEY_FIND_ALIAS_SHEET_HEIGHT = "Squirrel.findAliasSheet.height";
    public static final String PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN = "Squirrel.findAliasSheet.check.leave.open";
    private final JDialog _dlg;
    private final JTextField _txtToSearch = new JTextField();
    private final JList _lstResult = new JList();
    private JCheckBox _chkLeaveOpen = new JCheckBox(s_stringMgr.getString("FindAliasesCtrl.leave.open"));
    private JButton _btnConnect = new JButton(s_stringMgr.getString("FindAliasesCtrl.connect"));
    private JButton _btnGoto = new JButton(s_stringMgr.getString("FindAliasesCtrl.goto"));
    private JButton _btnClose = new JButton(s_stringMgr.getString("FindAliasesCtrl.close"));

    public FindAliasesCtrl(final IAliasesList al) {
        this._dlg = this.createGui();
        GUIUtils.centerWithinParent(this._dlg);
        GUIUtils.enableCloseByEscape(this._dlg, new CloseByEscapeListener(){

            @Override
            public void willCloseByEcape(JDialog dialog) {
                FindAliasesCtrl.this.onClosing();
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindAliasesCtrl.this.onClosing();
            }
        });
        this._lstResult.setCellRenderer(new FindAliasListCellRenderer());
        this._lstResult.setFocusable(false);
        this._lstResult.setSelectionMode(0);
        this._lstResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindAliasesCtrl.this.onListClicked(e);
            }
        });
        this._chkLeaveOpen.setFocusable(false);
        this._chkLeaveOpen.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, false));
        this._btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAliasesCtrl.this.onConnect();
            }
        });
        this._btnGoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAliasesCtrl.this.onGoto(al);
            }
        });
        this._btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAliasesCtrl.this.onClose();
            }
        });
        this._txtToSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }
        });
        this._txtToSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FindAliasesCtrl.this.onKeyPressed(e);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindAliasesCtrl.this._txtToSearch.requestFocus();
            }
        });
        this._dlg.getRootPane().setDefaultButton(this._btnConnect);
        this.updateList();
        this._dlg.setVisible(true);
    }

    private void onClose() {
        this.onClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            int selIx = this._lstResult.getSelectedIndex();
            if (0 < selIx) {
                this._lstResult.setSelectedIndex(selIx - 1);
                this._lstResult.ensureIndexIsVisible(selIx - 1);
            }
        } else if (e.getKeyCode() == 40) {
            int selIx = this._lstResult.getSelectedIndex();
            if (this._lstResult.getModel().getSize() - 1 > selIx) {
                this._lstResult.setSelectedIndex(selIx + 1);
                this._lstResult.ensureIndexIsVisible(selIx + 1);
            }
        }
    }

    private void onConnect() {
        ISQLAlias selectedAlias = (ISQLAlias)this._lstResult.getSelectedValue();
        if (null == selectedAlias) {
            return;
        }
        ConnectToAliasCallBack completionCallback = null;
        if (this._chkLeaveOpen.isSelected()) {
            completionCallback = new ConnectToAliasCallBack(Main.getApplication(), (SQLAlias)selectedAlias){

                @Override
                public void sessionCreated(ISession session) {
                    FindAliasesCtrl.this._dlg.requestFocus();
                    FindAliasesCtrl.this._txtToSearch.requestFocus();
                    super.sessionCreated(session);
                }
            };
        }
        new ConnectToAliasCommand(Main.getApplication(), (SQLAlias)selectedAlias, true, completionCallback).execute();
        if (!this._chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        }
    }

    private void onGoto(IAliasesList al) {
        ISQLAlias selectedAlias = (ISQLAlias)this._lstResult.getSelectedValue();
        if (null == selectedAlias) {
            return;
        }
        IApplication app = Main.getApplication();
        AliasesListInternalFrame aliasesFrame = Main.getApplication().getWindowManager().getAliasesListInternalFrame();
        new ViewAliasesAction(app, aliasesFrame).actionPerformed(new ActionEvent(this._dlg, 1, "Dummy"));
        al.goToAlias(selectedAlias);
        if (!this._chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        } else {
            this._txtToSearch.requestFocus();
        }
    }

    private void updateList() {
        String filterText = this._txtToSearch.getText();
        Object formerSelectedValue = this._lstResult.getSelectedValue();
        Vector<ISQLAlias> allAliases = new Vector<ISQLAlias>(Main.getApplication().getDataCache().getAliasList());
        Vector<ISQLAlias> matchingAliases = new Vector<ISQLAlias>();
        for (ISQLAlias alias : allAliases) {
            if (!this.matches(alias, filterText)) continue;
            matchingAliases.add(alias);
        }
        Collections.sort(matchingAliases, new Comparator<ISQLAlias>(){

            @Override
            public int compare(ISQLAlias o1, ISQLAlias o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this._lstResult.setListData(matchingAliases);
        this._lstResult.setSelectedValue(formerSelectedValue, true);
        if (-1 == this._lstResult.getSelectedIndex()) {
            this._lstResult.setSelectedIndex(0);
            this._lstResult.ensureIndexIsVisible(0);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.onConnect();
        }
    }

    private boolean matches(ISQLAlias alias, String filterText) {
        if (StringUtilities.isEmpty(filterText, true)) {
            return true;
        }
        return null != alias.getName() && -1 < alias.getName().toLowerCase().indexOf(filterText.toLowerCase()) || null != alias.getUrl() && -1 < alias.getUrl().toLowerCase().indexOf(filterText.toLowerCase()) || null != alias.getUserName() && -1 < alias.getUserName().toLowerCase().indexOf(filterText.toLowerCase());
    }

    private JDialog createGui() {
        JDialog _dlg = new JDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("FindAliasesCtrl.find.alias"), false);
        Container pane = _dlg.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        pane.add((Component)new JLabel(s_stringMgr.getString("FindAliasesCtrl.enter.text")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pane.add((Component)this._txtToSearch, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        pane.add((Component)new JScrollPane(this._lstResult), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pane.add((Component)this._chkLeaveOpen, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pane.add((Component)this.createButtonPanel(), gbc);
        _dlg.setSize(this.getDimension());
        return _dlg;
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this._btnConnect, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this._btnGoto, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._btnClose, gbc);
        return ret;
    }

    private void onClosing() {
        Preferences.userRoot().putInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, this._dlg.getWidth());
        Preferences.userRoot().putInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, this._dlg.getHeight());
        Preferences.userRoot().putBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, this._chkLeaveOpen.isSelected());
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, 600), Preferences.userRoot().getInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, 400));
    }
}

