/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import com.jidesoft.swing.MultilineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.preferences.ColorIcon;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLPreferencesPanel
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPreferencesPanel.class);
    private SQLPrefsPanel _myPanel;
    private JScrollPane _myScrollPane;
    private IApplication _app;
    private MainFrame _mainFrame;

    public SQLPreferencesPanel(MainFrame mainFrame) {
        this._mainFrame = mainFrame;
    }

    @Override
    public void initialize(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this.getPanelComponent();
        this._myPanel.loadData(this._app, this._app.getSquirrelPreferences());
        this._myPanel._fileOpenInPreviousDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLPreferencesPanel.this.updateFilePanel(SQLPreferencesPanel.this._myPanel);
            }
        });
        this._myPanel._fileOpenInSpecifiedDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLPreferencesPanel.this.updateFilePanel(SQLPreferencesPanel.this._myPanel);
            }
        });
        this.updateFilePanel(this._myPanel);
        this._myPanel._fileChooseDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLPreferencesPanel.this.onChooseDir(SQLPreferencesPanel.this._myPanel);
            }
        });
    }

    @Override
    public void uninitialize(IApplication app) {
    }

    public void onChooseDir(SQLPrefsPanel pnl) {
        JFileChooser chooser = new JFileChooser(pnl._fileSpecifiedDir.getText());
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this._mainFrame);
        if (returnVal == 0) {
            pnl._fileSpecifiedDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void updateFilePanel(SQLPrefsPanel pnl) {
        pnl._fileChooseDir.setEnabled(pnl._fileOpenInSpecifiedDir.isSelected());
        pnl._fileSpecifiedDir.setEnabled(pnl._fileOpenInSpecifiedDir.isSelected());
    }

    @Override
    public synchronized Component getPanelComponent() {
        if (this._myPanel == null) {
            this._myPanel = new SQLPrefsPanel();
            this._myScrollPane = new JScrollPane(this._myPanel);
        }
        return this._myScrollPane;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._app.getSquirrelPreferences());
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLPreferencesPanel.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("SQLPreferencesPanel.hint");
    }

    private static final class SQLPrefsPanel
    extends JPanel {
        private IntegerField _loginTimeout = new IntegerField();
        private IntegerField _largeScriptStmtCount = new IntegerField();
        private JCheckBox _chkCopyQuotedSqlsToClip = new JCheckBox(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.copy.quoted.sql.to.clip"));
        private JCheckBox _chkAllowRunAllSQLsInEditor = new JCheckBox(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.allow.run.all.sqls.in.editor"));
        private JCheckBox _chkMarkCurrentSql = new JCheckBox(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.mark.current.sql"));
        private JButton _btnCurrentSqlMarkColorRGB = new JButton();
        private JCheckBox _chkReloadSqlContentsSql = new JCheckBox(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.reload.sql.contents"));
        private JRadioButton _debugJdbcDont = new JRadioButton(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.jdbcdebugdont"));
        private JRadioButton _debugJdbcStream = new JRadioButton(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.jdbcdebugstream"));
        private JRadioButton _debugJdbcWriter = new JRadioButton(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.jdbcdebugwriter"));
        private JLabel _jdbcDebugLogFileNameLbl = new OutputLabel(" ");
        private JRadioButton _fileOpenInPreviousDir = new JRadioButton(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.fileOpenInPreviousDir"));
        private JRadioButton _fileOpenInSpecifiedDir = new JRadioButton(SQLPreferencesPanel.access$600().getString("SQLPreferencesPanel.fileOpenInSpecifiedDir"));
        private JTextField _fileSpecifiedDir = new JTextField();
        private JButton _fileChooseDir = new JButton("...");

        SQLPrefsPanel() {
            super(new GridBagLayout());
            this.createUserInterface();
        }

        void loadData(IApplication app, SquirrelPreferences prefs) {
            ApplicationFiles appFiles = new ApplicationFiles();
            this._loginTimeout.setInt(prefs.getLoginTimeout());
            this._largeScriptStmtCount.setInt(prefs.getLargeScriptStmtCount());
            this._chkCopyQuotedSqlsToClip.setSelected(prefs.getCopyQuotedSqlsToClip());
            this._chkAllowRunAllSQLsInEditor.setSelected(prefs.getAllowRunAllSQLsInEditor());
            this._chkMarkCurrentSql.setSelected(prefs.isMarkCurrentSql());
            this.getCurrentSqlMarkColorIcon().setColor(new Color(prefs.getCurrentSqlMarkColorRGB()));
            this.initCurrentMarkGui();
            this._chkReloadSqlContentsSql.setSelected(prefs.isReloadSqlContents());
            this._debugJdbcStream.setSelected(prefs.isJdbcDebugToStream());
            this._debugJdbcWriter.setSelected(prefs.isJdbcDebugToWriter());
            this._debugJdbcDont.setSelected(prefs.isJdbcDebugDontDebug());
            this._jdbcDebugLogFileNameLbl.setText(appFiles.getJDBCDebugLogFile().getPath());
            this._fileOpenInPreviousDir.setSelected(prefs.isFileOpenInPreviousDir());
            this._fileOpenInSpecifiedDir.setSelected(prefs.isFileOpenInSpecifiedDir());
            this._fileSpecifiedDir.setText(prefs.getFileSpecifiedDir());
        }

        private ColorIcon getCurrentSqlMarkColorIcon() {
            return (ColorIcon)this._btnCurrentSqlMarkColorRGB.getIcon();
        }

        private void initCurrentMarkGui() {
            this._btnCurrentSqlMarkColorRGB.setEnabled(this._chkMarkCurrentSql.isSelected());
            this._chkMarkCurrentSql.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _btnCurrentSqlMarkColorRGB.setEnabled(_chkMarkCurrentSql.isSelected());
                }
            });
            this._btnCurrentSqlMarkColorRGB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onChooseCurrentMarkColor();
                }
            });
        }

        private void onChooseCurrentMarkColor() {
            String title = s_stringMgr.getString("SQLPreferencesPanel.current.sql.mark.color.choose");
            Color color = JColorChooser.showDialog(this, title, this.getCurrentSqlMarkColorIcon().getColor());
            if (null != color) {
                this.getCurrentSqlMarkColorIcon().setColor(color);
            }
        }

        void applyChanges(SquirrelPreferences prefs) {
            prefs.setLoginTimeout(this._loginTimeout.getInt());
            prefs.setLargeScriptStmtCount(this._largeScriptStmtCount.getInt());
            prefs.setCopyQuotedSqlsToClip(this._chkCopyQuotedSqlsToClip.isSelected());
            prefs.setAllowRunAllSQLsInEditor(this._chkAllowRunAllSQLsInEditor.isSelected());
            prefs.setMarkCurrentSql(this._chkMarkCurrentSql.isSelected());
            prefs.setCurrentSqlMarkColorRGB(this.getCurrentSqlMarkColorIcon().getColor().getRGB());
            prefs.setReloadSqlContents(this._chkReloadSqlContentsSql.isSelected());
            if (this._debugJdbcStream.isSelected()) {
                prefs.doJdbcDebugToStream();
            } else if (this._debugJdbcWriter.isSelected()) {
                prefs.doJdbcDebugToWriter();
            } else {
                prefs.dontDoJdbcDebug();
            }
            prefs.setFileOpenInPreviousDir(this._fileOpenInPreviousDir.isSelected());
            prefs.setFileOpenInSpecifiedDir(this._fileOpenInSpecifiedDir.isSelected());
            String specDir = this._fileSpecifiedDir.getText();
            prefs.setFileSpecifiedDir(null == specDir ? "" : specDir);
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.add((Component)this.createGeneralPanel(), gbc);
            ++gbc.gridy;
            this.add((Component)this.createDebugPanel(), gbc);
            ++gbc.gridy;
            this.add(this.createFilePanel(), gbc);
        }

        private JPanel createGeneralPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.general")));
            this._loginTimeout.setColumns(4);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.logintimeout")), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._loginTimeout, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.zerounlimited")), gbc);
            this._largeScriptStmtCount.setColumns(4);
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 1;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.largeScriptStmtCount")), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._largeScriptStmtCount, gbc);
            ++gbc.gridx;
            gbc.fill = 2;
            pnl.add((Component)new MultilineLabel(s_stringMgr.getString("SQLPreferencesPanel.largeScriptStmtCount.note")), gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 0;
            pnl.add((Component)this._chkCopyQuotedSqlsToClip, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 0;
            pnl.add((Component)this._chkAllowRunAllSQLsInEditor, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 0;
            gbc.fill = 0;
            pnl.add((Component)this.createCurrentSqlMarkPanel(), gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 0;
            gbc.fill = 0;
            pnl.add((Component)this._chkReloadSqlContentsSql, gbc);
            return pnl;
        }

        private JPanel createCurrentSqlMarkPanel() {
            JPanel ret = new JPanel(new BorderLayout(5, 0));
            ret.add((Component)this._chkMarkCurrentSql, "West");
            ret.add((Component)this._btnCurrentSqlMarkColorRGB, "Center");
            this._btnCurrentSqlMarkColorRGB.setHorizontalTextPosition(2);
            this._btnCurrentSqlMarkColorRGB.setIcon(new ColorIcon(16, 16));
            this._btnCurrentSqlMarkColorRGB.setText(s_stringMgr.getString("SQLPreferencesPanel.current.sql.mark.color"));
            return ret;
        }

        private JPanel createDebugPanel() {
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(this._debugJdbcDont);
            btnGroup.add(this._debugJdbcStream);
            btnGroup.add(this._debugJdbcWriter);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.debug")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 0;
            pnl.add((Component)this._debugJdbcDont, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._debugJdbcStream, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._debugJdbcWriter, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            pnl.add((Component)new JLabel(s_stringMgr.getString("SQLPreferencesPanel.jdbcdebugfile"), 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            pnl.add((Component)this._jdbcDebugLogFileNameLbl, gbc);
            return pnl;
        }

        private Component createFilePanel() {
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(this._fileOpenInPreviousDir);
            btnGroup.add(this._fileOpenInSpecifiedDir);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SQLPreferencesPanel.file")));
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnl.add((Component)this._fileOpenInPreviousDir, gbc);
            gbc = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
            pnl.add((Component)new JPanel(), gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
            pnl.add((Component)this._fileOpenInSpecifiedDir, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
            pnl.add((Component)this._fileSpecifiedDir, gbc);
            gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
            pnl.add((Component)this._fileChooseDir, gbc);
            return pnl;
        }
    }
}

