/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaLoadInfo;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaNameLoadInfo;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaTableTypeCombination;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoColumnCache;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaInfoCache
implements Serializable {
    private static final ILogger s_log = LoggerController.createLogger(SchemaInfoCache.class);
    private List<String> _catalogs = new ArrayList<String>();
    private List<String> _schemas = new ArrayList<String>();
    private TreeMap<CaseInsensitiveString, String> _keywords = new TreeMap();
    private TreeMap<CaseInsensitiveString, String> _dataTypes = new TreeMap();
    private Map<CaseInsensitiveString, String> _functions = Collections.synchronizedMap(new TreeMap());
    private TreeMap<CaseInsensitiveString, String> _internalTableNameTreeMap = new TreeMap();
    private Map<CaseInsensitiveString, String> _tableNames = Collections.synchronizedMap(this._internalTableNameTreeMap);
    private CopyOnWriteArrayList<ITableInfo> _iTableInfos = new CopyOnWriteArrayList();
    private Hashtable<CaseInsensitiveString, List<ITableInfo>> _tableInfosBySimpleName = new Hashtable();
    private SchemaInfoColumnCache _schemaInfoColumnCache = new SchemaInfoColumnCache();
    private Map<CaseInsensitiveString, String> _procedureNames = Collections.synchronizedMap(new TreeMap());
    private Map<IProcedureInfo, IProcedureInfo> _iProcedureInfos = Collections.synchronizedMap(new TreeMap());
    private Hashtable<CaseInsensitiveString, List<IProcedureInfo>> _procedureInfosBySimpleName = new Hashtable();
    private Map<CaseInsensitiveString, String> _udtNames = Collections.synchronizedMap(new TreeMap());
    private Map<IUDTInfo, IUDTInfo> _iUdtInfos = Collections.synchronizedMap(new TreeMap());
    private Hashtable<CaseInsensitiveString, List<IUDTInfo>> _udtInfosBySimpleName = new Hashtable();
    private SQLAliasSchemaProperties _schemaPropsCacheIsBasedOn;
    private transient String[] _viewTableTypesCacheable;
    private transient String[] _tabelTableTypesCacheable;
    private transient ISession _session = null;

    void setSession(ISession session) {
        this._session = session;
        this.initTypes();
    }

    boolean loadSchemaIndependentMetaData() {
        return this._session.getAlias().getSchemaProperties().loadSchemaIndependentMetaData(this._schemaPropsCacheIsBasedOn);
    }

    private SchemaLoadInfo[] getAllSchemaLoadInfos() {
        SQLAliasSchemaProperties schemaProps = this._session.getAlias().getSchemaProperties();
        SchemaLoadInfo[] schemaLoadInfos = schemaProps.fetchSchemaLoadInfos(this._schemaPropsCacheIsBasedOn, this._tabelTableTypesCacheable, this._viewTableTypesCacheable);
        SessionManager sessionMgr = this._session.getApplication().getSessionManager();
        boolean allSchemasAllowed = sessionMgr.areAllSchemasAllowed(this._session);
        if (1 == schemaLoadInfos.length && null == schemaLoadInfos[0].schemaName && !allSchemasAllowed && !allSchemasAllowed) {
            String[] allowedSchemas = sessionMgr.getAllowedSchemas(this._session);
            ArrayList<SchemaLoadInfo> ret = new ArrayList<SchemaLoadInfo>();
            for (int i = 0; i < allowedSchemas.length; ++i) {
                SchemaLoadInfo buf = (SchemaLoadInfo)Utilities.cloneObject(schemaLoadInfos[0], this.getClass().getClassLoader());
                buf.schemaName = allowedSchemas[i];
                ret.add(buf);
            }
            schemaLoadInfos = ret.toArray(new SchemaLoadInfo[ret.size()]);
        }
        return schemaLoadInfos;
    }

    SchemaLoadInfo[] getMatchingSchemaLoadInfos(String schemaName) {
        return this.getMatchingSchemaLoadInfos(schemaName, null);
    }

    SchemaLoadInfo[] getMatchingSchemaLoadInfos(String schemaName, String[] tableTypes) {
        if (null == schemaName) {
            return this.getAllSchemaLoadInfos();
        }
        SchemaLoadInfo[] schemaLoadInfos = this.getAllSchemaLoadInfos();
        for (int i = 0; i < schemaLoadInfos.length; ++i) {
            if (null != schemaLoadInfos[i].schemaName && !schemaLoadInfos[i].schemaName.equals(schemaName)) continue;
            schemaLoadInfos[i].schemaName = schemaName;
            if (null != tableTypes) {
                SchemaLoadInfo buf = (SchemaLoadInfo)Utilities.cloneObject(schemaLoadInfos[i], this.getClass().getClassLoader());
                buf.tableTypes = tableTypes;
                return new SchemaLoadInfo[]{buf};
            }
            return new SchemaLoadInfo[]{schemaLoadInfos[i]};
        }
        throw new IllegalArgumentException("Unknown Schema " + schemaName);
    }

    private void initTypes() {
        ArrayList<String> tableTypeCandidates = new ArrayList<String>();
        tableTypeCandidates.add("TABLE");
        tableTypeCandidates.add("SYSTEM TABLE");
        tableTypeCandidates.add("SYNONYM");
        ArrayList<String> viewTypeCandidates = new ArrayList<String>();
        viewTypeCandidates.add("VIEW");
        try {
            ArrayList<String> availableBuf = new ArrayList<String>();
            String[] buf = this._session.getSQLConnection().getSQLMetaData().getTableTypes();
            availableBuf.addAll(Arrays.asList(buf));
            Iterator i = tableTypeCandidates.iterator();
            while (i.hasNext()) {
                if (availableBuf.contains(i.next())) continue;
                i.remove();
            }
            i = viewTypeCandidates.iterator();
            while (i.hasNext()) {
                if (availableBuf.contains(i.next())) continue;
                i.remove();
            }
        }
        catch (SQLException e) {
            s_log.error("Could not get table types", e);
        }
        this._tabelTableTypesCacheable = tableTypeCandidates.toArray(new String[tableTypeCandidates.size()]);
        this._viewTableTypesCacheable = viewTypeCandidates.toArray(new String[viewTypeCandidates.size()]);
    }

    public boolean isCachedTableType(String type) {
        int i;
        boolean found = false;
        for (i = 0; i < this._viewTableTypesCacheable.length; ++i) {
            if (!this._viewTableTypesCacheable[i].equals(type)) continue;
            found = true;
            break;
        }
        for (i = 0; i < this._tabelTableTypesCacheable.length; ++i) {
            if (!this._tabelTableTypesCacheable[i].equals(type)) continue;
            found = true;
            break;
        }
        return found;
    }

    static boolean containsType(String[] types, String type) {
        if (null == types) {
            return true;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!type.trim().equalsIgnoreCase(types[i])) continue;
            return true;
        }
        return false;
    }

    public void writeToTableCache(ITableInfo[] infos) {
        for (ITableInfo info : infos) {
            String tableName = info.getSimpleName();
            CaseInsensitiveString ciTableName = new CaseInsensitiveString(tableName);
            this._tableNames.put(ciTableName, tableName);
            List<ITableInfo> aITabInfos = this._tableInfosBySimpleName.get(ciTableName);
            if (null == aITabInfos) {
                aITabInfos = new ArrayList<ITableInfo>();
                this._tableInfosBySimpleName.put(ciTableName, aITabInfos);
            }
            aITabInfos.add(info);
        }
        int currSize = this._iTableInfos.size();
        ITableInfo[] tableArr = this._iTableInfos.toArray(new ITableInfo[currSize + infos.length]);
        for (int i = 0; i < infos.length; ++i) {
            tableArr[currSize + i] = infos[i];
        }
        Arrays.sort(tableArr, new TableInfoSimpleNameComparator());
        this._iTableInfos = new CopyOnWriteArrayList<ITableInfo>(tableArr);
    }

    public void writeToProcedureCache(IProcedureInfo procedure) {
        String proc = procedure.getSimpleName();
        if (proc.length() > 0) {
            CaseInsensitiveString ciProc = new CaseInsensitiveString(proc);
            this._procedureNames.put(ciProc, proc);
            List<IProcedureInfo> aIProcInfos = this._procedureInfosBySimpleName.get(ciProc);
            if (null == aIProcInfos) {
                aIProcInfos = new ArrayList<IProcedureInfo>();
                this._procedureInfosBySimpleName.put(ciProc, aIProcInfos);
            }
            aIProcInfos.add(procedure);
        }
        this._iProcedureInfos.put(procedure, procedure);
    }

    public void writeToUDTCache(IUDTInfo udtInfo) {
        String udt = udtInfo.getSimpleName();
        if (udt.length() > 0) {
            CaseInsensitiveString ciudt = new CaseInsensitiveString(udt);
            this._udtNames.put(ciudt, udt);
            List<IUDTInfo> udtInfos = this._udtInfosBySimpleName.get(ciudt);
            if (null == udtInfos) {
                udtInfos = new ArrayList<IUDTInfo>();
                this._udtInfosBySimpleName.put(ciudt, udtInfos);
            }
            udtInfos.add(udtInfo);
        }
        this._iUdtInfos.put(udtInfo, udtInfo);
    }

    public void writeColumsToCache(TableColumnInfo[] infos, CaseInsensitiveString simpleTableName) {
        this._schemaInfoColumnCache.writeColumsToCache(infos, simpleTableName);
    }

    public void writeColumsNotAccessible(Throwable th, CaseInsensitiveString tableName) {
        this._schemaInfoColumnCache.writeColumsNotAccessible(th, tableName);
    }

    void initialLoadDone() {
        this._schemaPropsCacheIsBasedOn = null;
    }

    void prepareSerialization() {
        this._schemaPropsCacheIsBasedOn = this._session.getAlias().getSchemaProperties();
        if (!this._schemaPropsCacheIsBasedOn.isCacheSchemaIndependentMetaData()) {
            this.clearSchemaIndependentData();
        }
        if (0 == this._schemaPropsCacheIsBasedOn.getGlobalState()) {
            this.clearAllSchemaDependentData();
        } else if (2 == this._schemaPropsCacheIsBasedOn.getGlobalState()) {
            SchemaTableTypeCombination[] tableTypeCombis = this._schemaPropsCacheIsBasedOn.fetchAllSchemaTableTypeCombinationsNotToBeCached(this._tabelTableTypesCacheable, this._viewTableTypesCacheable);
            for (int i = 0; i < tableTypeCombis.length; ++i) {
                this.clearTables(null, tableTypeCombis[i].schemaName, null, tableTypeCombis[i].types);
            }
            String[] procedureSchemas = this._schemaPropsCacheIsBasedOn.fetchAllSchemaProceduresNotToBeCached();
            for (int i = 0; i < procedureSchemas.length; ++i) {
                this.clearStoredProcedures(null, procedureSchemas[i], null);
            }
            String[] udtSchemas = this._schemaPropsCacheIsBasedOn.fetchAllSchemaUDTsNotToBeCached();
            for (int i = 0; i < udtSchemas.length; ++i) {
                this.clearUDTs(null, udtSchemas[i], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllSchemaDependentData() {
        this._tableNames.clear();
        this._internalTableNameTreeMap.clear();
        CopyOnWriteArrayList<ITableInfo> copyOnWriteArrayList = this._iTableInfos;
        synchronized (copyOnWriteArrayList) {
            this._iTableInfos.clear();
        }
        this._tableInfosBySimpleName.clear();
        this._schemaInfoColumnCache.clearColumns();
        this._procedureNames.clear();
        this._iProcedureInfos.clear();
        this._procedureInfosBySimpleName.clear();
        this._schemas.clear();
    }

    private void clearSchemaIndependentData() {
        this._catalogs.clear();
        this._keywords.clear();
        this._dataTypes.clear();
        this._functions.clear();
    }

    void clearAllTableData() {
        this._iTableInfos = new CopyOnWriteArrayList();
        this._tableInfosBySimpleName = new Hashtable();
        this._tableNames = Collections.synchronizedMap(this._internalTableNameTreeMap);
    }

    void clearTables(String catalogName, String schemaName, String simpleName, String[] types) {
        for (ITableInfo ti : this._iTableInfos) {
            boolean matches = this.matchesMetaString(ti.getCatalogName(), catalogName);
            matches &= this.matchesMetaString(ti.getSchemaName(), schemaName);
            matches &= this.matchesMetaString(ti.getSimpleName(), simpleName);
            if (null != types) {
                boolean found = false;
                for (int j = 0; j < types.length; ++j) {
                    if (!types[j].equals(ti.getType())) continue;
                    found = true;
                    break;
                }
                matches &= found;
            }
            if (!matches) continue;
            this._iTableInfos.remove(ti);
            CaseInsensitiveString ciSimpleTableName = new CaseInsensitiveString(ti.getSimpleName());
            List<ITableInfo> tableInfos = this._tableInfosBySimpleName.get(ciSimpleTableName);
            tableInfos.remove(ti);
            if (0 == tableInfos.size()) {
                this._tableInfosBySimpleName.remove(ciSimpleTableName);
                this._tableNames.remove(ciSimpleTableName);
            }
            this._schemaInfoColumnCache.clearColumns(ciSimpleTableName);
        }
    }

    void clearStoredProcedures(String catalogName, String schemaName, String simpleName) {
        Iterator<IProcedureInfo> i = this._iProcedureInfos.keySet().iterator();
        while (i.hasNext()) {
            IProcedureInfo pi = i.next();
            boolean matches = this.matchesMetaString(pi.getCatalogName(), catalogName);
            matches &= this.matchesMetaString(pi.getSchemaName(), schemaName);
            if (!(matches &= this.matchesMetaString(pi.getSimpleName(), simpleName))) continue;
            i.remove();
            CaseInsensitiveString ciSimpleName = new CaseInsensitiveString(pi.getSimpleName());
            List<IProcedureInfo> procedureInfos = this._procedureInfosBySimpleName.get(ciSimpleName);
            procedureInfos.remove(pi);
            if (0 != procedureInfos.size()) continue;
            this._procedureInfosBySimpleName.remove(ciSimpleName);
            this._procedureNames.remove(ciSimpleName);
        }
    }

    void clearUDTs(String catalogName, String schemaName, String simpleName) {
        Iterator<IUDTInfo> i = this._iUdtInfos.keySet().iterator();
        while (i.hasNext()) {
            IUDTInfo udtInfo = i.next();
            boolean matches = this.matchesMetaString(udtInfo.getCatalogName(), catalogName);
            matches &= this.matchesMetaString(udtInfo.getSchemaName(), schemaName);
            if (!(matches &= this.matchesMetaString(udtInfo.getSimpleName(), simpleName))) continue;
            i.remove();
            CaseInsensitiveString ciSimpleName = new CaseInsensitiveString(udtInfo.getSimpleName());
            List<IUDTInfo> udtInfos = this._udtInfosBySimpleName.get(ciSimpleName);
            udtInfos.remove(udtInfo);
            if (0 != udtInfos.size()) continue;
            this._udtInfosBySimpleName.remove(ciSimpleName);
            this._udtNames.remove(ciSimpleName);
        }
    }

    private boolean matchesMetaString(String s, String toCheck) {
        if (null == s || null == toCheck) {
            return true;
        }
        return s.equals(toCheck);
    }

    SchemaNameLoadInfo getSchemaNameLoadInfo() {
        return this._session.getAlias().getSchemaProperties().fetchSchemaNameLoadInfo(this._schemaPropsCacheIsBasedOn);
    }

    void writeCatalogs(String[] catalogs) {
        this._catalogs.clear();
        this._catalogs.addAll(Arrays.asList(catalogs));
    }

    void writeSchemas(String[] schemasToWrite) {
        this._schemas.clear();
        this._schemas.addAll(Arrays.asList(schemasToWrite));
    }

    void writeKeywords(Hashtable<CaseInsensitiveString, String> keywordsBuf) {
        this._keywords.clear();
        this._keywords.putAll(keywordsBuf);
    }

    void writeDataTypes(Hashtable<CaseInsensitiveString, String> dataTypesBuf) {
        this._dataTypes.clear();
        this._dataTypes.putAll(dataTypesBuf);
    }

    void writeFunctions(Hashtable<CaseInsensitiveString, String> functionsBuf) {
        this._functions.clear();
        this._functions.putAll(functionsBuf);
    }

    List<String> getCatalogsForReadOnly() {
        return this._catalogs;
    }

    List<String> getSchemasForReadOnly() {
        return this._schemas;
    }

    TreeMap<CaseInsensitiveString, String> getKeywordsForReadOnly() {
        return this._keywords;
    }

    TreeMap<CaseInsensitiveString, String> getDataTypesForReadOnly() {
        return this._dataTypes;
    }

    Map<CaseInsensitiveString, String> getFunctionsForReadOnly() {
        return this._functions;
    }

    Map<CaseInsensitiveString, String> getTableNamesForReadOnly() {
        return this._internalTableNameTreeMap;
    }

    List<ITableInfo> getITableInfosForReadOnly() {
        return this._iTableInfos;
    }

    Hashtable<CaseInsensitiveString, List<ITableInfo>> getTableInfosBySimpleNameForReadOnly() {
        return this._tableInfosBySimpleName;
    }

    public boolean didTryLoadingColumns(CaseInsensitiveString tableName) {
        return this._schemaInfoColumnCache.didTryLoadingColumns(tableName);
    }

    public List<ExtendedColumnInfo> getExtendedColumnInfosForReadOnly(CaseInsensitiveString cissTableName) {
        return this._schemaInfoColumnCache.getExtendedColumnInfosForReadOnly(cissTableName);
    }

    Map<CaseInsensitiveString, List<ExtendedColumnInfo>> getExtColumnInfosByColumnNameForReadOnly() {
        return this._schemaInfoColumnCache.getExtColumnInfosByColumnNameForReadOnly();
    }

    Map<CaseInsensitiveString, String> getProcedureNamesForReadOnly() {
        return this._procedureNames;
    }

    Map<IProcedureInfo, IProcedureInfo> getIProcedureInfosForReadOnly() {
        return this._iProcedureInfos;
    }

    public Map<IUDTInfo, IUDTInfo> getIUDTInfosForReadOnly() {
        return this._iUdtInfos;
    }

    void replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM() {
        for (ITableInfo iTableInfo : this._iTableInfos) {
            if (!(iTableInfo instanceof TableInfo)) continue;
            ((TableInfo)iTableInfo).replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM();
        }
        for (IProcedureInfo iProcedureInfo : this._iProcedureInfos.keySet()) {
            if (!(iProcedureInfo instanceof DatabaseObjectInfo)) continue;
            ((DatabaseObjectInfo)((Object)iProcedureInfo)).replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM(DatabaseObjectType.PROCEDURE);
        }
    }

    private class TableInfoSimpleNameComparator
    implements Comparator<ITableInfo> {
        private TableInfoSimpleNameComparator() {
        }

        @Override
        public int compare(ITableInfo o1, ITableInfo o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    }
}

