/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.PopupEditableIOPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CellDataPopup {
    public static final String PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH = "Squirrel.popupEditableIOPanelWidth";
    public static final String PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT = "Squirrel.popupEditableIOPanelHeight";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataPopup.class);

    public static void showDialog(JTable table, ColumnDisplayDefinition colDef, MouseEvent evt, boolean isModelEditable) {
        CellDataPopup popup = new CellDataPopup();
        popup.createAndShowDialog(table, evt, colDef, isModelEditable);
    }

    private void createAndShowDialog(JTable table, MouseEvent evt, ColumnDisplayDefinition colDef, boolean isModelEditable) {
        Dimension dim;
        Point pt = evt.getPoint();
        int row = table.rowAtPoint(pt);
        int col = table.columnAtPoint(pt);
        Object obj = table.getValueAt(row, col);
        TableCellEditor editor = table.getCellEditor(row, col);
        if (editor != null) {
            editor.cancelCellEditing();
        }
        Window parent = SwingUtilities.windowForComponent(table);
        final TextAreaDialog dialog = new TextAreaDialog(table, table.getColumnName(col), colDef, obj, row, col, isModelEditable, table);
        dialog.pack();
        if (Main.getApplication().getSquirrelPreferences().isRememberValueOfPopup()) {
            int width = Preferences.userRoot().getInt(PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH, 600);
            int height = Preferences.userRoot().getInt(PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT, 300);
            dim = new Dimension(width, height);
        } else {
            dim = dialog.getSize();
            if (dim.width < 300) {
                dim.width = 300;
            }
            if (dim.height < 300) {
                dim.height = 300;
            }
            if (dim.width > 600) {
                dim.width = 600;
            }
            if (dim.height > 500) {
                dim.height = 500;
            }
        }
        Point parentBounds = parent.getLocation();
        parentBounds.x += SwingUtilities.convertPoint((Component)((Component)evt.getSource()), (Point)pt, (Component)parent).x;
        parentBounds.y += SwingUtilities.convertPoint((Component)((Component)evt.getSource()), (Point)pt, (Component)parent).y;
        dialog.setLocation(parentBounds);
        dialog.setSize(dim);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences.userRoot().putInt(CellDataPopup.PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH, dialog.getSize().width);
                Preferences.userRoot().putInt(CellDataPopup.PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT, dialog.getSize().height);
            }
        });
        dialog.setVisible(true);
    }

    class TextAreaDialog
    extends JDialog {
        public TextAreaDialog(Component comp, String columnName, ColumnDisplayDefinition colDef, Object value, int row, int col, boolean isModelEditable, JTable table) {
            super(SwingUtilities.windowForComponent(comp), s_stringMgr.getString("cellDataPopup.valueofColumn", columnName));
            ColumnDataPopupPanel popup = new ColumnDataPopupPanel(value, colDef, isModelEditable);
            popup.setUserActionInfo(this, row, col, table);
            this.setContentPane(popup);
            GUIUtils.enableCloseByEscape(this);
        }
    }

    private static class ColumnDataPopupPanel
    extends JPanel {
        private final PopupEditableIOPanel ioPanel;
        private JDialog _parentFrame = null;
        private int _row;
        private int _col;
        private JTable _table;

        ColumnDataPopupPanel(Object cellContents, ColumnDisplayDefinition colDef, boolean tableIsEditable) {
            super(new BorderLayout());
            if (tableIsEditable && CellComponentFactory.isEditableInPopup(colDef, cellContents)) {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, true);
                JPanel editingControls = this.createPopupEditingControls();
                this.add((Component)editingControls, "South");
            } else {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, false);
            }
            this.add((Component)this.ioPanel, "Center");
        }

        private JPanel createPopupEditingControls() {
            JPanel panel = new JPanel(new BorderLayout());
            JPanel updateControls = new JPanel();
            JButton updateButton = new JButton(s_stringMgr.getString("cellDataPopUp.updateData"));
            updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    StringBuffer messageBuffer = new StringBuffer();
                    Object newValue = ioPanel.getObject(messageBuffer);
                    if (messageBuffer.length() > 0) {
                        String msg = s_stringMgr.getString("cellDataPopUp.cannnotBGeConverted", messageBuffer);
                        JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("cellDataPopUp.conversionError"), 0);
                        ioPanel.requestFocus();
                    } else {
                        _table.setValueAt(newValue, _row, _col);
                        _parentFrame.setVisible(false);
                        _parentFrame.dispose();
                    }
                }
            });
            JButton cancelButton = new JButton(s_stringMgr.getString("cellDataPopup.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    _parentFrame.setVisible(false);
                    _parentFrame.dispose();
                }
            });
            updateControls.add(updateButton);
            updateControls.add(cancelButton);
            panel.add((Component)updateControls, "South");
            return panel;
        }

        public void setUserActionInfo(JDialog parent, int row, int col, JTable table) {
            this._parentFrame = parent;
            this._row = row;
            this._col = col;
            this._table = table;
        }
    }
}

