/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.squirrel_sql.fw.gui.CloseByEscapeListener;
import net.sourceforge.squirrel_sql.fw.util.BaseRuntimeException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class GUIUtils {
    private static final ILogger s_log = LoggerController.createLogger(GUIUtils.class);

    public static void centerWithinParent(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Container parent = wind.getParent();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(wind, new Rectangle(parent.getLocationOnScreen(), parent.getSize()));
        } else {
            GUIUtils.centerWithinScreen(wind);
        }
    }

    public static void centerWithinDesktop(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        JDesktopPane parent = frame.getDesktopPane();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(frame, new Rectangle(new Point(0, 0), parent.getSize()));
        }
    }

    public static void centerWithinScreen(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Rectangle rcScreen = new Rectangle(toolKit.getScreenSize());
        Dimension windSize = wind.getSize();
        Dimension parentSize = new Dimension(rcScreen.width, rcScreen.height);
        if (windSize.height > parentSize.height) {
            windSize.height = parentSize.height;
        }
        if (windSize.width > parentSize.width) {
            windSize.width = parentSize.width;
        }
        GUIUtils.center(wind, rcScreen);
    }

    public static void moveToFront(final JInternalFrame fr) {
        if (fr != null) {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    fr.moveToFront();
                    fr.setVisible(true);
                    try {
                        fr.setSelected(true);
                        if (fr.isIcon()) {
                            fr.setIcon(false);
                        }
                        fr.setSelected(true);
                    }
                    catch (PropertyVetoException ex) {
                        s_log.error("Error bringing internal frame to the front", ex);
                    }
                    fr.requestFocus();
                }
            });
        }
    }

    public static Frame getOwningFrame(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("null Component passed");
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return GUIUtils.getOwningFrame(SwingUtilities.windowForComponent(comp));
    }

    public static boolean isToolWindow(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        Object obj = frame.getClientProperty("JInternalFrame.isPalette");
        return obj != null && obj == Boolean.TRUE;
    }

    public static void makeToolWindow(JInternalFrame frame, boolean isToolWindow) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        frame.putClientProperty("JInternalFrame.isPalette", isToolWindow ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setJButtonSizesTheSame(JButton[] btns) {
        if (btns == null) {
            throw new IllegalArgumentException("null JButton[] passed");
        }
        Dimension maxSize = new Dimension(0, 0);
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            FontMetrics fm = btn.getFontMetrics(btn.getFont());
            Rectangle2D bounds = fm.getStringBounds(btn.getText(), btn.getGraphics());
            int boundsHeight = (int)bounds.getHeight();
            int boundsWidth = (int)bounds.getWidth();
            maxSize.width = boundsWidth > maxSize.width ? boundsWidth : maxSize.width;
            maxSize.height = boundsHeight > maxSize.height ? boundsHeight : maxSize.height;
        }
        Insets insets = btns[0].getInsets();
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            btn.setPreferredSize(maxSize);
        }
    }

    public static boolean isWithinParent(Component wind) {
        if (wind == null) {
            throw new IllegalArgumentException("Null Component passed");
        }
        Rectangle windowBounds = wind.getBounds();
        Container parent = wind.getParent();
        Rectangle parentRect = null;
        parentRect = parent != null ? new Rectangle(parent.getSize()) : GUIUtils.getScreenBoundsFor(windowBounds);
        return windowBounds.x >= parentRect.x - 20 && windowBounds.y >= parentRect.y - 20;
    }

    public static Rectangle getScreenBoundsFor(Rectangle rc) {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<GraphicsConfiguration> configs = new ArrayList<GraphicsConfiguration>();
        for (int i = 0; i < gds.length; ++i) {
            GraphicsConfiguration gc = gds[i].getDefaultConfiguration();
            if (!rc.intersects(gc.getBounds())) continue;
            configs.add(gc);
        }
        GraphicsConfiguration selected = null;
        if (configs.size() > 0) {
            for (GraphicsConfiguration gcc : configs) {
                if (selected == null) {
                    selected = gcc;
                    continue;
                }
                if (!gcc.getBounds().contains(rc.x + 20, rc.y + 20)) continue;
                selected = gcc;
                break;
            }
        } else {
            selected = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int x = selected.getBounds().x;
        int y = selected.getBounds().y;
        int w = selected.getBounds().width;
        int h = selected.getBounds().height;
        return new Rectangle(x, y, w, h);
    }

    public static void processOnSwingEventThread(Runnable todo) {
        GUIUtils.processOnSwingEventThread(todo, false);
    }

    public static void processOnSwingEventThread(Runnable todo, boolean wait) {
        if (todo == null) {
            throw new IllegalArgumentException("Runnable == null");
        }
        if (wait) {
            if (SwingUtilities.isEventDispatchThread()) {
                todo.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(todo);
                }
                catch (InvocationTargetException ex) {
                    throw new BaseRuntimeException(ex);
                }
                catch (InterruptedException ex) {
                    throw new BaseRuntimeException(ex);
                }
            }
        } else if (SwingUtilities.isEventDispatchThread()) {
            todo.run();
        } else {
            SwingUtilities.invokeLater(todo);
        }
    }

    private static void center(Component wind, Rectangle rect) {
        if (wind == null || rect == null) {
            throw new IllegalArgumentException("null Window or Rectangle passed");
        }
        Dimension windSize = wind.getSize();
        int x = (rect.width - windSize.width) / 2 + rect.x;
        int y = (rect.height - windSize.height) / 2 + rect.y;
        if (y < rect.y) {
            y = rect.y;
        }
        wind.setLocation(x, y);
    }

    public static String getWrappedLine(String line, int lineLength) {
        if (line.length() <= lineLength) {
            return line;
        }
        StringBuffer result = new StringBuffer();
        char[] lineChars = line.toCharArray();
        int lastBreakCharIdx = -1;
        ArrayList<Integer> breakPoints = new ArrayList<Integer>();
        for (int i = 0; i < lineChars.length; ++i) {
            char curr = lineChars[i];
            if (curr == ' ' || curr == ',') {
                lastBreakCharIdx = i;
            }
            if (i <= 0 || i % lineLength != 0 || lastBreakCharIdx == -1) continue;
            breakPoints.add(lastBreakCharIdx);
        }
        if (lastBreakCharIdx != lineChars.length) {
            breakPoints.add(lineChars.length);
        }
        int lastBreakPointIdx = 0;
        Iterator iter = breakPoints.iterator();
        while (iter.hasNext()) {
            int breakPointIdx = (Integer)iter.next() + 1;
            if (breakPointIdx > line.length()) {
                breakPointIdx = line.length();
            }
            String part = line.substring(lastBreakPointIdx, breakPointIdx);
            result.append(part.trim());
            if (!part.trim().endsWith("\\n")) {
                result.append("\n");
            }
            lastBreakPointIdx = breakPointIdx;
        }
        return result.toString();
    }

    public static Point getScreenLocationFor(Component component) {
        Component comp = component;
        Point ret = new Point(0, 0);
        while (true) {
            Point buf;
            if (comp instanceof Window) {
                buf = comp.getLocationOnScreen();
                ret.translate(buf.x, buf.y);
                return ret;
            }
            buf = comp.getLocation();
            ret.translate(buf.x, buf.y);
            comp = comp.getParent();
        }
    }

    public static void enableCloseByEscape(JDialog dialog) {
        GUIUtils.enableCloseByEscape(dialog, null);
    }

    public static void enableCloseByEscape(final JDialog dialog, final CloseByEscapeListener closeByEscapeListener) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != closeByEscapeListener) {
                    closeByEscapeListener.willCloseByEcape(dialog);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        dialog.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    public static DefaultMutableTreeNode createFolderNode(Object userObject) {
        DefaultMutableTreeNode newFolder = new DefaultMutableTreeNode(userObject){

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        return newFolder;
    }

    public static void forceFocus(final JComponent comp) {
        Timer[] timerRef;
        timerRef = new Timer[]{new Timer(100, new ActionListener(){
            private int maxCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (comp.hasFocus() || this.maxCount > 15) {
                    timerRef[0].stop();
                    return;
                }
                comp.requestFocusInWindow();
                comp.requestFocus();
                ++this.maxCount;
            }
        })};
        timerRef[0].setRepeats(true);
        timerRef[0].start();
        comp.requestFocusInWindow();
        comp.requestFocus();
    }
}

