/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.util.TranslucencyUtil;

class ChildWindowListener
extends ComponentAdapter
implements WindowFocusListener {
    public static final int TRANSLUCENT_NEVER = 0;
    public static final int TRANSLUCENT_WHEN_NOT_FOCUSED = 1;
    public static final int TRANSLUCENT_WHEN_OVERLAPPING_APP = 2;
    public static final int TRANSLUCENT_ALWAYS = 3;
    private RText app;
    private int translucencyRule;

    public ChildWindowListener(RText app) {
        this.app = app;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.translucencyRule == 2) {
            Window w = (Window)e.getComponent();
            if (!w.isShowing()) {
                return;
            }
            if (w == this.app) {
                this.refreshTranslucencies();
            } else {
                this.refreshTranslucency(w);
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Window w = (Window)e.getComponent();
        if (w != this.app) {
            this.refreshTranslucency(w);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.translucencyRule == 2) {
            Window w = (Window)e.getComponent();
            if (!w.isShowing()) {
                return;
            }
            if (w == this.app) {
                this.refreshTranslucencies();
            } else {
                this.refreshTranslucency(w);
            }
        }
    }

    void refreshTranslucency(Window window) {
        if (!this.app.isSearchWindowOpacityEnabled()) {
            this.setTranslucent(window, false);
            return;
        }
        switch (this.translucencyRule) {
            case 3: {
                this.setTranslucent(window, true);
                break;
            }
            case 0: {
                this.setTranslucent(window, false);
                break;
            }
            case 1: {
                this.setTranslucent(window, !window.isFocused());
                break;
            }
            case 2: {
                Point p1 = window.getLocationOnScreen();
                Rectangle bounds1 = window.getBounds();
                bounds1.setLocation(p1);
                Point p2 = this.app.getLocationOnScreen();
                Rectangle bounds2 = this.app.getBounds();
                bounds2.setLocation(p2);
                this.setTranslucent(window, bounds2.intersects(bounds1));
            }
        }
    }

    public void refreshTranslucencies() {
        AbstractMainView view = this.app.getMainView();
        view.getSearchManager().refreshDialogTranslucencies(this);
    }

    public void setTranslucencyRule(int rule) {
        if (rule >= 0 && rule <= 3 && rule != this.translucencyRule) {
            this.translucencyRule = rule;
            if (rule == 2) {
                this.app.addComponentListener(this);
            } else {
                this.app.removeComponentListener(this);
            }
            this.refreshTranslucencies();
        }
    }

    private void setTranslucent(Window w, boolean translucent) {
        float newOpacity;
        float curOpacity = TranslucencyUtil.get().getOpacity(w);
        float f = newOpacity = translucent ? this.app.getSearchWindowOpacity() : 1.0f;
        if (curOpacity != newOpacity) {
            TranslucencyUtil.get().setOpacity(w, newOpacity);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (this.translucencyRule == 1) {
            this.refreshTranslucency(e.getWindow());
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.translucencyRule == 1) {
            this.refreshTranslucency(e.getWindow());
        }
    }
}

