/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.fife.rtext.RTextEditorPane;

public class FileTypeIconManager {
    private Map<String, String> type2IconNameMap;
    private Map<String, Icon> iconName2IconMap;
    private Icon defaultIcon;
    private static final FileTypeIconManager INSTANCE = new FileTypeIconManager();
    private static final String PATH = "org/fife/rtext/graphics/file_icons/";
    private static final String DEFAULT_ICON_PATH = "org/fife/rtext/graphics/file_icons/txt.gif";

    private FileTypeIconManager() {
        ClassLoader cl = this.getClass().getClassLoader();
        this.defaultIcon = new ImageIcon(cl.getResource(DEFAULT_ICON_PATH));
        this.type2IconNameMap = new HashMap<String, String>();
        this.type2IconNameMap.put("text/c", "org/fife/rtext/graphics/file_icons/c.gif");
        this.type2IconNameMap.put("text/clojure", "org/fife/rtext/graphics/file_icons/clojure.png");
        this.type2IconNameMap.put("text/cpp", "org/fife/rtext/graphics/file_icons/cpp.gif");
        this.type2IconNameMap.put("text/cs", "org/fife/rtext/graphics/file_icons/cs.gif");
        this.type2IconNameMap.put("text/css", "org/fife/rtext/graphics/file_icons/css.png");
        this.type2IconNameMap.put("text/d", "org/fife/rtext/graphics/file_icons/d.png");
        this.type2IconNameMap.put("text/dart", "org/fife/rtext/graphics/file_icons/dart.png");
        this.type2IconNameMap.put("text/html", "org/fife/rtext/graphics/file_icons/html.png");
        this.type2IconNameMap.put("text/java", "org/fife/rtext/graphics/file_icons/java.png");
        this.type2IconNameMap.put("text/javascript", "org/fife/rtext/graphics/file_icons/script_code.png");
        this.type2IconNameMap.put("text/perl", "org/fife/rtext/graphics/file_icons/epic.gif");
        this.type2IconNameMap.put("text/php", "org/fife/rtext/graphics/file_icons/page_white_php.png");
        this.type2IconNameMap.put("text/sas", "org/fife/rtext/graphics/file_icons/sas.gif");
        this.type2IconNameMap.put("text/scala", "org/fife/rtext/graphics/file_icons/scala.png");
        this.type2IconNameMap.put("text/unix", "org/fife/rtext/graphics/file_icons/page_white_tux.png");
        this.type2IconNameMap.put("text/typescript", "org/fife/rtext/graphics/file_icons/ts.png");
        this.type2IconNameMap.put("text/bat", "org/fife/rtext/graphics/file_icons/bat.gif");
        this.type2IconNameMap.put("text/xml", "org/fife/rtext/graphics/file_icons/xml.png");
        this.iconName2IconMap = new HashMap<String, Icon>();
    }

    public Icon getIconFor(RTextEditorPane textArea) {
        Icon icon = null;
        String style = textArea.getSyntaxEditingStyle();
        if (style == null) {
            icon = this.defaultIcon;
        } else {
            String iconName = this.type2IconNameMap.get(style);
            if (iconName != null) {
                icon = this.iconName2IconMap.get(iconName);
                if (icon == null) {
                    ClassLoader cl = this.getClass().getClassLoader();
                    icon = new ImageIcon(cl.getResource(iconName));
                    this.iconName2IconMap.put(iconName, icon);
                }
            } else {
                icon = this.defaultIcon;
            }
        }
        return icon;
    }

    public static FileTypeIconManager get() {
        return INSTANCE;
    }

    public void setIconFor(String syntaxStyle, Icon icon) {
        this.type2IconNameMap.put(syntaxStyle, syntaxStyle);
        this.iconName2IconMap.put(syntaxStyle, icon);
    }

    static class TextAreaAwareIcon
    implements Icon,
    PropertyChangeListener {
        private Icon icon;
        private boolean paintModifiedMarker;

        public TextAreaAwareIcon(RTextEditorPane editorPane, Icon icon) {
            editorPane.addPropertyChangeListener(this);
            this.icon = icon;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
            if (this.paintModifiedMarker) {
                g.setColor(Color.RED);
                g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("TextEditorPane.dirty".equals(propertyName)) {
                this.paintModifiedMarker = (Boolean)e.getNewValue();
            }
        }
    }
}

