/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.fife.rtext.AbstractMainView;

class MainPanelTransferHandler
extends TransferHandler {
    private AbstractMainView mainView;
    private static final DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;

    public MainPanelTransferHandler(AbstractMainView mainView) {
        this.mainView = mainView;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return MainPanelTransferHandler.hasFileFlavor(flavors);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0;
    }

    public static boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        return MainPanelTransferHandler.importDataImpl(this.mainView, c, t);
    }

    public static boolean importDataImpl(AbstractMainView mainView, JComponent c, Transferable t) {
        if (MainPanelTransferHandler.hasFileFlavor(t.getTransferDataFlavors())) {
            try {
                List files = (List)t.getTransferData(fileFlavor);
                int count = files == null ? 0 : files.size();
                for (int i = 0; i < count; ++i) {
                    File file = (File)files.get(i);
                    mainView.openFile(file.getAbsolutePath(), null);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

