/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextActionInfo;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SearchManager;
import org.fife.rtext.SpellingSupport;
import org.fife.rtext.SyntaxFilters;
import org.fife.ui.OS;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationPrefs;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.RTextArea;

public class RTextPrefs
extends GUIApplicationPrefs<RText>
implements RTextActionInfo {
    public static final int DEFAULT_MAX_SPELLING_ERRORS = 30;
    public static final Color DEFAULT_SPELLING_ERROR_COLOR = new Color(255, 128, 64);
    public String iconGroupName;
    public boolean lineNumbersVisible;
    public int tabSize;
    public boolean emulateTabsWithSpaces;
    public int textMode;
    public int tabPlacement;
    public Font printFont;
    public Object backgroundObject;
    public float imageAlpha;
    public boolean wordWrap;
    public Color caretColor;
    public Color selectionColor;
    public Color selectedTextColor;
    public boolean useSelectedTextColor;
    public SyntaxScheme colorScheme;
    public String syntaxFiltersString;
    public int maxFileHistorySize;
    public String fileHistoryString;
    public boolean currentLineHighlightEnabled;
    public Color currentLineHighlightColor;
    public int mainView;
    public boolean highlightModifiedDocNames;
    public Color modifiedDocumentNamesColor;
    public boolean bracketMatchingEnabled;
    public boolean matchBothBrackets;
    public Color matchedBracketBGColor;
    public Color matchedBracketBorderColor;
    public boolean marginLineEnabled;
    public int marginLinePosition;
    public Color marginLineColor;
    public boolean highlightSecondaryLanguages;
    public Color[] secondaryLanguageColors;
    public boolean hyperlinksEnabled;
    public Color hyperlinkColor;
    public int hyperlinkModifierKey;
    public boolean visibleWhitespace;
    public boolean showEOLMarkers;
    public boolean showTabLines;
    public Color tabLinesColor;
    public boolean rememberWhitespaceLines;
    public boolean autoInsertClosingCurlys;
    public boolean aaEnabled;
    public boolean fractionalMetricsEnabled;
    public Color markAllHighlightColor;
    public boolean markOccurrences;
    public Color markOccurrencesColor;
    public int statusBarStyle;
    public boolean roundedSelectionEdges;
    public String workingDirectory;
    public int[] carets;
    public int caretBlinkRate;
    public boolean searchToolBarVisible;
    public int[] dividerLocations;
    public String defaultLineTerminator;
    public String defaultEncoding;
    public boolean guessFileContentType;
    public boolean doFileSizeCheck;
    public float maxFileSize;
    public boolean ignoreBackupExtensions;
    public Font textAreaFont;
    public boolean textAreaUnderline;
    public Color textAreaForeground;
    public ComponentOrientation textAreaOrientation;
    public Color foldBackground;
    public Color armedFoldBackground;
    public boolean showHostName;
    public boolean bomInUtf8;
    public boolean bookmarksEnabled;
    public Font lineNumberFont;
    public Color lineNumberColor;
    public Color gutterBorderColor;
    public boolean spellCheckingEnabled;
    public Color spellCheckingColor;
    public String spellingDictionary;
    public File userDictionary;
    public int maxSpellingErrors;
    public boolean viewSpellingList;
    public boolean searchWindowOpacityEnabled;
    public float searchWindowOpacity;
    public int searchWindowOpacityRule;
    public boolean dropShadowsInEditor;
    public String codeFoldingEnabledFor;
    public boolean useSearchDialogs;

    public RTextPrefs() {
        this.setDefaults();
    }

    public RTextPrefs populate(RText rtext) {
        AbstractMainView mainView = rtext.getMainView();
        SpellingSupport spelling = mainView.getSpellingSupport();
        RTextMenuBar menuBar = (RTextMenuBar)((Object)rtext.getJMenuBar());
        String lnfString = RTextUtilities.getLookAndFeelToSave();
        this.populateCommonPreferences((GUIApplication)rtext, lnfString);
        this.iconGroupName = rtext.getIconGroup().getName();
        this.lineNumbersVisible = mainView.getLineNumbersEnabled();
        this.tabSize = mainView.getTabSize();
        this.emulateTabsWithSpaces = mainView.areTabsEmulated();
        this.textMode = mainView.getTextMode();
        this.tabPlacement = mainView.getDocumentSelectionPlacement();
        this.printFont = mainView.getPrintFont();
        this.backgroundObject = mainView.getBackgroundObject();
        this.imageAlpha = mainView.getBackgroundImageAlpha();
        this.wordWrap = mainView.getLineWrap();
        this.caretColor = mainView.getCaretColor();
        this.selectionColor = mainView.getSelectionColor();
        this.selectedTextColor = mainView.getSelectedTextColor();
        this.useSelectedTextColor = mainView.getUseSelectedTextColor();
        this.colorScheme = rtext.getSyntaxScheme();
        this.syntaxFiltersString = mainView.getSyntaxFilters().toString();
        this.maxFileHistorySize = menuBar.getMaximumFileHistorySize();
        this.fileHistoryString = menuBar.getFileHistoryString();
        this.currentLineHighlightEnabled = mainView.isCurrentLineHighlightEnabled();
        this.currentLineHighlightColor = mainView.getCurrentLineHighlightColor();
        this.mainView = rtext.getMainViewStyle();
        this.highlightModifiedDocNames = mainView.highlightModifiedDocumentDisplayNames();
        this.modifiedDocumentNamesColor = mainView.getModifiedDocumentDisplayNamesColor();
        this.bracketMatchingEnabled = mainView.isBracketMatchingEnabled();
        this.matchBothBrackets = mainView.getMatchBothBrackets();
        this.matchedBracketBGColor = mainView.getMatchedBracketBGColor();
        this.matchedBracketBorderColor = mainView.getMatchedBracketBorderColor();
        this.marginLineEnabled = mainView.isMarginLineEnabled();
        this.marginLinePosition = mainView.getMarginLinePosition();
        this.marginLineColor = mainView.getMarginLineColor();
        this.highlightSecondaryLanguages = mainView.getHighlightSecondaryLanguages();
        this.secondaryLanguageColors = new Color[3];
        for (int i = 0; i < this.secondaryLanguageColors.length; ++i) {
            this.secondaryLanguageColors[i] = mainView.getSecondaryLanguageColor(i);
        }
        this.hyperlinksEnabled = mainView.getHyperlinksEnabled();
        this.hyperlinkColor = mainView.getHyperlinkColor();
        this.hyperlinkModifierKey = mainView.getHyperlinkModifierKey();
        this.visibleWhitespace = mainView.isWhitespaceVisible();
        this.showEOLMarkers = mainView.getShowEOLMarkers();
        this.showTabLines = mainView.getShowTabLines();
        this.tabLinesColor = mainView.getTabLinesColor();
        this.rememberWhitespaceLines = mainView.getRememberWhitespaceLines();
        this.autoInsertClosingCurlys = mainView.getAutoInsertClosingCurlys();
        this.aaEnabled = mainView.isAntiAliasEnabled();
        this.fractionalMetricsEnabled = mainView.isFractionalFontMetricsEnabled();
        this.markAllHighlightColor = mainView.getMarkAllHighlightColor();
        this.markOccurrences = mainView.getMarkOccurrences();
        this.markOccurrencesColor = mainView.getMarkOccurrencesColor();
        this.statusBarStyle = rtext.getStatusBar().getStyle();
        this.roundedSelectionEdges = mainView.getRoundedSelectionEdges();
        this.workingDirectory = rtext.getWorkingDirectory();
        this.carets[0] = mainView.getCaretStyle(0).ordinal();
        this.carets[1] = mainView.getCaretStyle(1).ordinal();
        this.caretBlinkRate = mainView.getCaretBlinkRate();
        this.searchToolBarVisible = rtext.isSearchToolBarVisible();
        this.dividerLocations[0] = rtext.getSplitPaneDividerLocation(0);
        this.dividerLocations[1] = rtext.getSplitPaneDividerLocation(1);
        this.dividerLocations[2] = rtext.getSplitPaneDividerLocation(2);
        this.dividerLocations[3] = rtext.getSplitPaneDividerLocation(3);
        this.defaultLineTerminator = mainView.getLineTerminator();
        this.defaultEncoding = mainView.getDefaultEncoding();
        this.guessFileContentType = mainView.getGuessFileContentType();
        this.doFileSizeCheck = mainView.getDoFileSizeCheck();
        this.maxFileSize = mainView.getMaxFileSize();
        this.ignoreBackupExtensions = mainView.getIgnoreBackupExtensions();
        this.textAreaFont = mainView.getTextAreaFont();
        this.textAreaUnderline = mainView.getTextAreaUnderline();
        this.textAreaForeground = mainView.getTextAreaForeground();
        this.textAreaOrientation = mainView.getTextAreaOrientation();
        this.foldBackground = mainView.getFoldBackground();
        this.armedFoldBackground = mainView.getArmedFoldBackground();
        this.showHostName = rtext.getShowHostName();
        this.bomInUtf8 = mainView.getWriteBOMInUtf8Files();
        this.bookmarksEnabled = mainView.getBookmarksEnabled();
        this.lineNumberFont = mainView.getLineNumberFont();
        this.lineNumberColor = mainView.getLineNumberColor();
        this.gutterBorderColor = mainView.getGutterBorderColor();
        this.spellCheckingEnabled = spelling.isSpellCheckingEnabled();
        this.spellCheckingColor = spelling.getSpellCheckingColor();
        this.spellingDictionary = spelling.getSpellingDictionary();
        this.userDictionary = spelling.getUserDictionary();
        this.maxSpellingErrors = spelling.getMaxSpellingErrors();
        this.viewSpellingList = rtext.isSpellingWindowVisible();
        this.searchWindowOpacityEnabled = rtext.isSearchWindowOpacityEnabled();
        this.searchWindowOpacity = rtext.getSearchWindowOpacity();
        this.searchWindowOpacityRule = rtext.getSearchWindowOpacityRule();
        this.dropShadowsInEditor = RTextUtilities.getDropShadowsEnabledInEditor();
        this.codeFoldingEnabledFor = mainView.getCodeFoldingEnabledForString();
        this.useSearchDialogs = mainView.getSearchManager().getSearchingMode() == SearchManager.SearchingMode.DIALOGS;
        return this;
    }

    private static boolean getDefaultDropShadowsInEditorValue() {
        return OS.get() == OS.WINDOWS;
    }

    private static Font getFontImpl(String str) {
        StringTokenizer t2 = new StringTokenizer(str, ",");
        String fontName = t2.nextToken();
        Font font = null;
        if (!fontName.equals("null")) {
            int fontSize = Integer.parseInt(t2.nextToken());
            boolean isBold = Boolean.valueOf(t2.nextToken());
            boolean isItalic = Boolean.valueOf(t2.nextToken());
            int fontStyle = 0;
            if (isBold) {
                fontStyle = isItalic ? 3 : 1;
            } else if (isItalic) {
                fontStyle = 2;
            }
            font = new Font(fontName, fontStyle, fontSize);
        }
        return font;
    }

    public static String getLookAndFeelToLoad() {
        Preferences prefs = Preferences.userNodeForPackage(RText.class);
        String defaultLAF = UIManager.getSystemLookAndFeelClassName();
        String laf = prefs.get("lookAndFeel", defaultLAF);
        return laf;
    }

    public RTextPrefs load() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(RText.class);
            this.loadCommonPreferences(prefs);
            this.iconGroupName = prefs.get("iconGroupName", this.iconGroupName);
            this.lineNumbersVisible = prefs.getBoolean("lineNumbersVisible", this.lineNumbersVisible);
            this.tabSize = prefs.getInt("tabSize", this.tabSize);
            this.mainView = prefs.getInt("mainView", this.mainView);
            String temp = prefs.get("colorScheme", null);
            this.colorScheme = SyntaxScheme.loadFromString((String)temp);
            this.statusBarStyle = prefs.getInt("statusBarStyle", this.statusBarStyle);
            this.workingDirectory = prefs.get("workingDirectory", this.workingDirectory);
            this.searchToolBarVisible = prefs.getBoolean("searchToolBarVisible", this.searchToolBarVisible);
            this.dividerLocations[0] = prefs.getInt("pluginDividerLocation.top", this.dividerLocations[0]);
            this.dividerLocations[1] = prefs.getInt("pluginDividerLocation.left", this.dividerLocations[1]);
            this.dividerLocations[2] = prefs.getInt("pluginDividerLocation.bottom", this.dividerLocations[2]);
            this.dividerLocations[3] = prefs.getInt("pluginDividerLocation.right", this.dividerLocations[3]);
            this.showHostName = prefs.getBoolean("showHostName", this.showHostName);
            this.bomInUtf8 = prefs.getBoolean("bomInUtf8", this.bomInUtf8);
            this.bookmarksEnabled = prefs.getBoolean("bookmarksEnabled", this.bookmarksEnabled);
            temp = prefs.get("lineNumberFont", null);
            if (temp != null) {
                this.lineNumberFont = RTextPrefs.getFontImpl(temp);
            }
            this.lineNumberColor = new Color(prefs.getInt("lineNumberColor", this.lineNumberColor.getRGB()));
            this.gutterBorderColor = new Color(prefs.getInt("gutterBorderColor", this.gutterBorderColor.getRGB()));
            prefs = Preferences.userNodeForPackage(AbstractMainView.class);
            this.bracketMatchingEnabled = prefs.getBoolean("bracketMatchingEnabled", this.bracketMatchingEnabled);
            this.matchBothBrackets = prefs.getBoolean("matchBothBrackets", this.matchBothBrackets);
            this.currentLineHighlightEnabled = prefs.getBoolean("currentLineHighlightEnabled", this.currentLineHighlightEnabled);
            this.emulateTabsWithSpaces = prefs.getBoolean("emulateTabs", this.emulateTabsWithSpaces);
            this.highlightModifiedDocNames = prefs.getBoolean("highlightModifiedDocNames", this.highlightModifiedDocNames);
            this.imageAlpha = prefs.getFloat("imageAlpha", this.imageAlpha);
            this.marginLineEnabled = prefs.getBoolean("marginLineEnabled", this.marginLineEnabled);
            this.marginLinePosition = prefs.getInt("marginLinePosition", this.marginLinePosition);
            this.syntaxFiltersString = prefs.get("syntaxFilters", this.syntaxFiltersString);
            this.textMode = prefs.getInt("textMode", this.textMode);
            this.tabPlacement = prefs.getInt("tabPlacement", this.tabPlacement);
            this.wordWrap = prefs.getBoolean("wordWrap", this.wordWrap);
            temp = prefs.get("printFont", null);
            if (temp != null) {
                this.printFont = RTextPrefs.getFontImpl(temp);
            }
            if ((temp = prefs.get("backgroundObject", null)) != null) {
                StringTokenizer t2 = new StringTokenizer(temp, ",");
                String temp2 = t2.nextToken();
                this.backgroundObject = temp2.equals("color") ? new Color(Integer.parseInt(temp.substring(temp.indexOf(44) + 1))) : (temp2.equals("image") ? t2.nextToken() : Color.WHITE);
            }
            RTextPrefs.possiblyFixSyntaxSchemeBackground(this);
            this.caretColor = new Color(prefs.getInt("caretColor", this.caretColor.getRGB()));
            this.selectionColor = new Color(prefs.getInt("selectionColor", this.selectionColor.getRGB()), true);
            this.selectedTextColor = new Color(prefs.getInt("selectedTextColor", this.selectedTextColor.getRGB()), true);
            this.useSelectedTextColor = prefs.getBoolean("useSelectedTextColor", this.useSelectedTextColor);
            this.currentLineHighlightColor = new Color(prefs.getInt("currentLineHighlightColor", this.currentLineHighlightColor.getRGB()), true);
            this.modifiedDocumentNamesColor = new Color(prefs.getInt("modifiedDocumentNamesColor", this.modifiedDocumentNamesColor.getRGB()));
            this.matchedBracketBGColor = new Color(prefs.getInt("matchedBracketBGColor", this.matchedBracketBGColor.getRGB()));
            this.matchedBracketBorderColor = new Color(prefs.getInt("matchedBracketBorderColor", this.matchedBracketBorderColor.getRGB()));
            this.marginLineColor = new Color(prefs.getInt("marginLineColor", this.marginLineColor.getRGB()));
            this.highlightSecondaryLanguages = prefs.getBoolean("highlightSecondaryLanguages", this.highlightSecondaryLanguages);
            for (int i = 0; i < this.secondaryLanguageColors.length; ++i) {
                this.secondaryLanguageColors[i] = new Color(prefs.getInt("secondaryLanguageColor_" + i, this.secondaryLanguageColors[i].getRGB()));
            }
            this.hyperlinksEnabled = prefs.getBoolean("hyperlinksEnabled", this.hyperlinksEnabled);
            this.hyperlinkColor = new Color(prefs.getInt("hyperlinkColor", this.hyperlinkColor.getRGB()));
            this.hyperlinkModifierKey = prefs.getInt("hyperlinkModifierKey", this.hyperlinkModifierKey);
            this.visibleWhitespace = prefs.getBoolean("visibleWhitespace", this.visibleWhitespace);
            this.showEOLMarkers = prefs.getBoolean("showEOL", this.showEOLMarkers);
            this.showTabLines = prefs.getBoolean("showTabLines", this.showTabLines);
            this.tabLinesColor = new Color(prefs.getInt("tabLinesColor", this.tabLinesColor.getRGB()));
            this.rememberWhitespaceLines = prefs.getBoolean("rememberWhitespaceLines", this.rememberWhitespaceLines);
            this.autoInsertClosingCurlys = prefs.getBoolean("autoInsertClosingCurlys", this.autoInsertClosingCurlys);
            this.aaEnabled = prefs.getBoolean("editorAntiAlias", this.aaEnabled);
            this.fractionalMetricsEnabled = prefs.getBoolean("fractionalMetrics", this.fractionalMetricsEnabled);
            this.markAllHighlightColor = new Color(prefs.getInt("markAllHighlightColor", this.markAllHighlightColor.getRGB()));
            this.markOccurrences = prefs.getBoolean("markOccurrences", this.markOccurrences);
            this.markOccurrencesColor = new Color(prefs.getInt("markOccurrencesColor", this.markOccurrencesColor.getRGB()));
            this.roundedSelectionEdges = prefs.getBoolean("roundedSelectionEdges", this.roundedSelectionEdges);
            this.carets[0] = prefs.getInt("insertCaretStyle", this.carets[0]);
            this.carets[1] = prefs.getInt("overwriteCaretStyle", this.carets[1]);
            this.caretBlinkRate = prefs.getInt("caretBlinkRate", this.caretBlinkRate);
            this.defaultLineTerminator = prefs.get("defaultLineTerminator", this.defaultLineTerminator);
            if ("".equals(this.defaultLineTerminator)) {
                this.defaultLineTerminator = null;
            }
            this.defaultEncoding = prefs.get("defaultEncoding", this.defaultEncoding);
            if ("".equals(this.defaultEncoding)) {
                this.defaultEncoding = null;
            }
            this.guessFileContentType = prefs.getBoolean("guessFileContentType", this.guessFileContentType);
            this.doFileSizeCheck = prefs.getBoolean("fileSizeCheck", this.doFileSizeCheck);
            this.maxFileSize = prefs.getFloat("maxFileSize", this.maxFileSize);
            this.ignoreBackupExtensions = prefs.getBoolean("ignoreBackupExtensions", this.ignoreBackupExtensions);
            temp = prefs.get("textAreaFont", null);
            if (temp != null) {
                this.textAreaFont = RTextPrefs.getFontImpl(temp);
            }
            this.textAreaUnderline = prefs.getBoolean("textAreaUnderline", this.textAreaUnderline);
            this.textAreaForeground = new Color(prefs.getInt("textAreaForeground", this.textAreaForeground.getRGB()));
            temp = prefs.get("textAreaOrientation", "ltr");
            this.textAreaOrientation = "rtl".equals(temp) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
            this.foldBackground = new Color(prefs.getInt("foldBackground", this.foldBackground.getRGB()));
            this.armedFoldBackground = new Color(prefs.getInt("armedFoldBackground", this.armedFoldBackground.getRGB()));
            this.spellCheckingEnabled = prefs.getBoolean("spellCheckingEnabled", this.spellCheckingEnabled);
            this.spellCheckingColor = new Color(prefs.getInt("spellCheckingColor", this.spellCheckingColor.getRGB()));
            this.spellingDictionary = prefs.get("spellingDictionary", this.spellingDictionary);
            String tempVal = prefs.get("userDictionary", null);
            if (tempVal != null) {
                this.userDictionary = tempVal.length() == 0 ? null : new File(tempVal);
            }
            this.maxSpellingErrors = prefs.getInt("maxSpellingErrors", this.maxSpellingErrors);
            this.viewSpellingList = prefs.getBoolean("viewSpellingList", this.viewSpellingList);
            this.searchWindowOpacityEnabled = prefs.getBoolean("searchWindowOpacityEnabled", this.searchWindowOpacityEnabled);
            this.searchWindowOpacity = prefs.getFloat("searchWindowOpacity", this.searchWindowOpacity);
            this.searchWindowOpacityRule = prefs.getInt("searchWindowOpacityRule", this.searchWindowOpacityRule);
            this.dropShadowsInEditor = prefs.getBoolean("dropShadowsInEditor", RTextPrefs.getDefaultDropShadowsInEditorValue());
            this.codeFoldingEnabledFor = prefs.get("codeFoldingEnabledFor", this.codeFoldingEnabledFor);
            this.useSearchDialogs = prefs.getBoolean("useSearchDialogs", this.useSearchDialogs);
            prefs = Preferences.userNodeForPackage(RTextMenuBar.class);
            this.fileHistoryString = prefs.get("fileHistoryString", this.fileHistoryString);
            this.maxFileHistorySize = prefs.getInt("maxFileHistorySize", this.maxFileHistorySize);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setDefaults();
        }
        return this;
    }

    private static void possiblyFixSyntaxSchemeBackground(RTextPrefs props) {
        Object bgObj = props.backgroundObject;
        if (bgObj instanceof Color) {
            Color color = (Color)bgObj;
            for (int i = 0; i < props.colorScheme.getStyleCount(); ++i) {
                Style s = props.colorScheme.getStyle(i);
                if (s == null || !color.equals(s.background)) continue;
                s.background = null;
            }
        }
    }

    public void save() {
        Preferences prefs = Preferences.userNodeForPackage(RText.class);
        this.saveCommonPreferences(prefs);
        prefs.put("colorScheme", this.colorScheme.toCommaSeparatedString());
        prefs.put("iconGroupName", this.iconGroupName);
        prefs.putBoolean("lineNumbersVisible", this.lineNumbersVisible);
        prefs.putInt("mainView", this.mainView);
        prefs.putInt("statusBarStyle", this.statusBarStyle);
        prefs.put("workingDirectory", this.workingDirectory);
        prefs.putBoolean("searchToolBarVisible", this.searchToolBarVisible);
        prefs.putInt("pluginDividerLocation.top", this.dividerLocations[0]);
        prefs.putInt("pluginDividerLocation.left", this.dividerLocations[1]);
        prefs.putInt("pluginDividerLocation.bottom", this.dividerLocations[2]);
        prefs.putInt("pluginDividerLocation.right", this.dividerLocations[3]);
        prefs.putBoolean("showHostName", this.showHostName);
        prefs.putBoolean("bomInUtf8", this.bomInUtf8);
        prefs.putBoolean("bookmarksEnabled", this.bookmarksEnabled);
        prefs.put("lineNumberFont", this.lineNumberFont == null ? "null" : this.lineNumberFont.getName() + "," + this.lineNumberFont.getSize() + "," + this.lineNumberFont.isBold() + "," + this.lineNumberFont.isItalic());
        prefs.putInt("lineNumberColor", this.lineNumberColor.getRGB());
        prefs.putInt("gutterBorderColor", this.gutterBorderColor.getRGB());
        prefs = Preferences.userNodeForPackage(AbstractMainView.class);
        prefs.putBoolean("bracketMatchingEnabled", this.bracketMatchingEnabled);
        prefs.putBoolean("matchBothBrackets", this.matchBothBrackets);
        prefs.putInt("caretColor", this.caretColor.getRGB());
        prefs.putInt("currentLineHighlightColor", this.currentLineHighlightColor.getRGB());
        prefs.putBoolean("currentLineHighlightEnabled", this.currentLineHighlightEnabled);
        prefs.putBoolean("emulateTabs", this.emulateTabsWithSpaces);
        prefs.putBoolean("highlightModifiedDocNames", this.highlightModifiedDocNames);
        prefs.putFloat("imageAlpha", this.imageAlpha);
        prefs.putInt("marginLineColor", this.marginLineColor.getRGB());
        prefs.putBoolean("highlightSecondaryLanguages", this.highlightSecondaryLanguages);
        for (int i = 0; i < 3; ++i) {
            prefs.putInt("secondaryLanguageColor_" + i, this.secondaryLanguageColors[i].getRGB());
        }
        prefs.putBoolean("hyperlinksEnabled", this.hyperlinksEnabled);
        prefs.putInt("hyperlinkColor", this.hyperlinkColor.getRGB());
        prefs.putInt("hyperlinkModifierKey", this.hyperlinkModifierKey);
        prefs.putBoolean("marginLineEnabled", this.marginLineEnabled);
        prefs.putInt("marginLinePosition", this.marginLinePosition);
        prefs.putInt("matchedBracketBGColor", this.matchedBracketBGColor.getRGB());
        prefs.putInt("matchedBracketBorderColor", this.matchedBracketBorderColor.getRGB());
        prefs.putInt("modifiedDocumentNamesColor", this.modifiedDocumentNamesColor.getRGB());
        prefs.put("printFont", this.printFont == null ? "null" : this.printFont.getName() + "," + this.printFont.getSize() + "," + this.printFont.isBold() + "," + this.printFont.isItalic());
        prefs.putInt("selectionColor", this.selectionColor.getRGB());
        prefs.putInt("selectedTextColor", this.selectedTextColor.getRGB());
        prefs.putBoolean("useSelectedTextColor", this.useSelectedTextColor);
        prefs.put("syntaxFilters", this.syntaxFiltersString);
        prefs.putInt("tabSize", this.tabSize);
        prefs.putInt("tabPlacement", this.tabPlacement);
        prefs.putInt("textMode", this.textMode);
        prefs.putBoolean("wordWrap", this.wordWrap);
        if (this.backgroundObject instanceof Color) {
            Color c = (Color)this.backgroundObject;
            prefs.put("backgroundObject", "color," + c.getRGB());
        } else if (this.backgroundObject instanceof Image) {
            prefs.put("backgroundObject", "color," + Color.WHITE);
        }
        prefs.putBoolean("visibleWhitespace", this.visibleWhitespace);
        prefs.putBoolean("showEOL", this.showEOLMarkers);
        prefs.putBoolean("showTabLines", this.showTabLines);
        prefs.putInt("tabLinesColor", this.tabLinesColor.getRGB());
        prefs.putBoolean("rememberWhitespaceLines", this.rememberWhitespaceLines);
        prefs.putBoolean("autoInsertClosingCurlys", this.autoInsertClosingCurlys);
        prefs.putBoolean("editorAntiAlias", this.aaEnabled);
        prefs.putBoolean("fractionalMetrics", this.fractionalMetricsEnabled);
        prefs.putInt("markAllHighlightColor", this.markAllHighlightColor.getRGB());
        prefs.putBoolean("markOccurrences", this.markOccurrences);
        prefs.putInt("markOccurrencesColor", this.markOccurrencesColor.getRGB());
        prefs.putBoolean("roundedSelectionEdges", this.roundedSelectionEdges);
        prefs.putInt("insertCaretStyle", this.carets[0]);
        prefs.putInt("overwriteCaretStyle", this.carets[1]);
        prefs.putInt("caretBlinkRate", this.caretBlinkRate);
        prefs.put("defaultLineTerminator", this.defaultLineTerminator == null ? "" : this.defaultLineTerminator);
        prefs.put("defaultEncoding", this.defaultEncoding == null ? "" : this.defaultEncoding);
        prefs.putBoolean("guessFileContentType", this.guessFileContentType);
        prefs.putBoolean("fileSizeCheck", this.doFileSizeCheck);
        prefs.putFloat("maxFileSize", this.maxFileSize);
        prefs.putBoolean("ignoreBackupExtensions", this.ignoreBackupExtensions);
        prefs.put("textAreaFont", this.textAreaFont == null ? "null" : this.textAreaFont.getName() + "," + this.textAreaFont.getSize() + "," + this.textAreaFont.isBold() + "," + this.textAreaFont.isItalic());
        prefs.putBoolean("textAreaUnderline", this.textAreaUnderline);
        prefs.putInt("textAreaForeground", this.textAreaForeground.getRGB());
        prefs.put("textAreaOrientation", this.textAreaOrientation.isLeftToRight() ? "ltr" : "rtl");
        prefs.putInt("foldBackground", this.foldBackground.getRGB());
        prefs.putInt("armedFoldBackground", this.armedFoldBackground.getRGB());
        prefs.putBoolean("spellCheckingEnabled", this.spellCheckingEnabled);
        prefs.putInt("spellCheckingColor", this.spellCheckingColor.getRGB());
        prefs.put("spellingDictionary", this.spellingDictionary);
        prefs.put("userDictionary", this.userDictionary == null ? "" : this.userDictionary.getAbsolutePath());
        prefs.putInt("maxSpellingErrors", this.maxSpellingErrors);
        prefs.putBoolean("viewSpellingList", this.viewSpellingList);
        prefs.putBoolean("searchWindowOpacityEnabled", this.searchWindowOpacityEnabled);
        prefs.putFloat("searchWindowOpacity", this.searchWindowOpacity);
        prefs.putInt("searchWindowOpacityRule", this.searchWindowOpacityRule);
        prefs.putBoolean("dropShadowsInEditor", this.dropShadowsInEditor);
        prefs.put("codeFoldingEnabledFor", this.codeFoldingEnabledFor);
        prefs.putBoolean("useSearchDialogs", this.useSearchDialogs);
        prefs = Preferences.userNodeForPackage(RTextMenuBar.class);
        prefs.put("fileHistoryString", this.fileHistoryString == null ? "-" : this.fileHistoryString);
        prefs.putInt("maxFileHistorySize", this.maxFileHistorySize);
        prefs = null;
    }

    protected void setDefaults() {
        this.location = new Point(0, 0);
        this.size = new Dimension(650, 500);
        this.lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        this.iconGroupName = "Eclipse Icons";
        this.toolbarVisible = true;
        this.statusBarVisible = true;
        this.lineNumbersVisible = false;
        this.tabSize = 5;
        this.emulateTabsWithSpaces = false;
        this.textMode = 0;
        this.tabPlacement = 1;
        this.printFont = null;
        this.backgroundObject = Color.WHITE;
        this.imageAlpha = 0.3f;
        this.wordWrap = false;
        this.caretColor = RTextArea.getDefaultCaretColor();
        this.selectionColor = RSyntaxTextArea.getDefaultSelectionColor();
        this.selectedTextColor = Color.white;
        this.useSelectedTextColor = false;
        this.colorScheme = new SyntaxScheme(true);
        SyntaxFilters syntaxFilters = new SyntaxFilters();
        syntaxFilters.restoreDefaultFileFilters();
        this.syntaxFiltersString = syntaxFilters.toString();
        this.maxFileHistorySize = 20;
        this.fileHistoryString = null;
        this.currentLineHighlightEnabled = true;
        this.currentLineHighlightColor = RTextArea.getDefaultCurrentLineHighlightColor();
        this.mainView = 0;
        this.highlightModifiedDocNames = true;
        this.modifiedDocumentNamesColor = Color.RED;
        this.language = "en";
        this.bracketMatchingEnabled = true;
        this.matchBothBrackets = false;
        this.matchedBracketBGColor = RSyntaxTextArea.getDefaultBracketMatchBGColor();
        this.matchedBracketBorderColor = RSyntaxTextArea.getDefaultBracketMatchBorderColor();
        this.marginLineEnabled = true;
        this.marginLinePosition = RTextArea.getDefaultMarginLinePosition();
        this.marginLineColor = RTextArea.getDefaultMarginLineColor();
        this.highlightSecondaryLanguages = false;
        this.secondaryLanguageColors = new Color[3];
        this.secondaryLanguageColors[0] = new Color(0xFFF0CC);
        this.secondaryLanguageColors[1] = new Color(14352090);
        this.secondaryLanguageColors[2] = new Color(0xFFE0F0);
        this.hyperlinksEnabled = true;
        this.hyperlinkColor = Color.BLUE;
        this.hyperlinkModifierKey = 128;
        this.visibleWhitespace = false;
        this.showEOLMarkers = false;
        this.showTabLines = false;
        this.tabLinesColor = Color.gray;
        this.rememberWhitespaceLines = true;
        this.autoInsertClosingCurlys = false;
        this.aaEnabled = File.separatorChar == '\\' || System.getProperty("os.name").contains("mac os x");
        this.fractionalMetricsEnabled = false;
        this.markAllHighlightColor = RTextArea.getDefaultMarkAllHighlightColor();
        this.markOccurrences = true;
        this.markOccurrencesColor = new Color(224, 224, 224);
        this.statusBarStyle = 1;
        this.roundedSelectionEdges = false;
        this.workingDirectory = System.getProperty("user.dir");
        this.carets = new int[2];
        this.carets[0] = CaretStyle.THICK_VERTICAL_LINE_STYLE.ordinal();
        this.carets[1] = CaretStyle.BLOCK_STYLE.ordinal();
        this.caretBlinkRate = 500;
        this.searchToolBarVisible = false;
        this.dividerLocations = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.dividerLocations[i] = -1;
        }
        this.defaultLineTerminator = null;
        this.defaultEncoding = null;
        this.guessFileContentType = true;
        this.doFileSizeCheck = true;
        this.maxFileSize = 10.0f;
        this.ignoreBackupExtensions = true;
        this.textAreaFont = RTextArea.getDefaultFont();
        this.textAreaUnderline = false;
        this.textAreaForeground = RTextArea.getDefaultForeground();
        this.textAreaOrientation = ComponentOrientation.LEFT_TO_RIGHT;
        this.foldBackground = Color.WHITE;
        this.armedFoldBackground = Color.WHITE;
        this.showHostName = false;
        this.bomInUtf8 = false;
        this.bookmarksEnabled = true;
        this.lineNumberFont = new Font("Monospaced", 0, 12);
        this.lineNumberColor = Color.GRAY;
        this.gutterBorderColor = new Color(221, 221, 221);
        this.spellCheckingEnabled = File.separatorChar == '\\';
        this.spellCheckingColor = DEFAULT_SPELLING_ERROR_COLOR;
        this.spellingDictionary = SpellingSupport.DICTIONARIES[1];
        this.userDictionary = new File(RTextUtilities.getPreferencesDirectory(), "userDictionary.txt");
        this.maxSpellingErrors = 30;
        this.viewSpellingList = false;
        this.searchWindowOpacityEnabled = false;
        this.searchWindowOpacity = 0.6f;
        this.searchWindowOpacityRule = 2;
        this.dropShadowsInEditor = RTextPrefs.getDefaultDropShadowsInEditorValue();
        this.codeFoldingEnabledFor = "";
        this.useSearchDialogs = true;
    }

    public String toString() {
        return "[Class: RTextPreferences]";
    }
}

