/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.RTextPrefs;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.spell.SpellingParser;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserEvent;
import org.fife.ui.rsyntaxtextarea.spell.event.SpellingParserListener;

public class SpellingSupport
implements SpellingParserListener {
    public static final String[] DICTIONARIES = new String[]{"BritishEnglish", "AmericanEnglish"};
    private RText rtext;
    private SpellingParser spellingParser;
    private boolean spellCheckingEnabled;
    private Color spellCheckingColor;
    private String spellingDictionary;
    private File userDictionary;
    private int maxSpellingErrors;
    private ViewSpellingErrorWindowAction vsewAction;
    private static final String VIEW_SPELLING_ERROR_WINDOW = "viewSpellingErrorWindowAction";

    public SpellingSupport(RText rtext) {
        this.rtext = rtext;
    }

    private void addViewErrorWindowMenuItem() {
        this.vsewAction = new ViewSpellingErrorWindowAction(this.rtext);
        this.rtext.addAction(VIEW_SPELLING_ERROR_WINDOW, (Action)((Object)this.vsewAction));
        RTextMenuBar mb = (RTextMenuBar)((Object)this.rtext.getJMenuBar());
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem((Action)((Object)this.vsewAction));
        item.applyComponentOrientation(this.rtext.getComponentOrientation());
        JMenu viewMenu = mb.getMenuByName("DockedWindows");
        viewMenu.add(item);
        JPopupMenu popup = viewMenu.getPopupMenu();
        popup.pack();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                item.setSelected(SpellingSupport.this.rtext.isSpellingWindowVisible());
            }
        });
    }

    void configure(RTextPrefs prefs) {
        this.setSpellCheckingEnabled(prefs.spellCheckingEnabled);
        this.setSpellCheckingColor(prefs.spellCheckingColor);
        this.setSpellingDictionary(prefs.spellingDictionary);
        this.setMaxSpellingErrors(prefs.maxSpellingErrors);
        this.setUserDictionary(prefs.userDictionary);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpellingSupport.this.addViewErrorWindowMenuItem();
            }
        });
    }

    private void createSpellingParser() throws IOException {
        String fileName = "english_dic.zip";
        File file = new File(this.rtext.getInstallLocation(), fileName);
        try {
            boolean american = DICTIONARIES[1].equals(this.spellingDictionary);
            this.spellingParser = SpellingParser.createEnglishSpellingParser((File)file, (boolean)american);
            this.spellingParser.setSquiggleUnderlineColor(this.getSpellCheckingColor());
            this.spellingParser.setMaxErrorCount(this.getMaxSpellingErrors());
            this.spellingParser.setAllowAdd(true);
            this.spellingParser.setAllowIgnore(true);
            this.spellingParser.addSpellingParserListener((SpellingParserListener)this);
            try {
                if (this.userDictionary != null && !this.userDictionary.exists()) {
                    this.userDictionary.getParentFile().mkdirs();
                    this.userDictionary.createNewFile();
                }
                this.spellingParser.setUserDictionary(this.userDictionary);
            }
            catch (IOException ioe) {
                String desc = this.rtext.getString("Error.LoadingUserDictionary.txt", new Object[]{this.userDictionary == null ? "null" : this.userDictionary.getAbsolutePath(), ioe.getMessage()});
                this.rtext.displayException(ioe, desc);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Error opening zip file: " + file.getAbsolutePath());
        }
    }

    public void forceSpellCheck(RTextEditorPane textArea) {
        textArea.forceReparsing((Parser)this.spellingParser);
    }

    public int getMaxSpellingErrors() {
        return this.maxSpellingErrors;
    }

    public Color getSpellCheckingColor() {
        return this.spellCheckingColor;
    }

    public String getSpellingDictionary() {
        return this.spellingDictionary;
    }

    SpellingParser getSpellingParser() {
        return this.spellingParser;
    }

    public File getUserDictionary() {
        return this.userDictionary;
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    private void recheckSpelling() {
        AbstractMainView view = this.rtext.getMainView();
        for (int i = 0; i < view.getNumDocuments(); ++i) {
            RTextEditorPane textArea = view.getRTextEditorPaneAt(i);
            textArea.forceReparsing((Parser)this.spellingParser);
        }
    }

    public void setMaxSpellingErrors(int max) {
        if (max >= 0 && max != this.maxSpellingErrors) {
            this.maxSpellingErrors = max;
            if (this.spellingParser != null && this.isSpellCheckingEnabled()) {
                this.spellingParser.setMaxErrorCount(this.maxSpellingErrors);
                this.recheckSpelling();
            }
        }
    }

    public void setSpellCheckingColor(Color color) {
        if (color != null && color != this.spellCheckingColor) {
            this.spellCheckingColor = color;
            if (this.spellingParser != null) {
                this.spellingParser.setSquiggleUnderlineColor(this.spellCheckingColor);
                this.rtext.getMainView().repaint();
            }
        }
    }

    public void setSpellCheckingEnabled(boolean enabled) {
        if (enabled != this.spellCheckingEnabled) {
            this.spellCheckingEnabled = enabled;
            if (enabled && this.spellingParser == null) {
                new Thread(new CreateParserRunnable()).start();
            } else {
                this.toggleSpellingParserInstalled();
            }
        }
    }

    public void setSpellingDictionary(String dict) {
        if (dict != null && !dict.equals(this.spellingDictionary)) {
            RTextEditorPane textArea;
            int i;
            boolean valid = false;
            for (int i2 = 0; i2 < DICTIONARIES.length; ++i2) {
                if (!DICTIONARIES[i2].equals(dict)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                dict = DICTIONARIES[1];
            }
            this.spellingDictionary = dict;
            AbstractMainView view = this.rtext.getMainView();
            if (view != null && this.spellingParser != null && this.isSpellCheckingEnabled()) {
                for (i = 0; i < view.getNumDocuments(); ++i) {
                    textArea = view.getRTextEditorPaneAt(i);
                    textArea.removeParser((Parser)this.spellingParser);
                }
            }
            if (this.spellingParser != null) {
                try {
                    this.createSpellingParser();
                }
                catch (IOException ioe) {
                    String desc = this.rtext.getString("Error.LoadingSpellingParser.txt", new Object[0]);
                    this.rtext.displayException(ioe, desc);
                    return;
                }
            }
            if (view != null && this.isSpellCheckingEnabled()) {
                for (i = 0; i < view.getNumDocuments(); ++i) {
                    textArea = view.getRTextEditorPaneAt(i);
                    textArea.addParser((Parser)this.spellingParser);
                }
            }
        }
    }

    public void setUserDictionary(File dict) {
        if (dict == null && this.userDictionary != null || dict != null && !dict.equals(this.userDictionary)) {
            this.userDictionary = dict;
            if (this.spellingParser != null) {
                try {
                    this.spellingParser.setUserDictionary(this.userDictionary);
                    this.recheckSpelling();
                }
                catch (IOException ioe) {
                    this.rtext.displayException(ioe);
                }
            }
        }
    }

    public void spellingParserEvent(SpellingParserEvent e) {
        int type = e.getType();
        if (0 == type || 1 == type) {
            AbstractMainView view = this.rtext.getMainView();
            for (int i = 0; i < view.getNumDocuments(); ++i) {
                RTextEditorPane textArea = view.getRTextEditorPaneAt(i);
                if (textArea == view.getCurrentTextArea()) continue;
                this.forceSpellCheck(textArea);
            }
        }
    }

    private void toggleSpellingParserInstalled() {
        if (this.spellingParser != null) {
            AbstractMainView view = this.rtext.getMainView();
            for (int i = 0; i < view.getNumDocuments(); ++i) {
                RTextEditorPane textArea = view.getRTextEditorPaneAt(i);
                if (this.spellCheckingEnabled) {
                    textArea.addParser((Parser)this.spellingParser);
                    continue;
                }
                textArea.removeParser((Parser)this.spellingParser);
            }
        } else {
            Exception e = new Exception("Internal error: Spelling parser is null!");
            this.rtext.displayException(e);
        }
    }

    private class ViewSpellingErrorWindowAction
    extends AppAction<RText> {
        public ViewSpellingErrorWindowAction(RText app) {
            super((GUIApplication)app, app.getResourceBundle(), "SpellingErrorList.MenuItem");
        }

        public void actionPerformed(ActionEvent e) {
            SpellingSupport.this.rtext.setSpellingWindowVisible(!SpellingSupport.this.rtext.isSpellingWindowVisible());
        }
    }

    private class CreateParserRunnable
    implements Runnable {
        private CreateParserRunnable() {
        }

        @Override
        public void run() {
            try {
                SpellingSupport.this.createSpellingParser();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpellingSupport.this.toggleSpellingParserInstalled();
                    }
                });
            }
            catch (IOException ioe) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String desc = SpellingSupport.this.rtext.getString("Error.LoadingSpellingParser.txt", new Object[0]);
                        SpellingSupport.this.rtext.displayException(ioe, desc);
                    }
                });
            }
        }
    }
}

