/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.StatusBar;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.OS;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.RTextArea;

class ToolBar
extends CustomizableToolBar {
    private JButton newButton;
    private JButton openButton;
    private JButton saveButton;
    private JButton saveAllButton;
    private JButton closeButton;
    private JButton printButton;
    private JButton printPreviewButton;
    private JButton cutButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton deleteButton;
    private JButton findButton;
    private JButton findNextButton;
    private JButton replaceButton;
    private JButton replaceNextButton;
    private JButton undoButton;
    private JButton redoButton;
    private RText owner;
    private boolean mouseInNewButton;

    public ToolBar(String title, RText rtext, StatusBar mouseListener) {
        super(title);
        this.owner = rtext;
        this.newButton = this.createButton(rtext.getAction("newAction"));
        this.configure(this.newButton, mouseListener);
        this.add(this.newButton);
        NewButtonListener listener = new NewButtonListener();
        this.newButton.addFocusListener(listener);
        this.newButton.addMouseListener(listener);
        this.openButton = this.createButton(rtext.getAction("openAction"));
        this.configure(this.openButton, mouseListener);
        this.add(this.openButton);
        this.saveButton = this.createButton(rtext.getAction("saveAction"));
        this.configure(this.saveButton, mouseListener);
        this.add(this.saveButton);
        this.saveAllButton = this.createButton(rtext.getAction("saveAllAction"));
        this.configure(this.saveAllButton, mouseListener);
        this.add(this.saveAllButton);
        this.closeButton = this.createButton(rtext.getAction("closeAction"));
        this.configure(this.closeButton, mouseListener);
        this.add(this.closeButton);
        this.addSeparator();
        this.printButton = this.createButton(rtext.getAction("printAction"));
        this.configure(this.printButton, mouseListener);
        this.add(this.printButton);
        this.printPreviewButton = this.createButton(rtext.getAction("printPreviewAction"));
        this.configure(this.printPreviewButton, mouseListener);
        this.add(this.printPreviewButton);
        this.addSeparator();
        this.cutButton = this.createButton((Action)RTextArea.getAction((int)1));
        this.configure(this.cutButton, mouseListener);
        this.add(this.cutButton);
        this.copyButton = this.createButton((Action)RTextArea.getAction((int)0));
        this.configure(this.copyButton, mouseListener);
        this.add(this.copyButton);
        this.pasteButton = this.createButton((Action)RTextArea.getAction((int)3));
        this.configure(this.pasteButton, mouseListener);
        this.add(this.pasteButton);
        this.deleteButton = this.createButton((Action)RTextArea.getAction((int)2));
        this.configure(this.deleteButton, mouseListener);
        this.add(this.deleteButton);
        this.addSeparator();
        this.findButton = this.createButton(rtext.getAction("findAction"));
        this.configure(this.findButton, mouseListener);
        this.add(this.findButton);
        this.findNextButton = this.createButton(rtext.getAction("findNextAction"));
        this.configure(this.findNextButton, mouseListener);
        this.add(this.findNextButton);
        this.replaceButton = this.createButton(rtext.getAction("replaceAction"));
        this.configure(this.replaceButton, mouseListener);
        this.add(this.replaceButton);
        this.replaceNextButton = this.createButton(rtext.getAction("replaceNextAction"));
        this.configure(this.replaceNextButton, mouseListener);
        this.add(this.replaceNextButton);
        this.addSeparator();
        this.undoButton = this.createButton((Action)RTextArea.getAction((int)6));
        this.configure(this.undoButton, mouseListener);
        this.undoButton.putClientProperty("hideActionText", Boolean.TRUE);
        this.add(this.undoButton);
        this.redoButton = this.createButton((Action)RTextArea.getAction((int)4));
        this.configure(this.redoButton, mouseListener);
        this.redoButton.putClientProperty("hideActionText", Boolean.TRUE);
        this.add(this.redoButton);
        this.makeCustomizable();
    }

    void checkForLargeIcons() {
        IconGroup group = this.owner.getIconGroup();
        if (group.hasSeparateLargeIcons()) {
            Icon icon = group.getLargeIcon("new");
            this.newButton.setIcon(icon);
            icon = group.getLargeIcon("open");
            this.openButton.setIcon(icon);
            icon = group.getLargeIcon("save");
            this.saveButton.setIcon(icon);
            icon = group.getLargeIcon("saveall");
            this.saveAllButton.setIcon(icon);
            icon = group.getLargeIcon("close");
            this.closeButton.setIcon(icon);
            icon = group.getLargeIcon("print");
            this.printButton.setIcon(icon);
            icon = group.getLargeIcon("printpreview");
            this.printPreviewButton.setIcon(icon);
            icon = group.getLargeIcon("cut");
            this.cutButton.setIcon(icon);
            icon = group.getLargeIcon("copy");
            this.copyButton.setIcon(icon);
            icon = group.getLargeIcon("paste");
            this.pasteButton.setIcon(icon);
            icon = group.getLargeIcon("delete");
            this.deleteButton.setIcon(icon);
            icon = group.getLargeIcon("find");
            this.findButton.setIcon(icon);
            icon = group.getLargeIcon("findnext");
            this.findNextButton.setIcon(icon);
            icon = group.getLargeIcon("replace");
            this.replaceButton.setIcon(icon);
            icon = group.getLargeIcon("replacenext");
            this.replaceNextButton.setIcon(icon);
            icon = group.getLargeIcon("undo");
            this.undoButton.setIcon(icon);
            icon = group.getLargeIcon("redo");
            this.redoButton.setIcon(icon);
        }
    }

    private final void configure(JButton button, StatusBar mouseListener) {
        if (this.owner.getOS() == OS.WINDOWS) {
            button.setMargin(new Insets(0, 0, 0, 0));
        }
        button.addMouseListener((MouseListener)((Object)mouseListener));
    }

    private class NewButtonListener
    extends MouseAdapter
    implements FocusListener {
        private NewButtonListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            RTextEditorPane textArea = ToolBar.this.owner.getMainView().getCurrentTextArea();
            if (!ToolBar.this.mouseInNewButton && textArea != null) {
                textArea.requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolBar.this.mouseInNewButton = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ToolBar.this.mouseInNewButton = false;
        }
    }
}

