/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;

class GoToAction
extends AppAction<RText> {
    public GoToAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "GoToAction");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText rtext = (RText)this.getApplication();
        AbstractMainView mainView = rtext.getMainView();
        if (mainView.goToDialog == null) {
            mainView.goToDialog = new GoToDialog((Frame)((Object)rtext));
            mainView.goToDialog.setErrorDialogTitle(rtext.getString("ErrorDialogTitle", new Object[0]));
        }
        RTextEditorPane editor = mainView.getCurrentTextArea();
        mainView.goToDialog.setMaxLineNumberAllowed(editor.getLineCount());
        mainView.goToDialog.setVisible(true);
        int line = mainView.goToDialog.getLineNumber();
        if (line > 0) {
            try {
                editor.setCaretPosition(editor.getLineStartOffset(line - 1));
            }
            catch (BadLocationException ble) {
                String temp = rtext.getString("InternalErrorILN", new Object[]{Integer.toString(line)});
                JOptionPane.showMessageDialog((Component)((Object)rtext), temp, rtext.getString("ErrorDialogTitle", new Object[0]), 0);
            }
        }
    }
}

