/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import org.fife.rtext.RText;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;

class MoveFocusRightAction
extends AppAction<RText> {
    public MoveFocusRightAction(RText app, ResourceBundle msg) {
        super((GUIApplication)app, msg, "MoveFocusRightAction");
    }

    public void actionPerformed(ActionEvent e) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return;
        }
        RText rtext = (RText)this.getApplication();
        int focusedGroup = rtext.getFocusedDockableWindowGroup();
        int toFocus = -1;
        switch (focusedGroup) {
            default: {
                if (rtext.hasDockableWindowGroup(3)) {
                    toFocus = 3;
                    break;
                }
                if (rtext.hasDockableWindowGroup(1)) {
                    toFocus = 1;
                    break;
                }
                return;
            }
            case 1: {
                break;
            }
            case 3: {
                toFocus = rtext.hasDockableWindowGroup(1) ? 1 : -1;
            }
        }
        if (toFocus == -1) {
            rtext.getMainView().getCurrentTextArea().requestFocusInWindow();
        } else {
            rtext.focusDockableWindowGroup(toFocus);
        }
    }
}

