/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import org.fife.rtext.RText;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;

class MoveFocusUpAction
extends AppAction<RText> {
    public MoveFocusUpAction(RText app, ResourceBundle msg) {
        super((GUIApplication)app, msg, "MoveFocusAboveAction");
    }

    public void actionPerformed(ActionEvent e) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return;
        }
        RText rtext = (RText)this.getApplication();
        int focusedGroup = rtext.getFocusedDockableWindowGroup();
        int toFocus = -1;
        switch (focusedGroup) {
            default: {
                if (rtext.hasDockableWindowGroup(0)) {
                    toFocus = 0;
                    break;
                }
                if (rtext.hasDockableWindowGroup(2)) {
                    toFocus = 2;
                    break;
                }
                return;
            }
            case 2: {
                toFocus = -1;
                break;
            }
            case 0: {
                toFocus = rtext.hasDockableWindowGroup(2) ? 2 : -1;
            }
        }
        if (toFocus == -1) {
            rtext.getMainView().getCurrentTextArea().requestFocusInWindow();
        } else {
            rtext.focusDockableWindowGroup(toFocus);
        }
    }
}

