/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.fife.ui.search.FindInFilesSearchContext;

class ReplaceAllAction
extends AppAction<RText> {
    public ReplaceAllAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "ReplaceAllAction");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText rtext = (RText)this.getApplication();
        AbstractMainView mainView = rtext.getMainView();
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        FindInFilesSearchContext context = mainView.searchContext;
        String searchString = context.getSearchFor();
        try {
            SearchResult result = SearchEngine.replaceAll((RTextArea)textArea, (SearchContext)context);
            int count = result.getCount();
            if (count != -1) {
                if (count > 0) {
                    String temp = rtext.getString("ReplacedNOccString", new Object[]{Integer.toString(count), searchString});
                    JOptionPane.showMessageDialog((Component)((Object)rtext), temp, rtext.getString("InfoDialogHeader", new Object[0]), 1);
                } else {
                    searchString = RTextUtilities.escapeForHTML(searchString, null);
                    String temp = rtext.getString("CannotFindString", new Object[]{searchString});
                    JOptionPane.showMessageDialog(null, temp, rtext.getString("InfoDialogHeader", new Object[0]), 1);
                }
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)rtext), "Invalid regular expression:\n" + pse.toString() + "\nPlease check your regular expression search string.", "Error", 0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            JOptionPane.showMessageDialog((Component)((Object)rtext), "Invalid group reference in replacement string:\n" + ioobe.getMessage(), "Error", 0);
        }
    }
}

