/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.SyntaxFilters;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.modifiabletable.RowHandler;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

class FileFilterOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ModifiableTableListener {
    private ModifiableTable filterTable;
    private FilterTableModel model;
    private JCheckBox guessTypeCB;
    private JCheckBox ignoreExtsCB;
    private RText rtext;
    private static final String DEFAULTS_RESTORED = "defaultsRestored";

    public FileFilterOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptFFName"));
        this.rtext = rtext;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptFFLabel")));
        this.add(contentPane);
        SelectableLabel desc = new SelectableLabel(msg.getString("OptFFDesc"));
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        temp.add((Component)desc, "Before");
        contentPane.add((Component)temp, "North");
        this.model = new FilterTableModel(msg.getString("OptFFCol1"), msg.getString("OptFFCol2"));
        this.filterTable = new ModifiableTable((DefaultTableModel)this.model, "South", 4);
        this.filterTable.setRowHandler((RowHandler)new FileFilterRowHandler());
        this.filterTable.addModifiableTableListener((ModifiableTableListener)this);
        JTable table = this.filterTable.getTable();
        table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        contentPane.add((Component)this.filterTable);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.guessTypeCB = new JCheckBox(msg.getString("GuessContentType"));
        this.guessTypeCB.setActionCommand("GuessContentType");
        this.guessTypeCB.addActionListener(this);
        this.ignoreExtsCB = new JCheckBox(msg.getString("IgnoreTheseExtensions"));
        this.ignoreExtsCB.setActionCommand("IgnoreTheseExtensions");
        this.ignoreExtsCB.addActionListener(this);
        Box box = Box.createVerticalBox();
        this.addLeftAligned(box, this.guessTypeCB);
        this.addLeftAligned(box, this.ignoreExtsCB);
        box.add(Box.createVerticalStrut(5));
        bottomPanel.add((Component)box, "North");
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        temp.add((Component)rdButton, "Before");
        bottomPanel.add((Component)temp, "South");
        this.add(bottomPanel, "South");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("RestoreDefaults".equals(command)) {
            SyntaxFilters defaultFilters = new SyntaxFilters();
            boolean changed = this.setSyntaxFilters(defaultFilters);
            if (changed || !this.guessTypeCB.isSelected() || !this.ignoreExtsCB.isSelected()) {
                this.guessTypeCB.setSelected(true);
                this.ignoreExtsCB.setSelected(true);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(DEFAULTS_RESTORED, Boolean.FALSE, Boolean.TRUE);
            }
        } else if ("GuessContentType".equals(command)) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange(DEFAULTS_RESTORED, false, true);
        } else if ("IgnoreTheseExtensions".equals(command)) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange(DEFAULTS_RESTORED, false, true);
        }
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setSyntaxFilters(this.getSyntaxFilters());
        mainView.setGuessFileContentType(this.guessTypeCB.isSelected());
        mainView.setIgnoreBackupExtensions(this.ignoreExtsCB.isSelected());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String filters = (String)this.model.getValueAt(i, 1);
            if (SyntaxFilters.isValidFileFilterString(filters)) continue;
            String temp = this.rtext.getString("InvalidFFString", new Object[]{filters});
            return new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.filterTable, temp);
        }
        return null;
    }

    public SyntaxFilters getSyntaxFilters() {
        SyntaxFilters filters = new SyntaxFilters();
        for (int i = 0; i < this.model.styles.length; ++i) {
            filters.setFiltersForSyntaxStyle(this.model.styles[i], (String)this.model.getValueAt(i, 1));
        }
        return filters;
    }

    public JComponent getTopJComponent() {
        return this.filterTable;
    }

    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange("fileFilterChanged", null, new Integer(e.getRow()));
    }

    public boolean setSyntaxFilters(SyntaxFilters syntaxFilters) {
        boolean changed = false;
        for (int i = 0; i < this.model.styles.length; ++i) {
            String old;
            String style = this.model.styles[i];
            String filterString = syntaxFilters.getFilterString(style);
            if (filterString.equals(old = (String)this.model.getValueAt(i, 1))) continue;
            this.model.setValueAt(filterString, i, 1);
            changed = true;
        }
        return changed;
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setSyntaxFilters(mainView.getSyntaxFilters());
        this.guessTypeCB.setSelected(mainView.getGuessFileContentType());
        this.ignoreExtsCB.setSelected(mainView.getIgnoreBackupExtensions());
    }

    private class FileFilterRowHandler
    extends AbstractRowHandler {
        private FileFilterRowHandler() {
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            String prompt;
            String input;
            String oldValue = (String)oldData[1];
            String filterType = (String)oldData[0];
            while ((input = JOptionPane.showInputDialog((Component)((Object)FileFilterOptionPanel.this), prompt = FileFilterOptionPanel.this.rtext.getString("FileFilterPrompt", new Object[]{filterType}), oldValue)) != null && !SyntaxFilters.isValidFileFilterString(input)) {
                String temp = FileFilterOptionPanel.this.rtext.getString("InvalidFFString", new Object[]{input});
                JOptionPane.showMessageDialog((Component)((Object)FileFilterOptionPanel.this), temp, FileFilterOptionPanel.this.rtext.getString("ErrorDialogTitle", new Object[0]), 0);
            }
            if (input != null) {
                return new Object[]{oldData[0], input};
            }
            return null;
        }

        public boolean canRemoveRow(int row) {
            return false;
        }
    }

    static class FilterTableModel
    extends DefaultTableModel
    implements SyntaxConstants {
        public String[] columnNames;
        public String[] styles = new String[44];

        public FilterTableModel(String fileTypeHeader, String filterHeader) {
            super(new Object[]{fileTypeHeader, filterHeader}, 0);
            this.addRow(new Object[]{"ActionScript", null});
            this.styles[0] = "text/actionscript";
            this.addRow(new Object[]{"Assembler (x86)", null});
            this.styles[1] = "text/asm";
            this.addRow(new Object[]{"BBCode", null});
            this.styles[2] = "text/bbcode";
            this.addRow(new Object[]{"C", null});
            this.styles[3] = "text/c";
            this.addRow(new Object[]{"C++", null});
            this.styles[4] = "text/cpp";
            this.addRow(new Object[]{"C#", null});
            this.styles[5] = "text/cs";
            this.addRow(new Object[]{"Clojure", null});
            this.styles[6] = "text/clojure";
            this.addRow(new Object[]{"CSS", null});
            this.styles[7] = "text/css";
            this.addRow(new Object[]{"D", null});
            this.styles[8] = "text/d";
            this.addRow(new Object[]{"Delphi", null});
            this.styles[9] = "text/delphi";
            this.addRow(new Object[]{"DTD", null});
            this.styles[10] = "text/dtd";
            this.addRow(new Object[]{"Flex", null});
            this.styles[11] = "text/mxml";
            this.addRow(new Object[]{"Fortran", null});
            this.styles[12] = "text/fortran";
            this.addRow(new Object[]{"Groovy", null});
            this.styles[13] = "text/groovy";
            this.addRow(new Object[]{"Hosts", null});
            this.styles[14] = "text/hosts";
            this.addRow(new Object[]{"htaccess", null});
            this.styles[15] = "text/htaccess";
            this.addRow(new Object[]{"HTML", null});
            this.styles[16] = "text/html";
            this.addRow(new Object[]{"INI", null});
            this.styles[17] = "text/ini";
            this.addRow(new Object[]{"Java", null});
            this.styles[18] = "text/java";
            this.addRow(new Object[]{"JavaScript", null});
            this.styles[19] = "text/javascript";
            this.addRow(new Object[]{"JSP", null});
            this.styles[20] = "text/jsp";
            this.addRow(new Object[]{"JSON", null});
            this.styles[21] = "text/json";
            this.addRow(new Object[]{"JSON with comments", null});
            this.styles[22] = "text/jshintrc";
            this.addRow(new Object[]{"LaTeX", null});
            this.styles[23] = "text/latex";
            this.addRow(new Object[]{"Less", null});
            this.styles[24] = "text/less";
            this.addRow(new Object[]{"Lisp", null});
            this.styles[25] = "text/lisp";
            this.addRow(new Object[]{"Lua", null});
            this.styles[26] = "text/lua";
            this.addRow(new Object[]{"Make", null});
            this.styles[27] = "text/makefile";
            this.addRow(new Object[]{"NSIS", null});
            this.styles[28] = "text/nsis";
            this.addRow(new Object[]{"Perl", null});
            this.styles[29] = "text/perl";
            this.addRow(new Object[]{"PHP", null});
            this.styles[30] = "text/php";
            this.addRow(new Object[]{"Properties files", null});
            this.styles[31] = "text/properties";
            this.addRow(new Object[]{"Python", null});
            this.styles[32] = "text/python";
            this.addRow(new Object[]{"Ruby", null});
            this.styles[33] = "text/ruby";
            this.addRow(new Object[]{"SAS", null});
            this.styles[34] = "text/sas";
            this.addRow(new Object[]{"Scala", null});
            this.styles[35] = "text/scala";
            this.addRow(new Object[]{"SQL", null});
            this.styles[36] = "text/sql";
            this.addRow(new Object[]{"Tcl", null});
            this.styles[37] = "text/tcl";
            this.addRow(new Object[]{"TypeScript", null});
            this.styles[38] = "text/typescript";
            this.addRow(new Object[]{"UNIX shell scripts", null});
            this.styles[39] = "text/unix";
            this.addRow(new Object[]{"Visual Basic", null});
            this.styles[40] = "text/vb";
            this.addRow(new Object[]{"Windows Batch", null});
            this.styles[41] = "text/bat";
            this.addRow(new Object[]{"XML", null});
            this.styles[42] = "text/xml";
            this.addRow(new Object[]{"YAML", null});
            this.styles[43] = "text/yaml";
        }
    }
}

