/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.fife.rtext.optionsdialog.LanguageOptionPanel;
import org.fife.rtext.optionsdialog.SubstanceLanguageListCellRenderer;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.util.SubstanceUtil;

class LanguageListCellRenderer
extends DefaultListCellRenderer {
    private JLabel possibleDelegate;

    private LanguageListCellRenderer(JLabel delegate) {
        this.possibleDelegate = delegate;
    }

    public static ListCellRenderer create() {
        JLabel delegate = null;
        if (SubstanceUtil.isSubstanceInstalled()) {
            return new SubstanceLanguageListCellRenderer();
        }
        if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
            delegate = (JLabel)UIManager.get("List.cellRenderer");
        }
        return new LanguageListCellRenderer(delegate);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
        JLabel renderer;
        if (this.possibleDelegate != null) {
            renderer = this.possibleDelegate;
            ((ListCellRenderer)((Object)this.possibleDelegate)).getListCellRendererComponent(list, value, index, selected, focused);
        } else {
            renderer = this;
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, focused);
        }
        LanguageOptionPanel.IconTextInfo iti = (LanguageOptionPanel.IconTextInfo)value;
        renderer.setIcon(iti.getIcon());
        renderer.setText(iti.getText());
        return renderer;
    }
}

