/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import org.fife.rtext.RText;
import org.fife.rtext.RTextActionInfo;
import org.fife.ui.GetKeyStrokeDialog;
import org.fife.ui.KeyStrokeCellRenderer;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.modifiabletable.RowHandler;

class ShortcutOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ModifiableTableListener {
    private ModifiableTable shortcutTable;
    private DefaultTableModel model;
    private RText rtext;
    private Action[] masterActionList;
    private static final String SHORTCUT_PROPERTY = "SOP.shortcut";

    public ShortcutOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptSCName"));
        this.rtext = rtext;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptSCLabel")));
        this.add(contentPane);
        this.model = new DefaultTableModel(new Object[]{msg.getString("OptSCCol1"), msg.getString("OptSCCol2")}, RTextActionInfo.actionNames.length);
        this.shortcutTable = new ModifiableTable(this.model, "South", 4);
        this.shortcutTable.addModifiableTableListener((ModifiableTableListener)this);
        this.shortcutTable.setRowHandler((RowHandler)new ShortcutTableRowHandler());
        JTable table = this.shortcutTable.getTable();
        table.getColumn(msg.getString("OptSCCol2")).setCellRenderer(KeyStrokeCellRenderer.create());
        table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        contentPane.add((Component)this.shortcutTable);
        JButton defButton = new JButton(msg.getString("RestoreDefaults"));
        defButton.setActionCommand("RestoreDefaults");
        defButton.addActionListener(this);
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        temp.add((Component)defButton, "Before");
        this.add(temp, "South");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("RestoreDefaults")) {
            this.rtext.restoreDefaultAccelerators();
            this.setActions((AbstractGUIApplication<?>)this.rtext);
        }
    }

    protected void doApplyImpl(Frame owner) {
        Action[] actions = this.getActions();
        int actionsLength = actions.length;
        Action[] realActions = ((AbstractGUIApplication)owner).getActions();
        for (int k = 0; k < realActions.length; ++k) {
            int j;
            String name = (String)realActions[k].getValue("Name");
            for (j = 0; j < actionsLength; ++j) {
                String name2 = (String)actions[j].getValue("Name");
                if (!name.equals(name2)) continue;
                realActions[k].putValue("AcceleratorKey", actions[j].getValue("AcceleratorKey"));
                break;
            }
            if (j != actionsLength) continue;
            System.err.println("err0r!!!!");
        }
        this.rtext.menuItemAcceleratorWorkaround();
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public Action[] getActions() {
        this.updateMasterActionList();
        return this.masterActionList;
    }

    public JComponent getTopJComponent() {
        return this.shortcutTable.getTable();
    }

    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(SHORTCUT_PROPERTY, null, new Integer(e.getRow()));
    }

    private void setActions(AbstractGUIApplication<?> app) {
        this.masterActionList = app.getActions();
        Arrays.sort(this.masterActionList, new Comparator<Action>(){

            @Override
            public int compare(Action a1, Action a2) {
                String name1 = (String)a1.getValue("Name");
                String name2 = (String)a2.getValue("Name");
                if (name1 == null) {
                    if (name2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        this.model.setRowCount(this.masterActionList.length);
        for (int i = 0; i < this.masterActionList.length; ++i) {
            this.model.setValueAt(this.masterActionList[i].getValue("Name"), i, 0);
            this.model.setValueAt(this.masterActionList[i].getValue("AcceleratorKey"), i, 1);
        }
    }

    protected void setValuesImpl(Frame owner) {
        this.setActions((AbstractGUIApplication<?>)((RText)((Object)owner)));
    }

    private void updateMasterActionList() {
        int num = this.masterActionList.length;
        for (int i = 0; i < num; ++i) {
            this.masterActionList[i].putValue("AcceleratorKey", this.model.getValueAt(i, 1));
        }
    }

    private class ShortcutTableRowHandler
    extends AbstractRowHandler {
        private GetKeyStrokeDialog ksDialog;

        private ShortcutTableRowHandler() {
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            KeyStroke temp;
            KeyStroke keyStroke = (KeyStroke)oldData[1];
            String action = (String)oldData[0];
            if (this.ksDialog == null) {
                this.ksDialog = new GetKeyStrokeDialog((Dialog)ShortcutOptionPanel.this.getOptionsDialog(), null);
            }
            this.ksDialog.setKeyStroke(keyStroke);
            this.ksDialog.setLocationRelativeTo((Component)((Object)ShortcutOptionPanel.this));
            this.ksDialog.setVisible(true);
            if (!this.ksDialog.getCancelled() && ((temp = this.ksDialog.getKeyStroke()) == null && keyStroke != null || temp != null && !temp.equals(keyStroke))) {
                return new Object[]{action, temp};
            }
            return null;
        }

        public boolean canRemoveRow(int row) {
            return false;
        }

        public void updateUI() {
            if (this.ksDialog != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.ksDialog);
            }
        }
    }
}

