/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.Theme;

public class ThemeOptionPanel
extends OptionsDialogPanel {
    public static final String OPTION_PANEL_ID = "ThemeOptionPanel";
    private LabelValueComboBox<String, String> themeCombo;
    private JButton applyButton;

    public ThemeOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptThemeName"));
        this.setId(OPTION_PANEL_ID);
        Listener listener = new Listener();
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box cp = Box.createVerticalBox();
        this.add(cp, "North");
        SelectableLabel label = new SelectableLabel();
        label.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 0));
        label.setText(msg.getString("OptThemeDesc"));
        cp.add((Component)label);
        cp.add(Box.createVerticalStrut(5));
        Box temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptThemeLabel")));
        this.themeCombo = new LabelValueComboBox();
        this.themeCombo.addLabelValuePair((Object)"Default", (Object)"default");
        this.themeCombo.addLabelValuePair((Object)"Eclipse", (Object)"eclipse");
        this.themeCombo.addLabelValuePair((Object)"Dark", (Object)"dark");
        this.themeCombo.addLabelValuePair((Object)"Monokai", (Object)"monokai");
        UIUtil.fixComboOrientation(this.themeCombo);
        Box temp2 = this.createHorizontalBox();
        temp2.add((Component)this.themeCombo);
        temp2.add(Box.createHorizontalStrut(5));
        this.applyButton = UIUtil.newButton((ResourceBundle)msg, (String)"OptThemeApply", (ActionListener)listener);
        temp2.add(this.applyButton);
        temp2.add(Box.createHorizontalGlue());
        temp.add(temp2);
        cp.add(temp);
        cp.add(Box.createVerticalStrut(10));
        cp.add(Box.createVerticalGlue());
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        this.applyComponentOrientation(o);
    }

    private void applySelectedTheme() {
        String theme = (String)this.themeCombo.getSelectedValue();
        String laf = null;
        String editorTheme = null;
        if ("default".equals(theme)) {
            laf = UIManager.getSystemLookAndFeelClassName();
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/default-alt.xml";
        } else if ("eclipse".equals(theme)) {
            laf = UIManager.getSystemLookAndFeelClassName();
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/eclipse.xml";
        } else if ("dark".equals(theme)) {
            laf = "com.bulenkov.darcula.DarculaLaf";
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/dark.xml";
        } else if ("monokai".equals(theme)) {
            laf = "com.bulenkov.darcula.DarculaLaf";
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/monokai.xml";
        }
        RText rtext = (RText)((Object)this.getOptionsDialog().getOwner());
        if (laf != null) {
            RTextUtilities.setLookAndFeel(rtext, laf);
        }
        if (editorTheme != null) {
            Theme themeObj = null;
            try {
                themeObj = Theme.load((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(editorTheme));
                ThemeOptionPanel.installRstaTheme(rtext, themeObj);
            }
            catch (Exception ioe) {
                rtext.displayException(ioe);
                return;
            }
        }
        OtherColors otherColors = ThemeOptionPanel.getOtherColorsForTheme(theme);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setModifiedDocumentDisplayNamesColor(otherColors.getModifiedDocumentNameColor());
        OptionsDialog dialog = this.getOptionsDialog();
        dialog.getPanelById("UIOptionPanel").setValues((Frame)((Object)rtext));
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        this.getOptionsDialog().broadcast("appTheme:" + theme);
    }

    protected void doApplyImpl(Frame owner) {
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private static OtherColors getOtherColorsForTheme(String theme) {
        OtherColors colors = new OtherColors();
        Color darkModifiedDocumentNameColor = new Color(255, 128, 128);
        if ("eclipse".equals(theme)) {
            colors.setModifiedDocumentNameColor(Color.RED);
        } else if ("dark".equals(theme)) {
            colors.setModifiedDocumentNameColor(darkModifiedDocumentNameColor);
        } else if ("monokai".equals(theme)) {
            colors.setModifiedDocumentNameColor(darkModifiedDocumentNameColor);
        } else {
            colors.setModifiedDocumentNameColor(Color.RED);
        }
        return colors;
    }

    public JComponent getTopJComponent() {
        return this.themeCombo;
    }

    private static void installRstaTheme(RText rtext, Theme theme) {
        rtext.setSyntaxScheme(theme.scheme);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setBackgroundObject(theme.bgColor);
        mainView.setCaretColor(theme.caretColor);
        mainView.setCurrentLineHighlightColor(theme.currentLineHighlight);
        mainView.setGutterBorderColor(theme.gutterBorderColor);
        mainView.setHyperlinkColor(theme.hyperlinkFG);
        mainView.setLineNumberColor(theme.lineNumberColor);
        if (theme.lineNumberFont != null) {
            int fontSize = theme.lineNumberFontSize > 0 ? theme.lineNumberFontSize : 11;
            mainView.setLineNumberFont(new Font(theme.lineNumberFont, 0, fontSize));
        }
        mainView.setMarginLineColor(theme.marginLineColor);
        mainView.setMarkAllHighlightColor(theme.markAllHighlightColor);
        mainView.setMarkOccurrencesColor(theme.markOccurrencesColor);
        if (theme.matchedBracketBG != null) {
            mainView.setMatchedBracketBorderColor(theme.matchedBracketFG);
        }
        mainView.setMatchedBracketBGColor(theme.matchedBracketBG);
        if (theme.secondaryLanguages != null) {
            for (int i = 0; i < theme.secondaryLanguages.length; ++i) {
                mainView.setSecondaryLanguageColor(i, theme.secondaryLanguages[i]);
            }
        }
        mainView.setSelectionColor(theme.selectionBG);
        if (theme.selectionFG != null) {
            mainView.setSelectedTextColor(theme.selectionFG);
        }
        mainView.setUseSelectedTextColor(theme.useSelctionFG);
        mainView.setRoundedSelectionEdges(theme.selectionRoundedEdges);
        mainView.setFoldBackground(theme.foldBG);
        mainView.setArmedFoldBackground(theme.armedFoldBG);
    }

    protected void setValuesImpl(Frame owner) {
    }

    private static class OtherColors {
        private Color modifiedDocumentNameColor;

        private OtherColors() {
        }

        public Color getModifiedDocumentNameColor() {
            return this.modifiedDocumentNameColor;
        }

        public void setModifiedDocumentNameColor(Color color) {
            this.modifiedDocumentNameColor = color;
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (ThemeOptionPanel.this.applyButton == source) {
                ThemeOptionPanel.this.applySelectedTheme();
            }
        }
    }
}

