/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OS;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.app.ExtendedLookAndFeelInfo;
import org.fife.ui.rtextarea.IconGroup;

class UIOptionPanel
extends OptionsDialogPanel
implements ActionListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "UIOptionPanel";
    private int mainViewStyle;
    private int documentSelectionPlacement;
    private int statusBarStyle;
    private JPanel springPanel;
    private JPanel springPanel2;
    private JComboBox viewCombo;
    private JComboBox docSelCombo;
    private LabelValueComboBox<String, String> lnfCombo;
    private LabelValueComboBox<String, String> imageLnFCombo;
    private JComboBox statusBarCombo;
    private JCheckBox highlightModifiedCheckBox;
    private RColorSwatchesButton hmColorButton;
    private JCheckBox showHostNameCheckBox;

    public UIOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptUIName"));
        this.setId(OPTION_PANEL_ID);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box everything = Box.createVerticalBox();
        this.viewCombo = new JComboBox();
        UIUtil.fixComboOrientation((JComboBox)this.viewCombo);
        this.viewCombo.setActionCommand("ViewComboBox");
        this.viewCombo.addActionListener(this);
        this.viewCombo.addItem(msg.getString("OptUITV"));
        this.viewCombo.addItem(msg.getString("OptUISPV"));
        this.viewCombo.addItem(msg.getString("OptUIMDIV"));
        this.docSelCombo = new JComboBox();
        UIUtil.fixComboOrientation((JComboBox)this.docSelCombo);
        this.docSelCombo.setActionCommand("DocSelCombo");
        this.docSelCombo.addActionListener(this);
        this.docSelCombo.addItem(msg.getString("OptUITop"));
        this.docSelCombo.addItem(msg.getString("OptUILeft"));
        this.docSelCombo.addItem(msg.getString("OptUIBottom"));
        this.docSelCombo.addItem(msg.getString("OptUIRight"));
        this.springPanel = new JPanel(new SpringLayout());
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptUILT")));
        if (orientation.isLeftToRight()) {
            this.springPanel.add(new JLabel(msg.getString("OptUIViewT")));
            this.springPanel.add(this.viewCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIDSPT")));
            this.springPanel.add(this.docSelCombo);
        } else {
            this.springPanel.add(this.viewCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIViewT")));
            this.springPanel.add(this.docSelCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIDSPT")));
        }
        temp.add((Component)this.springPanel, "Before");
        UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        everything.add(temp);
        this.lnfCombo = UIOptionPanel.createLookAndFeelComboBox(rtext);
        this.lnfCombo.setActionCommand("LookAndFeelComboBox");
        this.lnfCombo.addActionListener((ActionListener)this);
        this.imageLnFCombo = new LabelValueComboBox();
        UIUtil.fixComboOrientation(this.imageLnFCombo);
        this.imageLnFCombo.setActionCommand("IconComboBox");
        this.imageLnFCombo.addActionListener((ActionListener)this);
        Collection<IconGroup> iconGroups = rtext.getIconGroupMap().values();
        for (IconGroup group : iconGroups) {
            this.imageLnFCombo.addLabelValuePair((Object)group.getName(), (Object)group.getName());
        }
        this.statusBarCombo = new JComboBox();
        UIUtil.fixComboOrientation((JComboBox)this.statusBarCombo);
        this.statusBarCombo.setActionCommand("StatusBarComboBox");
        this.statusBarCombo.addActionListener(this);
        this.statusBarCombo.addItem(msg.getString("OptUIW95A"));
        this.statusBarCombo.addItem(msg.getString("OptUIWXPA"));
        this.springPanel2 = new JPanel(new SpringLayout());
        temp = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptUIAT")));
        if (orientation.isLeftToRight()) {
            this.springPanel2.add(new JLabel(msg.getString("OptUILnFT")));
            this.springPanel2.add((Component)this.lnfCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUIIAT")));
            this.springPanel2.add((Component)this.imageLnFCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUISBT")));
            this.springPanel2.add(this.statusBarCombo);
        } else {
            this.springPanel2.add((Component)this.lnfCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUILnFT")));
            this.springPanel2.add((Component)this.imageLnFCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUIIAT")));
            this.springPanel2.add(this.statusBarCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUISBT")));
        }
        temp.add((Component)this.springPanel2, "Before");
        UIUtil.makeSpringCompactGrid((Container)this.springPanel2, (int)3, (int)2, (int)0, (int)0, (int)5, (int)5);
        everything.add(temp);
        JComponent miscPanel = this.createHorizontalBox();
        this.highlightModifiedCheckBox = new JCheckBox(msg.getString("OptUIHMDN"));
        this.highlightModifiedCheckBox.setActionCommand("HighlightModifiedCheckBox");
        this.highlightModifiedCheckBox.addActionListener(this);
        this.hmColorButton = new RColorSwatchesButton(Color.RED);
        this.hmColorButton.addPropertyChangeListener((PropertyChangeListener)this);
        miscPanel.add(this.highlightModifiedCheckBox);
        miscPanel.add((Component)this.hmColorButton);
        miscPanel.add(Box.createHorizontalGlue());
        everything.add(miscPanel);
        miscPanel = new JPanel(new BorderLayout());
        this.showHostNameCheckBox = new JCheckBox(msg.getString("OptUIShowHostName"));
        this.showHostNameCheckBox.setActionCommand("ShowHostNameCB");
        this.showHostNameCheckBox.addActionListener(this);
        miscPanel.add((Component)this.showHostNameCheckBox, "Before");
        everything.add(miscPanel);
        this.add(everything, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("ViewComboBox")) {
            this.hasUnsavedChanges = true;
            int old = this.mainViewStyle;
            this.mainViewStyle = this.viewCombo.getSelectedIndex();
            this.firePropertyChange("UIOptionPanel.mainViewStyle", old, this.mainViewStyle);
        } else if (actionCommand.equals("DocSelCombo")) {
            this.hasUnsavedChanges = true;
            int old = this.documentSelectionPlacement;
            this.documentSelectionPlacement = this.docSelCombo.getSelectedIndex() + 1;
            this.firePropertyChange("UIOptionPanel.documentSelectionPlacement", old, this.documentSelectionPlacement);
        } else if (actionCommand.equals("LookAndFeelComboBox")) {
            this.hasUnsavedChanges = true;
            String newLnF = (String)this.lnfCombo.getSelectedValue();
            this.firePropertyChange("UIOptionPanel.lookAndFeel", null, newLnF);
        } else if (actionCommand.equals("IconComboBox")) {
            this.hasUnsavedChanges = true;
            String name = (String)this.imageLnFCombo.getSelectedValue();
            this.firePropertyChange("UIOptionPanel.iconStyle", null, name);
        } else if (actionCommand.equals("StatusBarComboBox")) {
            this.hasUnsavedChanges = true;
            int old = this.statusBarStyle;
            this.statusBarStyle = this.statusBarCombo.getSelectedIndex();
            this.firePropertyChange("UIOptionPanel.statusBarStyle", old, this.statusBarStyle);
        } else if (actionCommand.equals("HighlightModifiedCheckBox")) {
            boolean highlight = this.highlightModifiedDocumentDisplayNames();
            this.hmColorButton.setEnabled(highlight);
            this.hasUnsavedChanges = true;
            this.firePropertyChange("UIOptionPanel.highlightModified", !highlight, highlight);
        } else if (actionCommand.equals("ShowHostNameCB")) {
            boolean show = this.getShowHostName();
            this.hasUnsavedChanges = true;
            this.firePropertyChange("UIOptionPanel.showHostName", !show, show);
        }
    }

    private static final LabelValueComboBox<String, String> createLookAndFeelComboBox(RText rtext) {
        ExtendedLookAndFeelInfo[] info;
        int i;
        LabelValueComboBox combo = new LabelValueComboBox();
        UIUtil.fixComboOrientation((JComboBox)combo);
        boolean osIsWindows = rtext.getOS() == OS.WINDOWS;
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (i = 1; i < infos.length; ++i) {
            String clazzName = infos[i].getClassName();
            if (!clazzName.equals(UIManager.getSystemLookAndFeelClassName())) continue;
            UIManager.LookAndFeelInfo temp = infos[0];
            infos[0] = infos[i];
            infos[i] = temp;
            break;
        }
        for (i = 0; i < infos.length; ++i) {
            String name = infos[i].getName();
            if (!osIsWindows && name.toLowerCase().contains("windows")) continue;
            combo.addLabelValuePair((Object)name, (Object)infos[i].getClassName());
        }
        if (osIsWindows) {
            combo.addLabelValuePair((Object)"MS Office XP", (Object)"org.fife.plaf.OfficeXP.OfficeXPLookAndFeel");
            combo.addLabelValuePair((Object)"MS Office 2003", (Object)"org.fife.plaf.Office2003.Office2003LookAndFeel");
            combo.addLabelValuePair((Object)"Visual Studio 2005", (Object)"org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel");
        }
        if ((info = rtext.get3rdPartyLookAndFeelInfo()) != null && info.length > 0) {
            for (int i2 = 0; i2 < info.length; ++i2) {
                combo.addLabelValuePair((Object)info[i2].getName(), (Object)info[i2].getClassName());
            }
        }
        return combo;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setDocumentSelectionPlacement(this.getDocumentSelectionPlacement());
        RTextUtilities.setLookAndFeel(rtext, this.getLookAndFeelClassName());
        rtext.setIconGroupByName(this.getIconGroupName());
        mainView.setHighlightModifiedDocumentDisplayNames(this.highlightModifiedDocumentDisplayNames());
        mainView.setModifiedDocumentDisplayNamesColor(this.getModifiedDocumentDisplayNamesColor());
        rtext.setMainViewStyle(this.getMainViewStyle());
        rtext.getStatusBar().setStyle(this.getStatusBarStyle());
        rtext.setShowHostName(this.getShowHostName());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public int getDocumentSelectionPlacement() {
        return this.documentSelectionPlacement;
    }

    public String getIconGroupName() {
        return (String)this.imageLnFCombo.getSelectedValue();
    }

    public String getLookAndFeelClassName() {
        return (String)this.lnfCombo.getSelectedValue();
    }

    public int getMainViewStyle() {
        return this.mainViewStyle;
    }

    public Color getModifiedDocumentDisplayNamesColor() {
        return this.hmColorButton.getColor();
    }

    public boolean getShowHostName() {
        return this.showHostNameCheckBox.isSelected();
    }

    public int getStatusBarStyle() {
        return this.statusBarStyle;
    }

    public JComponent getTopJComponent() {
        return this.viewCombo;
    }

    public boolean highlightModifiedDocumentDisplayNames() {
        return this.highlightModifiedCheckBox.isSelected();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (propName.equals("RColorButton.colorChanged")) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange("UIOptionPanel." + propName, e.getOldValue(), e.getNewValue());
        }
    }

    public void setDocumentSelectionPlacement(int documentSelectionPlacement) {
        if (documentSelectionPlacement != 2 && documentSelectionPlacement != 4 && documentSelectionPlacement != 1 && documentSelectionPlacement != 3) {
            documentSelectionPlacement = 1;
        }
        if (this.documentSelectionPlacement != documentSelectionPlacement) {
            this.documentSelectionPlacement = documentSelectionPlacement;
            this.docSelCombo.setSelectedIndex(documentSelectionPlacement - 1);
        }
    }

    public void setHighlightModifiedDocumentDisplayNames(boolean highlight) {
        this.highlightModifiedCheckBox.setSelected(highlight);
        this.hmColorButton.setEnabled(highlight);
    }

    public void setIconGroupByName(String name) {
        int count = this.imageLnFCombo.getItemCount();
        for (int i = 0; i < count; ++i) {
            String specialValue = (String)this.imageLnFCombo.getValueAt(i);
            if (!specialValue.equals(name)) continue;
            this.imageLnFCombo.setSelectedIndex(i);
            return;
        }
        this.imageLnFCombo.setSelectedIndex(0);
    }

    public void setLookAndFeelByClassName(String name) {
        int count = this.lnfCombo.getItemCount();
        for (int i = 0; i < count; ++i) {
            String specialValue = (String)this.lnfCombo.getValueAt(i);
            if (!specialValue.equals(name)) continue;
            this.lnfCombo.setSelectedIndex(i);
            return;
        }
        this.lnfCombo.setSelectedIndex(0);
    }

    public void setMainViewStyle(int viewStyle) {
        this.mainViewStyle = viewStyle == 0 || viewStyle == 1 || viewStyle == 2 ? viewStyle : 0;
        this.viewCombo.setSelectedIndex(this.mainViewStyle);
    }

    public void setModifiedDocumentDisplayNamesColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.hmColorButton.setColor(color);
    }

    public void setShowHostName(boolean show) {
        this.showHostNameCheckBox.setSelected(show);
    }

    public void setStatusBarStyle(int style) {
        if (style != 0 && style != 1) {
            style = 1;
        }
        this.statusBarStyle = style;
        this.statusBarCombo.setSelectedIndex(this.statusBarStyle);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setDocumentSelectionPlacement(mainView.getDocumentSelectionPlacement());
        this.setLookAndFeelByClassName(UIManager.getLookAndFeel().getClass().getName());
        this.setIconGroupByName(rtext.getIconGroup().getName());
        this.setMainViewStyle(rtext.getMainViewStyle());
        this.setHighlightModifiedDocumentDisplayNames(mainView.highlightModifiedDocumentDisplayNames());
        this.setStatusBarStyle(rtext.getStatusBar().getStyle());
        this.setModifiedDocumentDisplayNamesColor(mainView.getModifiedDocumentDisplayNamesColor());
        this.setShowHostName(rtext.getShowHostName());
    }

    public void updateUI() {
        super.updateUI();
        if (this.springPanel != null) {
            UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        }
        if (this.springPanel2 != null) {
            UIUtil.makeSpringCompactGrid((Container)this.springPanel2, (int)3, (int)2, (int)0, (int)0, (int)5, (int)5);
        }
    }
}

