/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.ImagePreviewPane;
import org.fife.ui.RFileChooser;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.filters.ImageFileFilter;

class BackgroundDialog
extends JDialog
implements ActionListener {
    private JRadioButton colorButton;
    private JRadioButton imageButton;
    private JButton colorBrowseButton;
    private JButton imageBrowseButton;
    private JButton okButton;
    private JButton cancelButton;
    private ColorOrImageIcon colorOrImageIcon;
    private Color currentColor;
    private String currentImageFileName;
    private JTextField imageFileNameField;
    private boolean viewingColors;
    private ResourceBundle msg;
    private JFileChooser imageChooser;
    private static final int IMAGE_DIM = 120;

    public BackgroundDialog(Dialog owner) {
        super(owner);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.msg = ResourceBundle.getBundle("org.fife.ui.rtextarea.BackgroundDialog");
        this.setTitle(this.msg.getString("BackgroundDialogTitle"));
        Border empty5Border = UIUtil.getEmpty5Border();
        this.imageChooser = new RFileChooser();
        ImagePreviewPane imagePreviewPane = new ImagePreviewPane();
        this.imageChooser.setAccessory((JComponent)imagePreviewPane);
        this.imageChooser.addPropertyChangeListener((PropertyChangeListener)imagePreviewPane);
        this.imageChooser.setFileFilter((FileFilter)new ImageFileFilter());
        this.imageChooser.applyComponentOrientation(orientation);
        Box previewPanel = Box.createVerticalBox();
        previewPanel.setBorder(BorderFactory.createTitledBorder(this.msg.getString("PreviewLabel")));
        this.colorOrImageIcon = new ColorOrImageIcon();
        JLabel tempLabel = new JLabel();
        tempLabel.setIcon(this.colorOrImageIcon);
        previewPanel.add(tempLabel);
        JPanel changePanel = new JPanel(new BorderLayout());
        changePanel.setBorder(empty5Border);
        JPanel temp = new JPanel(new BorderLayout());
        changePanel.add((Component)temp, "North");
        JPanel temp2 = new JPanel(new SpringLayout());
        JPanel temp3 = new JPanel(new BorderLayout());
        temp3.add((Component)temp2, "Before");
        temp.add((Component)temp3, "North");
        ButtonGroup bg = new ButtonGroup();
        this.colorButton = UIUtil.newRadio((ResourceBundle)this.msg, (String)"Color", (ButtonGroup)bg, (ActionListener)this, (boolean)true);
        this.colorButton.setActionCommand("ColorRadioButton");
        this.colorBrowseButton = new JButton(this.msg.getString("BrowseColors"));
        this.colorBrowseButton.setActionCommand("BrowseColors");
        this.colorBrowseButton.addActionListener(this);
        this.colorBrowseButton.setEnabled(true);
        this.imageButton = UIUtil.newRadio((ResourceBundle)this.msg, (String)"Image", (ButtonGroup)bg, (ActionListener)this);
        this.imageButton.setActionCommand("ImageRadioButton");
        this.imageBrowseButton = new JButton(this.msg.getString("BrowseImages"));
        this.imageBrowseButton.setActionCommand("BrowseImages");
        this.imageBrowseButton.addActionListener(this);
        this.imageBrowseButton.setEnabled(false);
        if (orientation.isLeftToRight()) {
            temp2.add(this.colorButton);
            temp2.add(this.colorBrowseButton);
            temp2.add(this.imageButton);
            temp2.add(this.imageBrowseButton);
        } else {
            temp2.add(this.colorBrowseButton);
            temp2.add(this.colorButton);
            temp2.add(this.imageBrowseButton);
            temp2.add(this.imageButton);
        }
        UIUtil.makeSpringCompactGrid((Container)temp2, (int)2, (int)2, (int)0, (int)0, (int)6, (int)6);
        this.imageFileNameField = new JTextField(30);
        this.imageFileNameField.setEditable(false);
        temp.add((Component)this.imageFileNameField, "South");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        topPanel.add((Component)previewPanel, "Before");
        topPanel.add(changePanel);
        this.okButton = UIUtil.newButton((ResourceBundle)this.msg, (String)"OK", (String)"OKMnemonic");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = UIUtil.newButton((ResourceBundle)this.msg, (String)"Cancel", (String)"CancelMnemonic");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        Container buttons = UIUtil.createButtonFooter((JButton)this.okButton, (JButton)this.cancelButton);
        ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
        cp.setBorder(empty5Border);
        cp.add((Component)topPanel, "North");
        temp = new JPanel(new BorderLayout());
        temp.add((Component)new JSeparator(), "North");
        temp.add((Component)buttons, "South");
        cp.add((Component)temp, "South");
        this.setContentPane((Container)cp);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setResizable(true);
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ColorRadioButton")) {
            this.colorBrowseButton.setEnabled(true);
            this.imageBrowseButton.setEnabled(false);
            this.viewingColors = true;
            this.colorOrImageIcon.setColor(this.currentColor);
            this.okButton.setEnabled(true);
            String colorString = this.currentColor.toString();
            this.imageFileNameField.setText(colorString.substring(colorString.indexOf(91)));
            this.repaint();
        } else if (command.equals("ImageRadioButton")) {
            this.colorBrowseButton.setEnabled(false);
            this.imageBrowseButton.setEnabled(true);
            this.viewingColors = false;
            this.colorOrImageIcon.setColor(null);
            if (this.currentImageFileName != null) {
                this.imageFileNameField.setText(this.currentImageFileName);
                this.okButton.setEnabled(true);
            } else {
                this.imageFileNameField.setText(this.msg.getString("NoImageLabel"));
                this.okButton.setEnabled(false);
            }
            this.repaint();
        } else if (command.equals("BrowseColors")) {
            Color tempColor = JColorChooser.showDialog(this, this.msg.getString("BGColorChooserTitle"), this.currentColor);
            if (tempColor != null) {
                this.currentColor = tempColor;
                this.colorOrImageIcon.setColor(this.currentColor);
                String colorString = this.currentColor.toString();
                this.imageFileNameField.setText(colorString.substring(colorString.indexOf(91)));
                this.repaint();
            }
        } else if (command.equals("BrowseImages")) {
            int returnVal = this.imageChooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.currentImageFileName = this.imageChooser.getSelectedFile().getAbsolutePath();
                Image previewImage = this.getPreviewImage(this.currentImageFileName);
                if (previewImage == null) {
                    JOptionPane.showMessageDialog(this, this.msg.getString("ImageFileError") + "\n'" + this.currentImageFileName + "'", this.msg.getString("ErrorDialogTitle"), 0);
                    this.currentImageFileName = null;
                    this.okButton.setEnabled(false);
                    this.imageFileNameField.setText(this.msg.getString("NoImageLabel"));
                    this.colorOrImageIcon.setImage(null);
                    this.repaint();
                } else {
                    this.colorOrImageIcon.setImage(previewImage);
                    this.imageFileNameField.setText(this.currentImageFileName);
                    this.okButton.setEnabled(true);
                    this.repaint();
                }
            }
        } else if (command.equals("OK")) {
            this.setVisible(false);
        } else if (command.equals("Cancel")) {
            this.currentColor = null;
            this.currentImageFileName = null;
            this.setVisible(false);
        }
    }

    public Object getChosenBackground() {
        if (this.viewingColors) {
            return this.currentColor;
        }
        if (this.currentImageFileName != null) {
            return this.getImageFromFile(this.currentImageFileName);
        }
        return null;
    }

    public String getCurrentImageFileName() {
        if (this.viewingColors) {
            return null;
        }
        return this.currentImageFileName;
    }

    private Image getImageFromFile(String fileName) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(fileName));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.msg.getString("ImageFileIOError") + "\nFile: " + fileName + " -\n" + e, this.msg.getString("ErrorDialogTitle"), 0);
        }
        return image;
    }

    private Image getPreviewImage(String fileName) {
        BufferedImage image = null;
        File file = new File(fileName);
        if (file.isFile()) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (image != null) {
            BufferedImage bi = new BufferedImage(((Image)image).getWidth(this), ((Image)image).getHeight(this), 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(image, 0, 0, 120, 120, null);
            g2d.dispose();
            image = bi;
        }
        return image;
    }

    public void initializeData(Object defaultBackground, String imageFileName) {
        if (defaultBackground instanceof Color) {
            this.currentColor = (Color)defaultBackground;
            this.colorOrImageIcon.setColor(this.currentColor);
            this.colorOrImageIcon.setImage(null);
            this.currentImageFileName = null;
            String colorString = this.currentColor.toString();
            this.imageFileNameField.setText(colorString.substring(colorString.indexOf(91)));
            this.colorButton.setSelected(true);
            this.colorBrowseButton.setEnabled(true);
            this.imageBrowseButton.setEnabled(false);
            this.okButton.setEnabled(true);
            this.viewingColors = true;
        } else if (defaultBackground instanceof Image) {
            this.currentImageFileName = imageFileName;
            Image previewImage = this.getPreviewImage(this.currentImageFileName);
            this.colorOrImageIcon.setColor(null);
            this.colorOrImageIcon.setImage(previewImage);
            this.imageFileNameField.setText(this.currentImageFileName);
            this.currentColor = Color.WHITE;
            this.imageButton.setSelected(true);
            this.colorBrowseButton.setEnabled(false);
            this.imageBrowseButton.setEnabled(true);
            this.viewingColors = false;
        } else {
            JOptionPane.showMessageDialog(this, this.msg.getString("BGBadObjectMessage") + "\n" + defaultBackground, this.msg.getString("ErrorDialogTitle"), 0);
            this.currentImageFileName = null;
            this.imageFileNameField.setText(this.msg.getString("NoImageLabel"));
            this.currentColor = Color.WHITE;
            this.colorBrowseButton.setEnabled(true);
            this.imageBrowseButton.setEnabled(false);
            this.viewingColors = true;
        }
    }

    public void updateUI() {
        if (this.imageChooser != null) {
            SwingUtilities.updateComponentTreeUI(this.imageChooser);
        }
    }

    private static class ColorOrImageIcon
    extends ImageIcon {
        private Color color = Color.RED;

        private ColorOrImageIcon() {
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return 120;
        }

        @Override
        public int getIconWidth() {
            return 120;
        }

        @Override
        protected void loadImage(Image image) {
            if (image != null) {
                super.loadImage(image);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.getColor() != null) {
                Color old = g.getColor();
                g.setColor(this.getColor());
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                g.setColor(old);
            } else if (this.getImage() != null) {
                super.paintIcon(c, g, x, y);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

