/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;

public class RTextAreaOptionPanel
extends OptionsDialogPanel
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "RTextAreaOptionPanel";
    private JLabel tabSizeLabel;
    private JTextField tabSizeField;
    private int tabSize;
    private JCheckBox emulateTabsCheckBox;
    private JCheckBox linkCB;
    private JLabel modKeyLabel;
    private JComboBox modKeyCombo;
    private JLabel linkColorLabel;
    private RColorSwatchesButton linkColorButton;
    private JCheckBox wordWrapCheckBox;
    private JCheckBox highlightCurrentLineCheckBox;
    private RColorSwatchesButton hclColorButton;
    private JCheckBox marginLineCheckBox;
    private JTextField marginLinePositionField;
    private JLabel marginLineColorLabel;
    private RColorSwatchesButton marginLineColorButton;
    private int marginLinePosition;
    private JCheckBox visibleWhitespaceCheckBox;
    private JCheckBox visibleEOLCheckBox;
    private JCheckBox remWhitespaceLinesCheckBox;
    private JCheckBox autoInsertClosingCurlyCheckBox;
    private JCheckBox aaCheckBox;
    private JCheckBox fractionalMetricsCheckBox;
    private Box bracketMatchingPanel;
    private JCheckBox bracketMatchCheckBox;
    private JLabel bmBGColorLabel;
    private RColorSwatchesButton bmBGColorButton;
    private JLabel bmBorderColorLabel;
    private RColorSwatchesButton bmBorderColorButton;
    private JCheckBox bothBracketsCB;
    private JCheckBox showTabLinesCheckBox;
    private RColorSwatchesButton tabLineColorButton;
    private JButton restoreDefaultsButton;
    private static final String PROPERTY = "property";

    public RTextAreaOptionPanel() {
        this.setId(OPTION_PANEL_ID);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextarea.OptionPanel");
        this.setName(msg.getString("Title"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        Box tabPanel = Box.createVerticalBox();
        tabPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Tabs")));
        Box inputPanel = this.createHorizontalBox();
        this.tabSizeLabel = new JLabel(msg.getString("TabSize"));
        this.tabSizeField = new JTextField();
        this.tabSizeField.getDocument().addDocumentListener(this);
        Dimension size = new Dimension(40, this.tabSizeField.getPreferredSize().height);
        this.tabSizeField.setMaximumSize(size);
        this.tabSizeField.setPreferredSize(size);
        inputPanel.add(this.tabSizeLabel);
        inputPanel.add(this.tabSizeField);
        inputPanel.add(Box.createHorizontalGlue());
        tabPanel.add(inputPanel);
        this.emulateTabsCheckBox = new JCheckBox(msg.getString("EmulateTabs"));
        this.emulateTabsCheckBox.setActionCommand("EmulateTabsCheckBox");
        this.emulateTabsCheckBox.addActionListener(this);
        this.addLeftAligned(tabPanel, this.emulateTabsCheckBox);
        tabPanel.add(Box.createVerticalGlue());
        topPanel.add(tabPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box linkPanel = Box.createVerticalBox();
        linkPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Hyperlinks")));
        this.linkCB = new JCheckBox(msg.getString("MakeLinksClickable"));
        this.linkCB.setActionCommand("MakeLinksClickable");
        this.linkCB.addActionListener(this);
        this.addLeftAligned(linkPanel, this.linkCB, 5);
        this.modKeyCombo = this.createModKeyCombo();
        this.modKeyLabel = new JLabel(msg.getString("ModifierKey"));
        this.modKeyLabel.setLabelFor(this.modKeyCombo);
        this.linkColorButton = new RColorSwatchesButton();
        this.linkColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.linkColorLabel = new JLabel(msg.getString("HyperlinkColor"));
        this.linkColorLabel.setLabelFor((Component)this.linkColorButton);
        JPanel modKeyPanel = new JPanel(new BorderLayout());
        modKeyPanel.add((Component)this.modKeyCombo, "Before");
        JPanel linkColorPanel = new JPanel(new BorderLayout());
        linkColorPanel.add((Component)this.linkColorButton, "Before");
        Box box = this.createHorizontalBox();
        box.add(Box.createHorizontalStrut(20));
        box.add(this.modKeyLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.modKeyCombo);
        box.add(Box.createHorizontalStrut(40));
        box.add(this.linkColorLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)this.linkColorButton);
        box.add(Box.createHorizontalGlue());
        linkPanel.add(box);
        topPanel.add(linkPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box bigOtherPanel = Box.createVerticalBox();
        bigOtherPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Other")));
        this.wordWrapCheckBox = new JCheckBox(msg.getString("WordWrap"));
        this.wordWrapCheckBox.setActionCommand("WordWrapCheckBox");
        this.wordWrapCheckBox.addActionListener(this);
        this.addLeftAligned(bigOtherPanel, this.wordWrapCheckBox);
        Box otherPanel = new Box(2);
        this.highlightCurrentLineCheckBox = new JCheckBox(msg.getString("HighlightCL"));
        this.highlightCurrentLineCheckBox.setActionCommand("HighlightCurrentLineCheckBox");
        this.highlightCurrentLineCheckBox.addActionListener(this);
        this.hclColorButton = new RColorSwatchesButton();
        this.hclColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        otherPanel.add(this.highlightCurrentLineCheckBox);
        otherPanel.add((Component)this.hclColorButton);
        otherPanel.add(Box.createHorizontalGlue());
        bigOtherPanel.add(otherPanel);
        otherPanel = new Box(2);
        this.marginLineCheckBox = new JCheckBox(msg.getString("DrawML"));
        this.marginLineCheckBox.setActionCommand("MarginLineCheckBox");
        this.marginLineCheckBox.addActionListener(this);
        this.marginLinePositionField = new JTextField();
        this.marginLinePositionField.getDocument().addDocumentListener(this);
        size = new Dimension(40, this.marginLinePositionField.getPreferredSize().height);
        this.marginLinePositionField.setMaximumSize(size);
        this.marginLinePositionField.setPreferredSize(size);
        this.marginLineColorLabel = new JLabel(msg.getString("WithThisColor"));
        this.marginLineColorButton = new RColorSwatchesButton();
        this.marginLineColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.marginLineColorLabel.setLabelFor((Component)this.marginLineColorButton);
        otherPanel.add(this.marginLineCheckBox);
        otherPanel.add(this.marginLinePositionField);
        otherPanel.add(Box.createHorizontalStrut(5));
        otherPanel.add(this.marginLineColorLabel);
        otherPanel.add((Component)this.marginLineColorButton);
        otherPanel.add(Box.createHorizontalGlue());
        bigOtherPanel.add(otherPanel);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.visibleWhitespaceCheckBox = this.createCheckBox(msg, "VisibleWhitespace");
        this.addLeftAligned(bigOtherPanel, this.visibleWhitespaceCheckBox);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.visibleEOLCheckBox = this.createCheckBox(msg, "VisibleEOL");
        this.addLeftAligned(bigOtherPanel, this.visibleEOLCheckBox);
        this.autoInsertClosingCurlyCheckBox = this.createCheckBox(msg, "AutoCloseCurlys");
        this.addLeftAligned(bigOtherPanel, this.autoInsertClosingCurlyCheckBox);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.remWhitespaceLinesCheckBox = this.createCheckBox(msg, "RemWhitespaceLines");
        this.addLeftAligned(bigOtherPanel, this.remWhitespaceLinesCheckBox);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.aaCheckBox = new JCheckBox(msg.getString("SmoothText"));
        this.aaCheckBox.setActionCommand("aaCB");
        this.aaCheckBox.addActionListener(this);
        this.addLeftAligned(bigOtherPanel, this.aaCheckBox);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.fractionalMetricsCheckBox = this.createCheckBox(msg, "FracFM");
        this.addLeftAligned(bigOtherPanel, this.fractionalMetricsCheckBox);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.bracketMatchingPanel = this.createHorizontalBox();
        this.bracketMatchCheckBox = new JCheckBox(msg.getString("HighlightMB"));
        this.bracketMatchCheckBox.setActionCommand("BracketMatchCheckBox");
        this.bracketMatchCheckBox.addActionListener(this);
        this.bmBGColorLabel = new JLabel(msg.getString("BackgroundFill"));
        this.bmBGColorButton = new RColorSwatchesButton();
        this.bmBGColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.bmBorderColorLabel = new JLabel(msg.getString("Border"));
        this.bmBorderColorButton = new RColorSwatchesButton();
        this.bmBorderColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        this.bracketMatchingPanel.add(this.bracketMatchCheckBox);
        this.bracketMatchingPanel.add(this.bmBGColorLabel);
        this.bracketMatchingPanel.add((Component)this.bmBGColorButton);
        this.bracketMatchingPanel.add(Box.createHorizontalStrut(5));
        this.bracketMatchingPanel.add(this.bmBorderColorLabel);
        this.bracketMatchingPanel.add((Component)this.bmBorderColorButton);
        this.bracketMatchingPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(bigOtherPanel, this.bracketMatchingPanel);
        this.bothBracketsCB = new JCheckBox(msg.getString("HighlightBothBrackets"));
        this.bothBracketsCB.setActionCommand("BothBracketsCB");
        this.bothBracketsCB.addActionListener(this);
        this.addLeftAligned(bigOtherPanel, this.bothBracketsCB, 3, 20);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        this.showTabLinesCheckBox = new JCheckBox(msg.getString("ShowIndentGuide"));
        this.showTabLinesCheckBox.setActionCommand("ShowIndentGuide");
        this.showTabLinesCheckBox.addActionListener(this);
        box = this.createHorizontalBox();
        box.add(this.showTabLinesCheckBox);
        box.add(Box.createHorizontalStrut(5));
        this.tabLineColorButton = new RColorSwatchesButton();
        this.tabLineColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        box.add((Component)this.tabLineColorButton);
        box.add(Box.createHorizontalGlue());
        this.addLeftAligned(bigOtherPanel, box);
        bigOtherPanel.add(Box.createVerticalStrut(3));
        topPanel.add(bigOtherPanel);
        this.restoreDefaultsButton = new JButton(msg.getString("RestoreDefaults"));
        this.restoreDefaultsButton.setActionCommand("RestoreDefaults");
        this.restoreDefaultsButton.addActionListener(this);
        this.addLeftAligned(topPanel, this.restoreDefaultsButton);
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
        msg = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("RestoreDefaults".equals(command)) {
            Color defaultCurrentLineHighlightColor = RTextArea.getDefaultCurrentLineHighlightColor();
            int defaultTabSize = RTextArea.getDefaultTabSize();
            int defaultMarginLinePosition = RTextArea.getDefaultMarginLinePosition();
            Color defaultMarginLineColor = RTextArea.getDefaultMarginLineColor();
            boolean defaultAA = File.separatorChar == '\\';
            Color defaultBMBGColor = RSyntaxTextArea.getDefaultBracketMatchBGColor();
            Color defaultBMBorderColor = RSyntaxTextArea.getDefaultBracketMatchBorderColor();
            if (this.wordWrapCheckBox.isSelected() || !this.highlightCurrentLineCheckBox.isSelected() || !this.getCurrentLineHighlightColor().equals(defaultCurrentLineHighlightColor) || this.getTabSize() != defaultTabSize || this.getEmulateTabs() || !this.linkCB.isSelected() || this.modKeyCombo.getSelectedIndex() != 0 || !this.linkColorButton.getColor().equals(Color.BLUE) || !this.marginLineCheckBox.isSelected() || this.getMarginLinePosition() != defaultMarginLinePosition || !this.getMarginLineColor().equals(defaultMarginLineColor) || this.isWhitespaceVisible() || this.visibleEOLCheckBox.isSelected() || this.autoInsertClosingCurlyCheckBox.isSelected() || this.remWhitespaceLinesCheckBox.isSelected() || this.aaCheckBox.isSelected() != defaultAA || this.fractionalMetricsCheckBox.isSelected() || !this.bracketMatchCheckBox.isSelected() || !this.bmBGColorButton.getColor().equals(defaultBMBGColor) || !this.bmBorderColorButton.getColor().equals(defaultBMBorderColor) || this.bothBracketsCB.isSelected() || this.showTabLinesCheckBox.isSelected() || !Color.gray.equals(this.tabLineColorButton.getColor())) {
                this.wordWrapCheckBox.setSelected(false);
                this.highlightCurrentLineCheckBox.setSelected(true);
                this.hclColorButton.setEnabled(true);
                this.setCurrentLineHighlightColor(defaultCurrentLineHighlightColor);
                this.setTabSize(defaultTabSize);
                this.setEmulateTabs(false);
                this.linkCB.setSelected(true);
                this.modKeyCombo.setSelectedIndex(0);
                this.linkColorButton.setColor(Color.BLUE);
                this.setMarginLineEnabled(true);
                this.setMarginLinePosition(defaultMarginLinePosition);
                this.setMarginLineColor(defaultMarginLineColor);
                this.setHyperlinksEnabled(true);
                this.setWhitespaceVisible(false);
                this.visibleEOLCheckBox.setSelected(false);
                this.autoInsertClosingCurlyCheckBox.setSelected(false);
                this.remWhitespaceLinesCheckBox.setSelected(false);
                this.aaCheckBox.setSelected(defaultAA);
                this.fractionalMetricsCheckBox.setSelected(false);
                this.setBracketMatchCheckboxSelected(true);
                this.setBracketMatchBGColor(defaultBMBGColor);
                this.bmBorderColorButton.setColor(defaultBMBorderColor);
                this.bothBracketsCB.setSelected(false);
                this.setTabLinesEnabled(false);
                this.tabLineColorButton.setColor(Color.gray);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, null, null);
            }
        } else if ("WordWrapCheckBox".equals(command)) {
            boolean ww = this.wordWrapCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !ww, ww);
        } else if ("HighlightCurrentLineCheckBox".equals(command)) {
            boolean selected = this.highlightCurrentLineCheckBox.isSelected();
            this.hclColorButton.setEnabled(selected);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if ("EmulateTabsCheckBox".equals(command)) {
            boolean selected = this.emulateTabsCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if ("MarginLineCheckBox".equals(command)) {
            boolean selected = this.marginLineCheckBox.isSelected();
            this.marginLinePositionField.setEnabled(selected);
            this.marginLineColorButton.setEnabled(selected);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if ("MakeLinksClickable".equals(command)) {
            boolean selected = this.linkCB.isSelected();
            this.modKeyLabel.setEnabled(selected);
            this.modKeyCombo.setEnabled(selected);
            this.linkColorLabel.setEnabled(selected);
            this.linkColorButton.setEnabled(selected);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !selected, selected);
        } else if ("ModKeyCombo".equals(command)) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, -1, this.modKeyCombo.getSelectedIndex());
        } else if ("VisibleWhitespace".equals(command)) {
            boolean visible = this.visibleWhitespaceCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !visible, visible);
        } else if ("VisibleEOL".equals(command)) {
            boolean visible = this.visibleEOLCheckBox.isSelected();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(PROPERTY, !visible, visible);
        } else if (!"AutoIndent".equals(command)) {
            if ("RemWhitespaceLines".equals(command)) {
                boolean visible = this.remWhitespaceLinesCheckBox.isSelected();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !visible, visible);
            } else if ("AutoCloseCurlys".equals(command)) {
                boolean visible = this.autoInsertClosingCurlyCheckBox.isSelected();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !visible, visible);
            } else if ("aaCB".equals(command)) {
                boolean selected = this.aaCheckBox.isSelected();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !selected, selected);
            } else if ("FracFM".equals(command)) {
                boolean frac = this.fractionalMetricsCheckBox.isSelected();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !frac, frac);
            } else if ("BracketMatchCheckBox".equals(command)) {
                boolean selected = this.bracketMatchCheckBox.isSelected();
                this.bmBGColorButton.setEnabled(selected);
                this.bmBorderColorButton.setEnabled(selected);
                this.bothBracketsCB.setEnabled(selected);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !selected, selected);
            } else if ("BothBracketsCB".equals(command)) {
                boolean selected = this.bothBracketsCB.isSelected();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !selected, selected);
            } else if ("ShowIndentGuide".equals(command)) {
                boolean show = this.showTabLinesCheckBox.isSelected();
                this.tabLineColorButton.setEnabled(show);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, !show, show);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private JCheckBox createCheckBox(ResourceBundle msg, String key) {
        JCheckBox cb = new JCheckBox(msg.getString(key));
        cb.setActionCommand(key);
        cb.addActionListener(this);
        return cb;
    }

    private JComboBox createModKeyCombo() {
        Object[] items = new Integer[]{new Integer(128), new Integer(256), new Integer(64), new Integer(512)};
        JComboBox combo = new JComboBox(items){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        combo.setRenderer(new ModKeyCellRenderer());
        combo.setActionCommand("ModKeyCombo");
        combo.addActionListener(this);
        return combo;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setLineWrap(this.getWordWrap());
        rtext.setRowColumnIndicatorVisible(!mainView.getLineWrap());
        if (this.isCurrentLineHighlightCheckboxSelected()) {
            mainView.setCurrentLineHighlightEnabled(true);
            mainView.setCurrentLineHighlightColor(this.getCurrentLineHighlightColor());
        } else {
            mainView.setCurrentLineHighlightEnabled(false);
        }
        mainView.setTabSize(this.getTabSize());
        mainView.setTabsEmulated(this.getEmulateTabs());
        mainView.setMarginLineEnabled(this.isMarginLineEnabled());
        mainView.setMarginLinePosition(this.getMarginLinePosition());
        mainView.setMarginLineColor(this.getMarginLineColor());
        mainView.setHyperlinksEnabled(this.getHyperlinksEnabled());
        mainView.setHyperlinkColor(this.getHyperlinkColor());
        mainView.setHyperlinkModifierKey(this.getHyperlinkModifierKey());
        mainView.setRememberWhitespaceLines(!this.remWhitespaceLinesCheckBox.isSelected());
        mainView.setAutoInsertClosingCurlys(this.autoInsertClosingCurlyCheckBox.isSelected());
        mainView.setWhitespaceVisible(this.isWhitespaceVisible());
        mainView.setShowEOLMarkers(this.visibleEOLCheckBox.isSelected());
        mainView.setAntiAliasEnabled(this.aaCheckBox.isSelected());
        mainView.setFractionalFontMetricsEnabled(this.fractionalMetricsCheckBox.isSelected());
        boolean bmEnabled = this.isBracketMatchCheckboxSelected();
        mainView.setBracketMatchingEnabled(bmEnabled);
        mainView.setMatchedBracketBGColor(this.getBracketMatchBGColor());
        mainView.setMatchedBracketBorderColor(this.bmBorderColorButton.getColor());
        mainView.setMatchBothBrackets(this.bothBracketsCB.isSelected());
        mainView.setShowTabLines(this.showTabLinesCheckBox.isSelected());
        mainView.setTabLinesColor(this.tabLineColorButton.getColor());
    }

    private void doDocumentUpdated(DocumentEvent e) {
        this.hasUnsavedChanges = true;
        Document modifiedDocument = e.getDocument();
        if (modifiedDocument == this.tabSizeField.getDocument()) {
            this.firePropertyChange(PROPERTY, null, this.tabSizeField.getText());
        } else if (modifiedDocument == this.marginLinePositionField.getDocument()) {
            this.firePropertyChange(PROPERTY, null, this.marginLinePositionField.getText());
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        int temp = 0;
        try {
            temp = Integer.parseInt(this.tabSizeField.getText());
            if (temp < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            OptionsDialogPanel.OptionsPanelCheckResult res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this);
            res.errorMessage = "Invalid number format for tab size;\nPlease input a tab size greater than zero.";
            res.component = this.tabSizeField;
            this.tabSize = -1;
            return res;
        }
        this.tabSize = temp;
        try {
            temp = Integer.parseInt(this.marginLinePositionField.getText());
            if (temp < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            OptionsDialogPanel.OptionsPanelCheckResult res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this);
            res.errorMessage = "Invalid margin line position;\nPlease input a position greater than zero.";
            res.component = this.marginLinePositionField;
            this.marginLinePosition = -1;
            return res;
        }
        this.marginLinePosition = temp;
        return null;
    }

    public Color getBracketMatchBGColor() {
        return this.bmBGColorButton.getColor();
    }

    public Color getCurrentLineHighlightColor() {
        return this.hclColorButton.getColor();
    }

    public boolean getEmulateTabs() {
        return this.emulateTabsCheckBox.isSelected();
    }

    private Color getHyperlinkColor() {
        return this.linkColorButton.getColor();
    }

    private int getHyperlinkModifierKey() {
        switch (this.modKeyCombo.getSelectedIndex()) {
            default: {
                return 128;
            }
            case 1: {
                return 256;
            }
            case 2: {
                return 64;
            }
            case 3: 
        }
        return 512;
    }

    public boolean getHyperlinksEnabled() {
        return this.linkCB.isSelected();
    }

    public Color getMarginLineColor() {
        return this.marginLineColorButton.getColor();
    }

    public int getMarginLinePosition() {
        return this.marginLinePosition;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public JComponent getTopJComponent() {
        return this.tabSizeField;
    }

    public boolean getWordWrap() {
        return this.wordWrapCheckBox.isSelected();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doDocumentUpdated(e);
    }

    public boolean isBracketMatchCheckboxSelected() {
        return this.bracketMatchCheckBox.isSelected();
    }

    public boolean isCurrentLineHighlightCheckboxSelected() {
        return this.highlightCurrentLineCheckBox.isSelected();
    }

    public boolean isMarginLineEnabled() {
        return this.marginLineCheckBox.isSelected();
    }

    public boolean isWhitespaceVisible() {
        return this.visibleWhitespaceCheckBox.isSelected();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(PROPERTY, e.getOldValue(), e.getNewValue());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doDocumentUpdated(e);
    }

    public void setBracketMatchBGColor(Color color) {
        this.bmBGColorButton.setColor(color);
    }

    public void setBracketMatchCheckboxSelected(boolean selected) {
        this.bracketMatchCheckBox.setSelected(selected);
        this.bmBGColorButton.setEnabled(selected);
        this.bmBorderColorButton.setEnabled(selected);
        this.bothBracketsCB.setEnabled(selected);
    }

    private void setCurrentLineHighlightColor(Color color) {
        this.hclColorButton.setColor(color);
    }

    private void setCurrentLineHighlightCheckboxSelected(boolean selected) {
        this.highlightCurrentLineCheckBox.setSelected(selected);
        this.hclColorButton.setEnabled(selected);
    }

    private void setEmulateTabs(boolean areEmulated) {
        this.emulateTabsCheckBox.setSelected(areEmulated);
    }

    private void setHyperlinkColor(Color c) {
        this.linkColorButton.setColor(c);
    }

    private void setHyperlinkModifierKey(int key) {
        switch (key) {
            default: {
                this.modKeyCombo.setSelectedIndex(0);
                break;
            }
            case 256: {
                this.modKeyCombo.setSelectedIndex(1);
                break;
            }
            case 64: {
                this.modKeyCombo.setSelectedIndex(2);
                break;
            }
            case 512: {
                this.modKeyCombo.setSelectedIndex(3);
            }
        }
    }

    private void setHyperlinksEnabled(boolean enabled) {
        this.linkCB.setSelected(enabled);
        this.modKeyLabel.setEnabled(enabled);
        this.modKeyCombo.setEnabled(enabled);
        this.linkColorLabel.setEnabled(enabled);
        this.linkColorButton.setEnabled(enabled);
    }

    private void setMarginLineColor(Color color) {
        this.marginLineColorButton.setColor(color);
    }

    private void setMarginLineEnabled(boolean enabled) {
        this.marginLineCheckBox.setSelected(enabled);
        this.marginLinePositionField.setEnabled(enabled);
        this.marginLineColorButton.setEnabled(enabled);
    }

    private void setMarginLinePosition(int position) {
        if (this.marginLinePosition != position && position > 0) {
            this.marginLinePosition = position;
        }
        this.marginLinePositionField.setText(Integer.toString(this.marginLinePosition));
    }

    public void setTabLinesEnabled(boolean enabled) {
        this.showTabLinesCheckBox.setSelected(enabled);
        this.tabLineColorButton.setEnabled(enabled);
    }

    private void setTabSize(int tabSize) {
        if (this.tabSize != tabSize && tabSize > 0) {
            this.tabSize = tabSize;
        }
        this.tabSizeField.setText(Integer.toString(tabSize));
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setWordWrap(mainView.getLineWrap());
        this.setCurrentLineHighlightCheckboxSelected(mainView.isCurrentLineHighlightEnabled());
        this.setCurrentLineHighlightColor(mainView.getCurrentLineHighlightColor());
        this.setTabSize(mainView.getTabSize());
        this.setEmulateTabs(mainView.areTabsEmulated());
        this.setMarginLineEnabled(mainView.isMarginLineEnabled());
        this.setMarginLinePosition(mainView.getMarginLinePosition());
        this.setMarginLineColor(mainView.getMarginLineColor());
        this.setHyperlinksEnabled(mainView.getHyperlinksEnabled());
        this.setHyperlinkColor(mainView.getHyperlinkColor());
        this.setHyperlinkModifierKey(mainView.getHyperlinkModifierKey());
        this.remWhitespaceLinesCheckBox.setSelected(!mainView.getRememberWhitespaceLines());
        this.autoInsertClosingCurlyCheckBox.setSelected(mainView.getAutoInsertClosingCurlys());
        this.setWhitespaceVisible(mainView.isWhitespaceVisible());
        this.visibleEOLCheckBox.setSelected(mainView.getShowEOLMarkers());
        this.aaCheckBox.setSelected(mainView.isAntiAliasEnabled());
        this.fractionalMetricsCheckBox.setSelected(mainView.isFractionalFontMetricsEnabled());
        boolean bmEnabled = mainView.isBracketMatchingEnabled();
        this.setBracketMatchCheckboxSelected(bmEnabled);
        this.setBracketMatchBGColor(mainView.getMatchedBracketBGColor());
        this.bmBorderColorButton.setColor(mainView.getMatchedBracketBorderColor());
        this.bothBracketsCB.setSelected(mainView.getMatchBothBrackets());
        this.setTabLinesEnabled(mainView.getShowTabLines());
        this.tabLineColorButton.setColor(mainView.getTabLinesColor());
    }

    public void setWhitespaceVisible(boolean visible) {
        this.visibleWhitespaceCheckBox.setSelected(visible);
    }

    private void setWordWrap(boolean enabled) {
        this.wordWrapCheckBox.setSelected(enabled);
    }

    private static class ModKeyCellRenderer
    extends DefaultListCellRenderer {
        private ModKeyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            int i = (Integer)value;
            this.setText(InputEvent.getModifiersExText(i));
            return this;
        }
    }
}

