/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupController;
import net.sourceforge.squirrel_sql.client.session.EntryPanelManager;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcherFactory;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.EditExtrasAccessor;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLBookmarksAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLToolsPopUpAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlSyntaxHighlightTokenMatcherProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateConnectionProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.ToolsPopupAccessorProxy;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLCompleteCodeAction;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateSQLUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HqlQueryErrorUtil;

public class HQLEntryPanelManager
extends EntryPanelManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HQLEntryPanelManager.class);
    private HqlSyntaxHighlightTokenMatcherProxy _hqlSyntaxHighlightTokenMatcherProxy = new HqlSyntaxHighlightTokenMatcherProxy();
    private HibernatePluginResources _resources;
    private IHibernateConnectionProvider _connectionProvider;
    private ToolsPopupController _toolsPopupController;

    public HQLEntryPanelManager(final ISession session, HibernatePluginResources resources, IHibernateConnectionProvider connectionProvider) {
        super(session);
        this._connectionProvider = connectionProvider;
        ToolsPopupAccessorProxy tpap = new ToolsPopupAccessorProxy();
        this.init(this.createSyntaxHighlightTokenMatcherFactory(), tpap);
        this._resources = resources;
        this.initToolsPopUp();
        tpap.apply(this);
        this.initCodeCompletion();
        this.initBookmarks();
        String strQuote = s_stringMgr.getString("HQLEntryPanelManager.quoteHQL");
        AbstractAction quoteHql = new AbstractAction(strQuote){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onQuoteHQL();
            }
        };
        quoteHql.putValue("ShortDescription", strQuote);
        this.addToSQLEntryAreaMenu(quoteHql, "quote");
        String strQuoteSb = s_stringMgr.getString("HQLEntryPanelManager.quoteHQLsb");
        AbstractAction quoteSbHql = new AbstractAction(strQuoteSb){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onQuoteHQLSb();
            }
        };
        quoteSbHql.putValue("ShortDescription", strQuoteSb);
        this.addToSQLEntryAreaMenu(quoteSbHql, "quotesb");
        String strUnquote = s_stringMgr.getString("HQLEntryPanelManager.unquoteHQL");
        AbstractAction unquoteHql = new AbstractAction(strUnquote){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onUnquoteHQL();
            }
        };
        unquoteHql.putValue("ShortDescription", strUnquote);
        this.addToSQLEntryAreaMenu(unquoteHql, "unquote");
        String strEscapeDate = s_stringMgr.getString("HQLEntryPanelManager.escapeDate");
        AbstractAction escapeDate = new AbstractAction(strEscapeDate){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onEscapeDate();
            }
        };
        escapeDate.putValue("ShortDescription", strEscapeDate);
        this.addToSQLEntryAreaMenu(escapeDate, "date");
        String strCopySqlToClip = s_stringMgr.getString("HQLEntryPanelManager.copySqlToClip");
        AbstractAction copySqlToClip = new AbstractAction(strCopySqlToClip){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLEntryPanelManager.this.onCopySqlToClip(session);
            }
        };
        copySqlToClip.putValue("ShortDescription", strCopySqlToClip);
        this.addToSQLEntryAreaMenu(copySqlToClip, "sqltoclip");
    }

    private void onCopySqlToClip(ISession session) {
        try {
            HibernateSQLUtil.copySqlToClipboard(this._connectionProvider.getHibernateConnection(), this.getEntryPanel().getSQLToBeExecuted(), session);
            session.showMessage(s_stringMgr.getString("HQLEntryPanelManager.copySqlToClipSucceeded"));
        }
        catch (Throwable t) {
            HqlQueryErrorUtil.handleHqlQueryError(t, session, true);
        }
    }

    private void onEscapeDate() {
        String str = EditExtrasAccessor.escapeDate(this.getEntryPanel());
        if (null != str) {
            this.getEntryPanel().replaceSelection(str);
        }
    }

    private void initBookmarks() {
        HQLBookmarksAction hba = new HQLBookmarksAction(this.getSession().getApplication(), (Resources)this._resources, this.getEntryPanel());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)hba), "bookmarkselect");
        this._resources.configureMenuItem((Action)((Object)hba), item);
        this.registerKeyboardAction((Action)((Object)hba), this._resources.getKeyStroke((Action)((Object)hba)));
    }

    private void initToolsPopUp() {
        this._toolsPopupController = new ToolsPopupController(this.getSession(), this.getEntryPanel());
        HQLToolsPopUpAction htp = new HQLToolsPopUpAction(this._resources, this._toolsPopupController, this.getSession().getApplication());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)htp), null);
        this._resources.configureMenuItem((Action)((Object)htp), item);
        this.registerKeyboardAction((Action)((Object)htp), this._resources.getKeyStroke((Action)((Object)htp)));
    }

    private void initCodeCompletion() {
        HQLCompleteCodeAction hcca = new HQLCompleteCodeAction(this.getSession().getApplication(), this._resources, this, this._connectionProvider, this._hqlSyntaxHighlightTokenMatcherProxy, this.getSession());
        JMenuItem item = this.addToSQLEntryAreaMenu((Action)((Object)hcca), "complete");
        this._resources.configureMenuItem((Action)((Object)hcca), item);
        this.registerKeyboardAction((Action)((Object)hcca), this._resources.getKeyStroke((Action)((Object)hcca)));
    }

    private ISyntaxHighlightTokenMatcherFactory createSyntaxHighlightTokenMatcherFactory() {
        return new ISyntaxHighlightTokenMatcherFactory(){

            public ISyntaxHighlightTokenMatcher getSyntaxHighlightTokenMatcher(ISession sess, JTextComponent editorPane) {
                HQLEntryPanelManager.this._hqlSyntaxHighlightTokenMatcherProxy.setEditorPane(editorPane);
                return HQLEntryPanelManager.this._hqlSyntaxHighlightTokenMatcherProxy;
            }
        };
    }

    private void onUnquoteHQL() {
        EditExtrasAccessor.unquoteHQL(this.getEntryPanel());
    }

    private void onQuoteHQLSb() {
        EditExtrasAccessor.quoteHQLSb(this.getEntryPanel());
    }

    private void onQuoteHQL() {
        EditExtrasAccessor.quoteHQL(this.getEntryPanel());
    }

    public JMenuItem addToSQLEntryAreaMenu(Action action, String toolsPopupSelectionString) {
        if (null != toolsPopupSelectionString) {
            this._toolsPopupController.addAction(toolsPopupSelectionString, action);
        }
        return this.getEntryPanel().addToSQLEntryAreaMenu(action);
    }

    public void registerKeyboardAction(Action action, KeyStroke keyStroke) {
        JTextArea comp = this.getEntryPanel().getTextComponent();
        comp.registerKeyboardAction(action, keyStroke, 1);
    }
}

