/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;

public class HibernateTabPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HibernateTabPanel.class);
    private static final String PERF_KEY_LAST_SELECTED_TAB = "Squirrel.hibernateplugin.lastSelectedTab";
    JComboBox cboConfigurations;
    JToggleButton btnConnected;
    JButton btnOpenConfigs;
    private JSplitPane _splitHqlSql;
    private JPanel _toolbar;
    private int _curXOfToolbar;
    private JTabbedPane _tabObjectsHql;
    private HibernatePluginResources _resource;

    public HibernateTabPanel(JComponent mappedObjectComp, JComponent hqlTextComp, JComponent hqlResultComp, HibernatePluginResources resource) {
        this._resource = resource;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this._toolbar = this.createToolbar();
        this.add((Component)this._toolbar, gbc);
        this._splitHqlSql = new JSplitPane(0, hqlTextComp, hqlResultComp);
        this._tabObjectsHql = new JTabbedPane();
        this._tabObjectsHql.add(s_stringMgr.getString("HQLTabPanel.mappedObjects"), mappedObjectComp);
        this._tabObjectsHql.add(s_stringMgr.getString("HQLTabPanel.hql"), this._splitHqlSql);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this._tabObjectsHql, gbc);
        this._tabObjectsHql.setSelectedIndex(Preferences.userRoot().getInt(PERF_KEY_LAST_SELECTED_TAB, 0));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HibernateTabPanel.this._splitHqlSql.setDividerLocation(0.5);
            }
        });
    }

    public void closing() {
        Preferences.userRoot().putInt(PERF_KEY_LAST_SELECTED_TAB, this._tabObjectsHql.getSelectedIndex());
    }

    private JPanel createToolbar() {
        JPanel ret = new JPanel();
        ret.setLayout(new GridBagLayout());
        this._curXOfToolbar = 0;
        JLabel lblCfg = new JLabel(s_stringMgr.getString("HQLTabPanel.configuration"));
        GridBagConstraints gbc = new GridBagConstraints(this._curXOfToolbar++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)lblCfg, gbc);
        this.cboConfigurations = new JComboBox();
        gbc = new GridBagConstraints(this._curXOfToolbar++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0);
        ret.add((Component)this.cboConfigurations, gbc);
        gbc = new GridBagConstraints(this._curXOfToolbar++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnConnected = new JToggleButton();
        this.btnConnected.setToolTipText(s_stringMgr.getString("hibernate.HQLTabPanel.connect"));
        ret.add((Component)this.btnConnected, gbc);
        gbc = new GridBagConstraints(this._curXOfToolbar++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnOpenConfigs = new JButton(this._resource.getIcon("hibernate"));
        this.btnOpenConfigs.setToolTipText(s_stringMgr.getString("hibernate.HibernateTabPanel.openConfigs"));
        ret.add((Component)this.btnOpenConfigs, gbc);
        return ret;
    }

    public void addToToolbar(JComponent comp) {
        GridBagConstraints gbc = new GridBagConstraints(this._curXOfToolbar++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._toolbar.add((Component)comp, gbc);
        this._toolbar.validate();
    }
}

