/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.hibernate.ConnectionListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateConnectionProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailPanelController;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfoTreeWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedObjectPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappingRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappingTreeCellRenderer;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfoTreeWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;

public class MappedObjectPanelManager {
    private static final String PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED = "Squirrel.hibernateplugin.chkShowQualified";
    private MappedObjectPanel _panel;
    private IHibernateConnectionProvider _connectionProvider;
    private ISession _session;
    private DefaultMutableTreeNode _root;
    private HashMap<String, MappedClassInfo> _mappedClassInfoByClassName;
    private DetailPanelController _detailPanelController;
    private ArrayList<MappedClassInfoTreeWrapper> _mappedClassInfoTreeWrappers;

    public MappedObjectPanelManager(IHibernateConnectionProvider connectionProvider, ISession session, HibernatePluginResources resource) {
        this._connectionProvider = connectionProvider;
        this._session = session;
        this._detailPanelController = new DetailPanelController(this._session);
        this._panel = new MappedObjectPanel(this._detailPanelController.getDetailComponent());
        this._root = new DefaultMutableTreeNode(new MappingRoot());
        this._panel.objectTree.setModel(new DefaultTreeModel(this._root));
        this._panel.objectTree.setCellRenderer(new MappingTreeCellRenderer(resource));
        this.nodeStructurChanged(this._root);
        this._panel.objectTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                MappedObjectPanelManager.this.onTreeExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this._panel.objectTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MappedObjectPanelManager.this.onTreeSelectionChanged(e);
            }
        });
        this._connectionProvider.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionOpened(HibernateConnection con, HibernateConfiguration cfg) {
                MappedObjectPanelManager.this.initRoot(con, cfg);
                MappedObjectPanelManager.this.initTree(con);
            }

            @Override
            public void connectionClosed() {
                MappedObjectPanelManager.this.onConnectionClosed();
            }
        });
        this._panel.chkShowQualified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MappedObjectPanelManager.this.onChkQualified();
            }
        });
        this._panel.chkShowQualified.setSelected(Preferences.userRoot().getBoolean(PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED, false));
    }

    private void initRoot(HibernateConnection con, HibernateConfiguration cfg) {
        MappingRoot mr = (MappingRoot)this._root.getUserObject();
        mr.init(con, cfg);
    }

    private void onChkQualified() {
        HibernateConnection con = this._connectionProvider.getHibernateConnection();
        if (null == con) {
            return;
        }
        this._root.removeAllChildren();
        this.initTree(con);
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (null != n && null != n.getUserObject()) {
            this._detailPanelController.selectionChanged(n.getUserObject());
        } else {
            this._detailPanelController.clearDetail();
        }
    }

    private void onTreeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode mappedClassInfoWrapperNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        Object userObject = mappedClassInfoWrapperNode.getUserObject();
        if (userObject instanceof MappedClassInfoTreeWrapper && !((MappedClassInfoTreeWrapper)userObject).isExpanded()) {
            for (int i = 0; i < mappedClassInfoWrapperNode.getChildCount(); ++i) {
                DefaultMutableTreeNode propertyInfoNode = (DefaultMutableTreeNode)mappedClassInfoWrapperNode.getChildAt(i);
                PropertyInfoTreeWrapper propertyInfoTreeWrapper = (PropertyInfoTreeWrapper)propertyInfoNode.getUserObject();
                MappedClassInfo mappedClassInfo = propertyInfoTreeWrapper.getMappedClassInfo();
                this.addMappedClassInfoNode(this.createMappedClassInfoTreeWrapper(mappedClassInfo), propertyInfoNode);
            }
            ((MappedClassInfoTreeWrapper)userObject).setExpanded(true);
            this.nodeStructurChanged(mappedClassInfoWrapperNode);
        }
    }

    private MappedClassInfoTreeWrapper createMappedClassInfoTreeWrapper(MappedClassInfo mappedClassInfo) {
        return new MappedClassInfoTreeWrapper(mappedClassInfo, this._panel.chkShowQualified.isSelected());
    }

    private void onConnectionClosed() {
        MappingRoot mr = (MappingRoot)this._root.getUserObject();
        mr.clear();
        this._root.removeAllChildren();
        this.nodeStructurChanged(this._root);
        this._detailPanelController.clearDetail();
    }

    private void initTree(HibernateConnection con) {
        ArrayList<MappedClassInfo> mappedClassInfos = con.getMappedClassInfos();
        ArrayList<MappedClassInfoTreeWrapper> wrappers = this.initMappedClassInfos(mappedClassInfos);
        for (MappedClassInfoTreeWrapper wrapper : wrappers) {
            this.addMappedClassInfoNode(wrapper, this._root);
        }
        this.nodeStructurChanged(this._root);
    }

    private void nodeStructurChanged(DefaultMutableTreeNode node) {
        ((DefaultTreeModel)this._panel.objectTree.getModel()).nodeStructureChanged(node);
    }

    private void addMappedClassInfoNode(MappedClassInfoTreeWrapper mappedClassInfoTreeWrapper, DefaultMutableTreeNode parent) {
        PropertyInfo[] propertyInfos;
        this._mappedClassInfoTreeWrappers.add(mappedClassInfoTreeWrapper);
        DefaultMutableTreeNode mappedClassInfoNode = new DefaultMutableTreeNode(mappedClassInfoTreeWrapper);
        for (PropertyInfo propertyInfo : propertyInfos = mappedClassInfoTreeWrapper.getMappedClassInfo().getAttributes()) {
            String className = propertyInfo.getHibernatePropertyInfo().getClassName();
            if (!this._mappedClassInfoByClassName.containsKey(className)) continue;
            PropertyInfoTreeWrapper propertyInfoTreeWrapper = new PropertyInfoTreeWrapper(propertyInfo, this._mappedClassInfoByClassName.get(className));
            DefaultMutableTreeNode propertyInfoNode = new DefaultMutableTreeNode(propertyInfoTreeWrapper);
            mappedClassInfoNode.add(propertyInfoNode);
        }
        parent.add(mappedClassInfoNode);
    }

    private ArrayList<MappedClassInfoTreeWrapper> initMappedClassInfos(ArrayList<MappedClassInfo> mappedClassInfos) {
        ArrayList<MappedClassInfoTreeWrapper> ret = new ArrayList<MappedClassInfoTreeWrapper>();
        this._mappedClassInfoByClassName = new HashMap();
        for (MappedClassInfo mappedClassInfo : mappedClassInfos) {
            this._mappedClassInfoByClassName.put(mappedClassInfo.getClassName(), mappedClassInfo);
            ret.add(this.createMappedClassInfoTreeWrapper(mappedClassInfo));
        }
        this._mappedClassInfoTreeWrappers = new ArrayList();
        Collections.sort(ret);
        return ret;
    }

    public JComponent getComponent() {
        return this._panel;
    }

    public void closing() {
        this._panel.closing();
        Preferences.userRoot().putBoolean(PERF_KEY_OBJ_TAB_CHKSHOWQUALIFIED, this._panel.chkShowQualified.isSelected());
    }
}

