/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.PersistentCollectionResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.RootType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class RootResultController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RootResultController.class);
    private ArrayList<MappedClassInfo> _mappedClassInfos;
    private JTree _resultTree;

    public RootResultController(RootType rootType, JPanel pnlResults, ArrayList<MappedClassInfo> mappedClassInfos) {
        RootType rootType1 = rootType;
        this._mappedClassInfos = mappedClassInfos;
        if (rootType1.getResultType() instanceof TupelType) {
            String msg = s_stringMgr.getString("RootResultController.MutibleTypesMessage", new Object[]{this.getClassNames((TupelType)rootType1.getResultType())});
            pnlResults.removeAll();
            pnlResults.add((Component)new MultipleLineLabel(msg));
            return;
        }
        this._resultTree = new JTree();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("DumyNode");
        DefaultTreeModel model = new DefaultTreeModel(root);
        this._resultTree.setModel(model);
        this._resultTree.setRootVisible(false);
        this.initRoot((SingleType)rootType1.getResultType(), root);
        this._resultTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                RootResultController.this.onTreeExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        pnlResults.removeAll();
        pnlResults.add(new JScrollPane(this._resultTree));
    }

    private void onTreeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (0 < kidNode.getChildCount()) continue;
            if (kidNode.getUserObject() instanceof PersistentCollectionResult) {
                ViewObjectsUtil.addPersistentCollectionKids(kidNode);
                continue;
            }
            if (!(kidNode.getUserObject() instanceof SingleResult)) continue;
            ViewObjectsUtil.addSingleResultKids(kidNode, (SingleResult)kidNode.getUserObject(), this._mappedClassInfos);
        }
        ViewObjectsUtil.nodeStructurChanged(node, this._resultTree);
    }

    private void initRoot(SingleType singleType, DefaultMutableTreeNode root) {
        for (SingleResult singleResult : singleType.getResults()) {
            DefaultMutableTreeNode singleResultNode = new DefaultMutableTreeNode(singleResult);
            root.add(singleResultNode);
            ViewObjectsUtil.addSingleResultKids(singleResultNode, singleResult, this._mappedClassInfos);
        }
        ViewObjectsUtil.nodeStructurChanged(root, this._resultTree);
    }

    private String getClassNames(TupelType tupelType) {
        String ret = "";
        for (IType iType : tupelType.getKidTypes()) {
            SingleType singleType = (SingleType)iType;
            ret = ret + singleType.getMappedClassInfo().getClassName() + "\n";
        }
        return ret;
    }
}

