/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IAllowedSchemaChecker;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.oracle.ObjectTypes;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleAliasPrefs;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleAliasPrefsPanelController;
import net.sourceforge.squirrel_sql.plugins.oracle.OraclePluginResources;
import net.sourceforge.squirrel_sql.plugins.oracle.SGAtrace.NewSGATraceWorksheetAction;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.NewDBOutputWorksheetAction;
import net.sourceforge.squirrel_sql.plugins.oracle.exception.OracleExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ConstraintParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.DefaultDatabaseExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.InstanceParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.OracleTableParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.PackageExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ProcedureExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.SchemaExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.SessionParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.TableExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.TriggerParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.UserParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.explainplan.ExplainPlanExecuter;
import net.sourceforge.squirrel_sql.plugins.oracle.invalidobjects.NewInvalidObjectsWorksheetAction;
import net.sourceforge.squirrel_sql.plugins.oracle.prefs.OraclePluginPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.oracle.prefs.OraclePreferenceBean;
import net.sourceforge.squirrel_sql.plugins.oracle.sessioninfo.NewSessionInfoWorksheetAction;
import net.sourceforge.squirrel_sql.plugins.oracle.sqlloader.control.GenerateControlFileAction;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.ConstraintColumnInfoTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.ConstraintDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.ConstraintSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.IndexColumnInfoTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.IndexSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.InstanceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.LobDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.ObjectSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.OptionsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.SessionDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.SessionStatisticsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.SnapshotSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.TriggerColumnInfoTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.UserDetailsTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.oracle.tokenizer.OracleQueryTokenizer;
import net.sourceforge.squirrel_sql.plugins.oracle.types.OracleXmlTypeDataTypeComponentFactory;

public class OraclePlugin
extends DefaultSessionPlugin
implements ISQLDatabaseMetaDataFactory {
    private static final ILogger s_log = LoggerController.createLogger(OraclePlugin.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OraclePlugin.class);
    private OraclePluginResources _resources;
    private final ArrayList<ISession> oracleSessions = new ArrayList();
    private static String SCHEMA_ACCESS_SQL = "SELECT owner FROM ALL_OBJECTS group by owner";
    private static String DBA_ROLE_SQL = "SELECT GRANTED_ROLE FROM USER_ROLE_PRIVS";
    private static final String ORACLE_ALIAS_PREFS_FILE = "oracleAliasPrefs.xml";
    private Hashtable<IIdentifier, OracleAliasPrefs> _oracleAliasPrefsByAliasIdentifier = new Hashtable();
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;
    public static final String BUNDLE_BASE_NAME = "net.sourceforge.squirrel_sql.plugins.oracle.oracle";
    private IObjectTypes _objectTypes;

    public SQLDatabaseMetaData fetchMeta(ISQLConnection conn) {
        return new SQLDatabaseMetaData(conn){

            public String getOptionalPseudoColumnForDataSelection(ITableInfo ti) {
                return "ROWID";
            }
        };
    }

    public String getInternalName() {
        return "oracle";
    }

    public String getDescriptiveName() {
        return "Oracle Plugin";
    }

    public String getVersion() {
        return "0.21";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public String getContributors() {
        return "Alexander Buloichik, Rob Manning";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        OraclePluginPreferencesPanel _prefsPanel = new OraclePluginPreferencesPanel(this._prefsManager);
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab((PluginQueryTokenizerPreferencesPanel)_prefsPanel);
        tab.setHint(i18n.hint);
        tab.setTitle(i18n.title);
        return new IGlobalPreferencesPanel[]{tab};
    }

    public void initialize() throws PluginException {
        try {
            super.initialize();
            IApplication app = this.getApplication();
            this._resources = new OraclePluginResources(BUNDLE_BASE_NAME, (IPlugin)this);
            this._objectTypes = new ObjectTypes(this._resources);
            ActionCollection coll = app.getActionCollection();
            coll.add((Action)((Object)new NewDBOutputWorksheetAction(app, (Resources)this._resources)));
            coll.add((Action)((Object)new NewInvalidObjectsWorksheetAction(app, (Resources)this._resources)));
            coll.add((Action)((Object)new NewSessionInfoWorksheetAction(app, (Resources)this._resources)));
            coll.add((Action)((Object)new NewSGATraceWorksheetAction(app, (Resources)this._resources)));
            app.getSessionManager().addAllowedSchemaChecker(new IAllowedSchemaChecker(){

                public String[] getAllowedSchemas(ISQLConnection con, ISQLAliasExt alias) {
                    return OraclePlugin.this.onGetAllowedSchemas(con, alias);
                }
            });
            File f = this.getGlobalPrefsFile();
            if (f.exists()) {
                XMLBeanReader xbr = new XMLBeanReader();
                xbr.load(f, ((Object)((Object)this)).getClass().getClassLoader());
                for (OracleAliasPrefs buf : xbr) {
                    this._oracleAliasPrefsByAliasIdentifier.put(buf.getAliasIdentifier(), buf);
                }
            } else {
                this._oracleAliasPrefsByAliasIdentifier = new Hashtable();
            }
            this._prefsManager = new PluginQueryTokenizerPreferencesManager();
            this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new OraclePreferenceBean());
            CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new OracleXmlTypeDataTypeComponentFactory());
            SQLDatabaseMetaDataFactory.registerOverride((DialectType)DialectType.ORACLE, (ISQLDatabaseMetaDataFactory)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void load(IApplication app) throws PluginException {
        super.load(app);
    }

    private File getGlobalPrefsFile() throws IOException {
        return new File(this.getPluginUserSettingsFolder().getPath() + File.separator + ORACLE_ALIAS_PREFS_FILE);
    }

    public void unload() {
        try {
            File f = this.getGlobalPrefsFile();
            XMLBeanWriter xbw = new XMLBeanWriter();
            Collection<OracleAliasPrefs> set = this._oracleAliasPrefsByAliasIdentifier.values();
            if (set.size() > 0) {
                xbw.addIteratorToRoot(set.iterator());
            }
            xbw.save(f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IAliasPropertiesPanelController[] getAliasPropertiesPanelControllers(SQLAlias alias) {
        if (!this.isOracle((ISQLAliasExt)alias)) {
            return new IAliasPropertiesPanelController[0];
        }
        OracleAliasPrefs aliasPrefs = this._oracleAliasPrefsByAliasIdentifier.get(alias.getIdentifier());
        if (null == aliasPrefs) {
            aliasPrefs = new OracleAliasPrefs();
            aliasPrefs.setAliasIdentifier(alias.getIdentifier());
            this._oracleAliasPrefsByAliasIdentifier.put(alias.getIdentifier(), aliasPrefs);
        }
        return new OracleAliasPrefsPanelController[]{new OracleAliasPrefsPanelController(aliasPrefs)};
    }

    public void aliasCopied(SQLAlias source, SQLAlias target) {
        if (!this.isOracle((ISQLAliasExt)source) || !this.isOracle((ISQLAliasExt)target)) {
            return;
        }
        OracleAliasPrefs sourcePrefs = this._oracleAliasPrefsByAliasIdentifier.get(source.getIdentifier());
        if (null != sourcePrefs) {
            OracleAliasPrefs targetPrefs = (OracleAliasPrefs)Utilities.cloneObject((Object)sourcePrefs, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            targetPrefs.setAliasIdentifier(target.getIdentifier());
            this._oracleAliasPrefsByAliasIdentifier.put(targetPrefs.getAliasIdentifier(), targetPrefs);
        }
    }

    public void aliasRemoved(SQLAlias alias) {
        this._oracleAliasPrefsByAliasIdentifier.remove(alias.getIdentifier());
    }

    public void sessionEnding(ISession session) {
        super.sessionEnding(session);
        this.oracleSessions.remove(session);
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isOracle(session)) {
            return null;
        }
        OraclePreferenceBean prefs = (OraclePreferenceBean)this._prefsManager.getPreferences();
        if (prefs.isInstallCustomQueryTokenizer()) {
            session.setQueryTokenizer((IQueryTokenizer)new OracleQueryTokenizer((IQueryTokenizerPreferenceBean)prefs));
        }
        if (prefs.isShowErrorOffset()) {
            OracleExceptionFormatter formatter = new OracleExceptionFormatter();
            formatter.setSession(session);
            session.setExceptionFormatter((ExceptionFormatter)formatter);
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OraclePlugin.this.addActions(session);
            }
        });
        this.oracleSessions.add(session);
        this.checkTimestampSetting(session);
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                OraclePlugin.this.onSQLInternaFrameOpened(sqlInternalFrame, sess);
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                OraclePlugin.this.onObjectTreeInternalFrameOpened(objectTreeInternalFrame);
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ISQLPanelAPI sqlPaneAPI = session.getSessionSheet().getSQLPaneAPI();
                sqlPaneAPI.addExecutor((ISQLResultExecuter)new ExplainPlanExecuter(session, sqlPaneAPI));
                OraclePlugin.this.updateObjectTree((IObjectTreeAPI)session.getSessionSheet().getObjectTreePanel());
            }
        });
        this.setTimezoneForSession(session, prefs);
        return ret;
    }

    private void setTimezoneForSession(ISession session, OraclePreferenceBean prefs) {
        if (!prefs.getInitSessionTimezone()) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"setTimezoneForSession: user preference for init session timezone is disabled.  Local Timezone data types may not be displayed correctly.");
            }
            return;
        }
        Connection con = session.getSQLConnection().getConnection();
        String timezoneStr = prefs.getSessionTimezone();
        try {
            Method setSessionTimeZoneMethod;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("setTimezoneForSession: attempting to set the session timezone to : " + timezoneStr));
            }
            if ((setSessionTimeZoneMethod = con.getClass().getMethod("setSessionTimeZone", String.class)) != null) {
                setSessionTimeZoneMethod.setAccessible(true);
                setSessionTimeZoneMethod.invoke((Object)con, timezoneStr);
            } else {
                s_log.error((Object)"setTimezoneForSession: setSessionTimeZoneMethod returned by reflection was null.  Skipped setting session timezone");
            }
        }
        catch (Exception e) {
            s_log.error((Object)("Unexpected exception while trying to set session timezone: " + e.getMessage()), (Throwable)e);
        }
    }

    private void checkTimestampSetting(ISession session) {
        int timeStampWhereClauseUsageInt;
        String tsClassName = DataTypeTimestamp.class.getName();
        String timeStampWhereClauseUsage = DTProperties.get((String)tsClassName, (String)"whereClauseUsage");
        if (timeStampWhereClauseUsage != null && 2 == (timeStampWhereClauseUsageInt = Integer.parseInt(timeStampWhereClauseUsage))) {
            session.showWarningMessage(i18n.timestampWarning);
            s_log.warn((Object)i18n.timestampWarning);
        }
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isOracle((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void addActions(ISession session) {
        ActionCollection coll = this.getApplication().getActionCollection();
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(NewDBOutputWorksheetAction.class));
        session.addToToolbar(coll.get(NewInvalidObjectsWorksheetAction.class));
        session.addToToolbar(coll.get(NewSessionInfoWorksheetAction.class));
        session.addToToolbar(coll.get(NewSGATraceWorksheetAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("oracleoutput", coll.get(NewDBOutputWorksheetAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("oracleinvalid", coll.get(NewInvalidObjectsWorksheetAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("oracleinfo", coll.get(NewSessionInfoWorksheetAction.class));
        session.getSessionInternalFrame().addToToolsPopUp("oraclesga", coll.get(NewSGATraceWorksheetAction.class));
    }

    private void onSQLInternaFrameOpened(SQLInternalFrame sqlInternalFrame, ISession session) {
        ISQLPanelAPI panel = sqlInternalFrame.getSQLPanelAPI();
        panel.addExecutor((ISQLResultExecuter)new ExplainPlanExecuter(session, panel));
    }

    private void onObjectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame) {
        IObjectTreeAPI objTree = objectTreeInternalFrame.getObjectTreeAPI();
        this.updateObjectTree(objTree);
    }

    public INodeExpander getDefaultNodeExpander(ISession session, DatabaseObjectType type) {
        boolean isOracle = this.isOracle(session.getAlias());
        boolean isOracleWithFlashBack = this.isOracleWithFlashBack(session);
        if (type == DatabaseObjectType.PROC_TYPE_DBO && isOracle) {
            return new ProcedureExpander();
        }
        if (type == DatabaseObjectType.DATABASE_TYPE_DBO && isOracle) {
            return new DefaultDatabaseExpander(session, this._objectTypes);
        }
        if (type == DatabaseObjectType.TABLE_TYPE_DBO && isOracleWithFlashBack) {
            OraclePreferenceBean prefs = (OraclePreferenceBean)this._prefsManager.getPreferences();
            return new OracleTableParentExpander(prefs);
        }
        return null;
    }

    private boolean isOracleWithFlashBack(ISession session) {
        boolean result = false;
        if (DialectFactory.isOracle((ISQLDatabaseMetaData)session.getMetaData())) {
            try {
                int version = session.getMetaData().getDatabaseMajorVersion();
                if (version >= 10) {
                    result = true;
                }
            }
            catch (SQLException e) {
                s_log.error((Object)"Unexpected exception while attempting to get the database version", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isOracle(ISession session) {
        boolean result = false;
        if (DialectFactory.isOracle((ISQLDatabaseMetaData)session.getMetaData())) {
            result = true;
        }
        return result;
    }

    private boolean isOracle(ISQLAliasExt alias) {
        IIdentifier driverIdentifier = alias.getDriverIdentifier();
        Driver jdbcDriver = this.getApplication().getSQLDriverManager().getJDBCDriver(driverIdentifier);
        if (null == jdbcDriver) {
            return false;
        }
        return jdbcDriver.getClass().getName().startsWith("oracle.");
    }

    private String[] onGetAllowedSchemas(ISQLConnection con, ISQLAliasExt alias) {
        if (this.isOracle(alias)) {
            OracleAliasPrefs prefs = this._oracleAliasPrefsByAliasIdentifier.get(alias.getIdentifier());
            if (null == prefs) {
                prefs = new OracleAliasPrefs();
                prefs.setAliasIdentifier(alias.getIdentifier());
                this._oracleAliasPrefsByAliasIdentifier.put(prefs.getAliasIdentifier(), prefs);
            }
            return this.getAccessibleSchemas(prefs, con);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAccessibleSchemas(OracleAliasPrefs aliasPrefs, ISQLConnection con) {
        String[] result = null;
        ResultSet rs = null;
        Statement stmt = null;
        SQLDatabaseMetaData md = con.getSQLMetaData();
        String currentUserName = null;
        try {
            if (this.hasSystemPrivilege(con) || aliasPrefs.isLoadAllSchemas()) {
                result = md.getSchemas();
            } else {
                currentUserName = md.getUserName();
                stmt = con.getConnection().createStatement();
                rs = stmt.executeQuery(SCHEMA_ACCESS_SQL);
                ArrayList<String> tmp = new ArrayList<String>();
                while (rs.next()) {
                    tmp.add(rs.getString(1));
                }
                if (currentUserName != null && !tmp.contains(currentUserName)) {
                    tmp.add(currentUserName);
                }
                tmp.remove("SYS");
                if (aliasPrefs.isLoadAccessibleSchemasAndSYS()) {
                    tmp.add("SYS");
                }
                result = tmp.toArray(new String[tmp.size()]);
            }
        }
        catch (SQLException e) {
            String msg = s_stringMgr.getString("DefaultDatabaseExpander.error.retrieveschemaprivs");
            s_log.error((Object)msg, (Throwable)e);
        }
        finally {
            SQLUtilities.closeResultSet(rs, (boolean)true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSystemPrivilege(ISQLConnection con) {
        boolean result = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(DBA_ROLE_SQL);
            while (rs.next()) {
                String role = rs.getString(1);
                if (!"DBA".equalsIgnoreCase(role)) continue;
                result = true;
                break;
            }
        }
        catch (SQLException e) {
            try {
                String msg = s_stringMgr.getString("DefaultDatabaseExpander.error.retrieveuserroles");
                s_log.error((Object)msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs, (boolean)true);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkObjectAccessible(ISession session, String query) {
        boolean bl;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = session.getSQLConnection().prepareStatement(query);
            rs = pstmt.executeQuery();
            bl = true;
        }
        catch (SQLException ex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs, (boolean)true);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
            return bl2;
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return bl;
    }

    private void updateObjectTree(final IObjectTreeAPI objTree) {
        ISession session = objTree.getSession();
        this.addDetailTab(objTree, DatabaseObjectType.SESSION, (IObjectTab)new OptionsTab());
        this.addDetailTab(objTree, this._objectTypes.getConsumerGroup(), (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.FUNCTION, (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.INDEX, (IObjectTab)new IndexColumnInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        this.addDetailTab(objTree, DatabaseObjectType.INDEX, (IObjectTab)new IndexSourceTab());
        this.addDetailTab(objTree, this._objectTypes.getLob(), (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, this._objectTypes.getLob(), (IObjectTab)new LobDetailsTab());
        this.addDetailTab(objTree, DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, this._objectTypes.getTriggerParent(), (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, this._objectTypes.getType(), (IObjectTab)new DatabaseObjectInfoTab());
        this.addDetailTab(objTree, this._objectTypes.getConstraint(), (IObjectTab)new DatabaseObjectInfoTab());
        this.addExpander(objTree, DatabaseObjectType.SCHEMA, new SchemaExpander(this._objectTypes));
        this.addExpander(objTree, DatabaseObjectType.TABLE, new TableExpander(this._objectTypes));
        this.addExpander(objTree, this._objectTypes.getPackage(), new PackageExpander());
        this.addExpander(objTree, this._objectTypes.getUserParent(), new UserParentExpander(session));
        this.addExpander(objTree, this._objectTypes.getSessionParent(), new SessionParentExpander(this._objectTypes));
        this.addExpander(objTree, this._objectTypes.getInstanceParent(), new InstanceParentExpander(this._objectTypes));
        this.addExpander(objTree, this._objectTypes.getTriggerParent(), new TriggerParentExpander());
        this.addExpander(objTree, this._objectTypes.getConstraintParent(), new ConstraintParentExpander(this._objectTypes));
        this.addDetailTab(objTree, DatabaseObjectType.PROCEDURE, (IObjectTab)new ObjectSourceTab("PROCEDURE", "Show stored procedure source"));
        this.addDetailTab(objTree, DatabaseObjectType.FUNCTION, (IObjectTab)new ObjectSourceTab("FUNCTION", "Show function source"));
        this.addDetailTab(objTree, this._objectTypes.getPackage(), (IObjectTab)new ObjectSourceTab("PACKAGE", "Specification", "Show package specification"));
        this.addDetailTab(objTree, this._objectTypes.getPackage(), (IObjectTab)new ObjectSourceTab("PACKAGE BODY", "Body", "Show package body"));
        this.addDetailTab(objTree, this._objectTypes.getType(), (IObjectTab)new ObjectSourceTab("TYPE", "Specification", "Show type specification"));
        this.addDetailTab(objTree, this._objectTypes.getType(), (IObjectTab)new ObjectSourceTab("TYPE BODY", "Body", "Show type body"));
        this.addDetailTab(objTree, this._objectTypes.getInstance(), (IObjectTab)new InstanceDetailsTab());
        this.addDetailTab(objTree, DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab());
        this.addDetailTab(objTree, this._objectTypes.getSession(), (IObjectTab)new SessionDetailsTab());
        this.addDetailTab(objTree, this._objectTypes.getSession(), (IObjectTab)new SessionStatisticsTab());
        this.addDetailTab(objTree, DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this.addDetailTab(objTree, DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab());
        this.addDetailTab(objTree, DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerColumnInfoTab());
        this.addDetailTab(objTree, DatabaseObjectType.USER, (IObjectTab)new UserDetailsTab(session));
        this.addDetailTab(objTree, this._objectTypes.getConstraint(), (IObjectTab)new ConstraintDetailsTab());
        this.addDetailTab(objTree, this._objectTypes.getConstraint(), (IObjectTab)new ConstraintColumnInfoTab());
        this.addDetailTab(objTree, this._objectTypes.getConstraint(), (IObjectTab)new ConstraintSourceTab());
        this.addDetailTab(objTree, DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab());
        this.addDetailTab(objTree, DatabaseObjectType.TABLE, (IObjectTab)new SnapshotSourceTab());
        session.getSessionInternalFrame().getObjectTreeAPI().addToPopup(DatabaseObjectType.TABLE, (Action)((Object)new GenerateControlFileAction(this.getApplication(), (Resources)this._resources, session)));
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                objTree.refreshTree();
            }
        });
    }

    private void addExpander(IObjectTreeAPI objTree, DatabaseObjectType dboType, INodeExpander exp) {
        objTree.addExpander(dboType, exp);
    }

    private void addDetailTab(IObjectTreeAPI objTree, DatabaseObjectType dboType, IObjectTab tab) {
        objTree.addDetailTab(dboType, tab);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String title = OraclePlugin.access$000().getString("OraclePlugin.title");
        public static final String hint = OraclePlugin.access$000().getString("OraclePlugin.hint");
        public static final String timestampWarning = OraclePlugin.access$000().getString("OraclePlugin.timestampWarning");
    }
}

