/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.constraint;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.AbstractConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintColumnInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintInfo;

public class CKConstraintSource
extends AbstractConstraintSource {
    private AbstractConstraintSource cs;

    public CKConstraintSource(ISession session, ConstraintInfo ci) {
        super(session, ci);
    }

    public CKConstraintSource(ISession session, ConstraintInfo ci, AbstractConstraintSource cs) {
        super(session, ci);
        this.cs = cs;
    }

    @Override
    public void readConstraintColumnNames() throws SQLException {
        super.readConstraintColumnNames();
        this.cs = "GENERATED NAME".equals(this.ci.getGenerated()) && this.isNotNullConstraint() ? new NotNullCKConstraintSource(this.session, this.ci) : new AbstractConstraintSource(this.session, this.ci){

            @Override
            public void buildConstraintClause() {
                this.constraintClause = "CONSTRAINT " + this.ci.getConstraintName() + "\n  CHECK ( " + this.ci.getSearchCondition() + " )";
            }
        };
    }

    @Override
    public void buildDropStatement() {
        this.cs.buildDropStatement();
    }

    @Override
    public void buildAddStatement() {
        this.cs.buildAddStatement();
    }

    @Override
    public void buildConstraintClause() throws Exception {
        this.cs.buildConstraintClause();
    }

    @Override
    public String getSource() {
        return this.cs.getSource();
    }

    private boolean isNotNullConstraint() {
        String expectedSearchCondition = "\"" + ((ConstraintColumnInfo)this.columns.get(0)).getColumnName() + "\" IS NOT NULL";
        return expectedSearchCondition.equals(this.ci.getSearchCondition());
    }

    private class NotNullCKConstraintSource
    extends AbstractConstraintSource {
        public NotNullCKConstraintSource(ISession session, ConstraintInfo ci) {
            super(session, ci);
        }

        @Override
        public void buildDropStatement() {
            this.dropStmt = "ALTER TABLE " + this.ci.getOwner() + "." + this.ci.getTableName() + "\n  MODIFY " + ((ConstraintColumnInfo)CKConstraintSource.this.columns.get(0)).getColumnName() + " NULL";
        }

        @Override
        public void buildAddStatement() {
            this.addStmt = "ALTER TABLE " + this.ci.getOwner() + "." + this.ci.getTableName() + "\n  MODIFY " + ((ConstraintColumnInfo)CKConstraintSource.this.columns.get(0)).getColumnName() + " NOT NULL";
        }

        @Override
        public void buildConstraintClause() {
        }

        @Override
        public String getSource() {
            return this.dropStmt + ";\n\n" + this.addStmt + ";";
        }
    }
}

