/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlreplace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.ReplacementManager;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.SQLReplaceExecutionListener;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.SQLReplacePreferencesController;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.SQLReplaceResources;

public class SQLReplacePlugin
extends DefaultSessionPlugin {
    Map<String, String> cache;
    HashMap<ISQLPanelAPI, ISQLExecutionListener> panelListenerMap = new HashMap();
    private static final ILogger log = LoggerController.createLogger(SQLReplacePlugin.class);
    public static final String RESOURCE_PATH = "net.sourceforge.squirrel_sql.plugins.sqlreplace.sqlreplace";
    private static ILogger logger = LoggerController.createLogger(SQLReplacePlugin.class);
    private FileWrapper pluginAppFolder;
    private PluginResources resources;
    private ReplacementManager replacementManager;

    public String getAuthor() {
        return "Dieter Engelhardt";
    }

    public String getDescriptiveName() {
        return "SQLReplace Plugin";
    }

    public String getInternalName() {
        return "sqlreplace";
    }

    public String getVersion() {
        return "0.0.2";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        block4: {
            super.initialize();
            try {
                this.pluginAppFolder = this.getPluginAppSettingsFolder();
            }
            catch (IOException ex) {
                throw new PluginException((Exception)ex);
            }
            this.resources = new SQLReplaceResources(RESOURCE_PATH, (IPlugin)this);
            this.replacementManager = new ReplacementManager(this);
            try {
                this.replacementManager.load();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block4;
                logger.error((Object)"Problem loading replacementManager", (Throwable)e);
            }
        }
    }

    ReplacementManager getReplacementManager() {
        return this.replacementManager;
    }

    protected String getResourceString(String name) {
        return this.resources.getString(name);
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new SQLReplacePreferencesController(this)};
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        try {
            ISQLPanelAPI sqlPaneAPI = session.getSessionSheet().getSQLPaneAPI();
            this.initSQLReplace(sqlPaneAPI, session);
            PluginSessionCallback ret = new PluginSessionCallback(){

                public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                    SQLReplacePlugin.this.initSQLReplace(sqlInternalFrame.getSQLPanelAPI(), sess);
                }

                public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                }
            };
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unload() {
        for (ISQLPanelAPI api : this.panelListenerMap.keySet()) {
            api.removeSQLExecutionListener(this.panelListenerMap.get(api));
        }
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public void sessionCreated(ISession session) {
        try {
            this.replacementManager.load();
        }
        catch (Exception e) {
            String sessionName = null;
            if (session != null && session.getAlias() != null) {
                sessionName = session.getAlias().getName();
            }
            log.error((Object)("Unexpected exeption while loading replacementManager for " + sessionName + " : " + e.getMessage()), (Throwable)e);
        }
    }

    private void initSQLReplace(final ISQLPanelAPI sqlPaneAPI, final ISession session) {
        final SQLReplacePlugin plugin = this;
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Adding SQL execution listener.");
                }
                SQLReplaceExecutionListener listener = new SQLReplaceExecutionListener(plugin, session);
                sqlPaneAPI.addSQLExecutionListener((ISQLExecutionListener)listener);
                SQLReplacePlugin.this.panelListenerMap.put(sqlPaneAPI, (ISQLExecutionListener)listener);
            }
        });
    }

    public void sessionEnding(ISession session) {
        ISQLPanelAPI sqlPaneAPI = session.getSessionSheet().getSQLPaneAPI();
        ISQLExecutionListener listener = this.panelListenerMap.remove(sqlPaneAPI);
        sqlPaneAPI.removeSQLExecutionListener(listener);
    }
}

