/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.ResultSetExportCommand;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortFactoryCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.AbstractDataScriptCommand;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ProgressAbortFactoryCallbackImpl;
import org.apache.commons.lang.time.StopWatch;

public class CreateFileOfCurrentSQLCommand
extends AbstractDataScriptCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateFileOfCurrentSQLCommand.class);
    private static ILogger s_log = LoggerController.createLogger(CreateFileOfCurrentSQLCommand.class);
    private ResultSetExportCommand resultSetExportCommand;
    private Statement stmt = null;
    private ProgressAbortFactoryCallbackImpl _progressAbortCallback;
    private String currentSQL = null;

    public CreateFileOfCurrentSQLCommand(ISession session, SQLScriptPlugin plugin) {
        super(session, plugin);
    }

    public void execute(final JFrame owner) {
        this.currentSQL = this.getSelectedSelectStatement();
        this.getSession().getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                CreateFileOfCurrentSQLCommand.this.doCreateFileOfCurrentSQL(owner);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCreateFileOfCurrentSQL(JFrame owner) {
        block14: {
            StopWatch stopWatch;
            ISQLConnection unmanagedConnection;
            block12: {
                block13: {
                    unmanagedConnection = null;
                    unmanagedConnection = this.createUnmanagedConnection();
                    this.stmt = unmanagedConnection != null ? this.createStatementForStreamingResults(unmanagedConnection.getConnection()) : this.createStatementForStreamingResults(this.getSession().getSQLConnection().getConnection());
                    this._progressAbortCallback = new ProgressAbortFactoryCallbackImpl(this.getSession(), this.currentSQL, () -> this.resultSetExportCommand.getTargetFile(), this.stmt);
                    stopWatch = new StopWatch();
                    stopWatch.start();
                    DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this.getSession().getMetaData());
                    this.resultSetExportCommand = new ResultSetExportCommand(this.stmt, this.currentSQL, dialectType, (ProgressAbortFactoryCallback)this._progressAbortCallback);
                    this.resultSetExportCommand.execute(owner);
                    stopWatch.stop();
                    if (!this._progressAbortCallback.isAborted()) break block12;
                    SQLUtilities.closeStatement((Statement)this.stmt);
                    if (unmanagedConnection == null) break block13;
                    unmanagedConnection.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null != CreateFileOfCurrentSQLCommand.this._progressAbortCallback) {
                            CreateFileOfCurrentSQLCommand.this._progressAbortCallback.hideProgressMonitor();
                        }
                    }
                });
                return;
            }
            try {
                if (this.resultSetExportCommand.getWrittenRows() >= 0L) {
                    NumberFormat nf = NumberFormat.getIntegerInstance();
                    String rows = nf.format(this.resultSetExportCommand.getWrittenRows());
                    File targetFile = this.resultSetExportCommand.getTargetFile();
                    String seconds = nf.format(stopWatch.getTime() / 1000L);
                    String msg = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.sucessMessage", new Object[]{rows, targetFile, seconds});
                    this.getSession().showMessage(msg);
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    SQLUtilities.closeStatement((Statement)this.stmt);
                    if (unmanagedConnection != null) {
                        unmanagedConnection.close();
                    }
                }
            }
            catch (Exception e) {
                try {
                    s_log.error((Object)e);
                    if (e.getCause() != null) {
                        this.getSession().showErrorMessage(e.getCause());
                    }
                    this.getSession().showErrorMessage(e.toString());
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private Statement createStatementForStreamingResults(Connection connection) throws SQLException {
        Statement stmt;
        DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this.getSession().getMetaData());
        if (DialectType.MYSQL5 == dialectType) {
            stmt = connection.createStatement(1003, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
        } else {
            stmt = connection.createStatement();
        }
        return stmt;
    }

    private ISQLConnection createUnmanagedConnection() throws SQLException {
        SQLConnection unmanagedConnection = this.getSession().createUnmanagedConnection();
        if (unmanagedConnection == null) {
            int option = JOptionPane.showConfirmDialog(null, "Unable to open a new connection. The current connection will be used instead.", "Unable to open a new Connection", 2);
            if (option == 2) {
                return null;
            }
        } else {
            unmanagedConnection.setAutoCommit(false);
        }
        return unmanagedConnection;
    }
}

