/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.Component;
import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.DefaultSQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.CreateDataScriptCommand;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.CreateTableOfCurrentSQLCtrl;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ScriptUtil;

public class CreateTableOfCurrentSQLCommand
extends CreateDataScriptCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateTableOfCurrentSQLCommand.class);
    private final SQLScriptPlugin _plugin;

    public CreateTableOfCurrentSQLCommand(ISession session, SQLScriptPlugin plugin) {
        super(session, plugin, true);
        this._plugin = plugin;
    }

    @Override
    public void execute() {
        Frame owningFrame = SessionUtils.getOwningFrame((ISQLPanelAPI)FrameWorkAcessor.getSQLPanelAPI(this._session, this._plugin));
        CreateTableOfCurrentSQLCtrl ctrl = new CreateTableOfCurrentSQLCtrl(owningFrame);
        if (!ctrl.isOK()) {
            return;
        }
        final String sTable = ctrl.getTableName();
        final boolean scriptOnly = ctrl.isScriptOnly();
        final boolean dropTable = ctrl.isDropTable();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CreateTableOfCurrentSQLCommand.this.doCreateTableOfCurrentSQL(sTable, scriptOnly, dropTable);
            }
        });
        this.showAbortFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCreateTableOfCurrentSQL(String sTable, boolean scriptOnly, boolean dropTable) {
        StringBuffer sbScript;
        block14: {
            ResultSet srcResult;
            String sql;
            String statSep;
            StringBuffer sbDrop;
            StringBuffer sbInsert;
            StringBuffer sbCreate;
            Statement stmt;
            block13: {
                IQueryTokenizer qt;
                block12: {
                    sbScript = new StringBuffer();
                    ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(this._session, this._plugin);
                    String script = api.getSQLScriptToBeExecuted();
                    qt = this._session.getQueryTokenizer();
                    qt.setScriptToTokenize(script);
                    if (qt.hasQuery()) break block12;
                    this._session.showErrorMessage(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.noQuery"));
                    SwingUtilities.invokeLater(new Runnable(scriptOnly, sbScript){
                        final /* synthetic */ boolean val$scriptOnly;
                        final /* synthetic */ StringBuffer val$sbScript;
                        {
                            this.val$scriptOnly = bl;
                            this.val$sbScript = stringBuffer;
                        }

                        @Override
                        public void run() {
                            CreateTableOfCurrentSQLCommand.this.hideAbortFrame();
                            if (this.val$scriptOnly && 0 < this.val$sbScript.toString().trim().length()) {
                                FrameWorkAcessor.getSQLPanelAPI(CreateTableOfCurrentSQLCommand.this._session, CreateTableOfCurrentSQLCommand.this._plugin).appendSQLScript(this.val$sbScript.toString(), true);
                                CreateTableOfCurrentSQLCommand.this._session.selectMainTab(1);
                            }
                        }
                    });
                    return;
                }
                ISQLConnection conn = this._session.getSQLConnection();
                stmt = null;
                sbCreate = new StringBuffer();
                sbInsert = new StringBuffer();
                sbDrop = new StringBuffer();
                statSep = ScriptUtil.getStatementSeparator(this._session);
                stmt = conn.createStatement();
                stmt.setMaxRows(1);
                sql = qt.nextQuery().getQuery();
                srcResult = stmt.executeQuery(sql);
                if (!this.isAborted()) break block13;
                SQLUtilities.closeStatement((Statement)stmt);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            try {
                this.genCreate(srcResult, sTable, sbCreate);
                this.genInserts(srcResult, sTable, sbInsert, true);
                sbInsert.append('\n').append(sql);
                sbDrop.append("DROP TABLE " + sTable);
                if (dropTable && this._session.getSchemaInfo().isTable(sTable)) {
                    sbScript.append(sbDrop).append(statSep);
                }
                sbScript.append(sbCreate).append(statSep);
                sbScript.append(sbInsert).append(statSep);
                {
                    catch (Throwable throwable) {
                        SQLUtilities.closeStatement(stmt);
                        throw throwable;
                    }
                }
                SQLUtilities.closeStatement((Statement)stmt);
                if (scriptOnly) break block14;
                try {
                    SQLExecuterTask executer = new SQLExecuterTask(this._session, sbScript.toString(), (ISQLExecuterHandler)new DefaultSQLExecuterHandler(this._session));
                    executer.run();
                    this._session.showMessage(s_stringMgr.getString("sqlscript.successCreate", new Object[]{sTable}));
                }
                catch (Exception e) {
                    this._session.showErrorMessage((Throwable)e);
                    String msg = s_stringMgr.getString("sqlscript.storeSqlInTableFailed", new Object[]{sTable});
                    JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), msg);
                }
            }
            catch (Exception e) {
                try {
                    this._session.showErrorMessage((Throwable)e);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void genCreate(ResultSet srcResult, String sTable, StringBuffer sbCreate) {
        try {
            ResultSetMetaData metaData = srcResult.getMetaData();
            sbCreate.append("\n\nCREATE TABLE ").append(sTable).append('\n');
            sbCreate.append("(\n");
            ScriptUtil su = new ScriptUtil();
            String sColName = metaData.getColumnName(1);
            String sColType = metaData.getColumnTypeName(1);
            int colSize = metaData.getColumnDisplaySize(1);
            int decimalDigits = metaData.getScale(1);
            sbCreate.append("   ").append(su.getColumnDef(sColName, sColType, colSize, decimalDigits));
            for (int i = 2; i <= metaData.getColumnCount(); ++i) {
                sbCreate.append(",\n");
                sColName = metaData.getColumnName(i);
                sColType = metaData.getColumnTypeName(i);
                colSize = metaData.getColumnDisplaySize(i);
                decimalDigits = metaData.getScale(i);
                sbCreate.append("   ").append(su.getColumnDef(sColName, sColType, colSize, decimalDigits));
            }
            sbCreate.append("\n)");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

