/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPrefChangeNotSupportedException;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.prefspanel.StyleMaintenancePanel;
import net.sourceforge.squirrel_sql.plugins.syntax.prefspanel.StylesList;

public class SyntaxPreferencesPanel
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SyntaxPreferencesPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(SyntaxPreferencesPanel.class);
    private final SyntaxPreferences _prefs;
    private final MyPanel _myPanel;

    public SyntaxPreferencesPanel(SyntaxPreferences prefs, SyntaxPluginResources rsrc) {
        if (prefs == null) {
            throw new IllegalArgumentException("Null SyntaxPreferences passed");
        }
        this._prefs = prefs;
        this._myPanel = new MyPanel(prefs, rsrc);
    }

    public void initialize(IApplication app) {
        this._myPanel.loadData(this._prefs);
    }

    public void initialize(IApplication app, ISession session) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._myPanel.loadData(this._prefs);
    }

    public Component getPanelComponent() {
        return this._myPanel;
    }

    public void applyChanges() {
        this._myPanel.applyChanges(this._prefs);
    }

    public String getTitle() {
        return s_stringMgr.getString("syntax.prefSyntax");
    }

    public String getHint() {
        return s_stringMgr.getString("syntax.prefSyntaxHint");
    }

    private static final class MyPanel
    extends JPanel {
        private final JRadioButton _rsyntaxActiveOpt = new JRadioButton(SyntaxPreferencesPanel.access$000().getString("syntax.prefUseRsyntax"));
        private final JRadioButton _plainActiveOpt = new JRadioButton(SyntaxPreferencesPanel.access$000().getString("syntax.prefUsePlain"));
        private final JCheckBox _chkTextLimitLineVisible = new JCheckBox(SyntaxPreferencesPanel.access$000().getString("syntax.textLimitLineVisible"));
        private final JTextField _txtTextLimitLineWidth = new JTextField();
        private final JCheckBox _chkHighlightCurrentLine = new JCheckBox(SyntaxPreferencesPanel.access$000().getString("syntax.highlightCurrentLine"));
        private final JCheckBox _chkLineNumbersEnabled = new JCheckBox(SyntaxPreferencesPanel.access$000().getString("syntax.lineNumbersEnabled"));
        private final JCheckBox _useCopyAsRtf = new JCheckBox(SyntaxPreferencesPanel.access$000().getString("syntax.useCopyAsRtf"));
        private final JTextField _txtTabLength = new JTextField();
        private final JCheckBox _chkReplaceTabsBySpaces = new JCheckBox(SyntaxPreferencesPanel.access$000().getString("syntax.replaceTabsBySpaces"));
        private StylesListSelectionListener _listLis;
        private final StylesList _stylesList = new StylesList();
        private StyleMaintenancePanel _styleMaintPnl;

        MyPanel(SyntaxPreferences prefs, SyntaxPluginResources rsrc) {
            this.createUserInterface(prefs, rsrc);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this._listLis == null) {
                this._listLis = new StylesListSelectionListener();
                this._stylesList.addListSelectionListener(this._listLis);
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this._listLis != null) {
                this._stylesList.removeListSelectionListener(this._listLis);
                this._listLis = null;
            }
        }

        void loadData(SyntaxPreferences prefs) {
            this._rsyntaxActiveOpt.setSelected(prefs.getUseRSyntaxTextArea());
            this._plainActiveOpt.setSelected(prefs.getUsePlainTextControl());
            this._chkTextLimitLineVisible.setSelected(prefs.isTextLimitLineVisible());
            this._chkHighlightCurrentLine.setSelected(prefs.isHighlightCurrentLine());
            this._chkLineNumbersEnabled.setSelected(prefs.isLineNumbersEnabled());
            this._txtTextLimitLineWidth.setText("" + prefs.getTextLimitLineWidth());
            this._useCopyAsRtf.setSelected(prefs.isUseCopyAsRtf());
            this._stylesList.loadData(prefs);
            this._styleMaintPnl.setStyle(this._stylesList.getSelectedSyntaxStyle());
            this._txtTabLength.setText("" + prefs.getTabLength());
            this._chkReplaceTabsBySpaces.setSelected(prefs.isReplaceTabsBySpaces());
            this.updateControlStatus();
        }

        void applyChanges(SyntaxPreferences prefs) {
            boolean oldUseRSyntaxTextArea = prefs.getUseRSyntaxTextArea();
            boolean oldUsePlainTextControl = prefs.getUsePlainTextControl();
            try {
                prefs.setUseRSyntaxTextArea(this._rsyntaxActiveOpt.isSelected());
                prefs.setUsePlainTextControl(this._plainActiveOpt.isSelected());
            }
            catch (SyntaxPrefChangeNotSupportedException e) {
                prefs.setUseRSyntaxTextArea(oldUseRSyntaxTextArea);
                prefs.setUsePlainTextControl(oldUsePlainTextControl);
            }
            prefs.setTextLimitLineVisible(this._chkTextLimitLineVisible.isSelected());
            prefs.setHighlightCurrentLine(this._chkHighlightCurrentLine.isSelected());
            prefs.setLineNumbersEnabled(this._chkLineNumbersEnabled.isSelected());
            prefs.setUseCopyAsRtf(this._useCopyAsRtf.isSelected());
            this.fillTextLineLimit(prefs);
            this.fillTabLength(prefs);
            prefs.setReplaceTabsBySpaces(this._chkReplaceTabsBySpaces.isSelected());
            prefs.setColumnStyle(this._stylesList.getSyntaxStyleAt(0));
            prefs.setCommentStyle(this._stylesList.getSyntaxStyleAt(1));
            prefs.setErrorStyle(this._stylesList.getSyntaxStyleAt(3));
            prefs.setFunctionStyle(this._stylesList.getSyntaxStyleAt(4));
            prefs.setIdentifierStyle(this._stylesList.getSyntaxStyleAt(5));
            prefs.setLiteralStyle(this._stylesList.getSyntaxStyleAt(6));
            prefs.setOperatorStyle(this._stylesList.getSyntaxStyleAt(7));
            prefs.setReservedWordStyle(this._stylesList.getSyntaxStyleAt(8));
            prefs.setSeparatorStyle(this._stylesList.getSyntaxStyleAt(9));
            prefs.setTableStyle(this._stylesList.getSyntaxStyleAt(10));
            prefs.setWhiteSpaceStyle(this._stylesList.getSyntaxStyleAt(11));
            prefs.setDataTypeStyle(this._stylesList.getSyntaxStyleAt(2));
        }

        private void fillTabLength(SyntaxPreferences prefs) {
            int limit = prefs.getTabLength();
            try {
                int buf = Integer.parseInt(this._txtTabLength.getText());
                if (0 < buf && buf < 1000) {
                    limit = buf;
                } else {
                    s_log.error((Object)("Invalid text limit widht: " + this._txtTabLength.getText()));
                }
            }
            catch (NumberFormatException e) {
                s_log.error((Object)("Invalid text limit widht: " + this._txtTabLength.getText()), (Throwable)e);
            }
            prefs.setTabLength(limit);
        }

        private void fillTextLineLimit(SyntaxPreferences prefs) {
            int limit = prefs.getTextLimitLineWidth();
            try {
                int buf = Integer.parseInt(this._txtTextLimitLineWidth.getText());
                if (0 < buf && buf < 1000) {
                    limit = buf;
                } else {
                    s_log.error((Object)("Invalid text limit widht: " + this._txtTextLimitLineWidth.getText()));
                }
            }
            catch (NumberFormatException e) {
                s_log.error((Object)("Invalid text limit widht: " + this._txtTextLimitLineWidth.getText()), (Throwable)e);
            }
            prefs.setTextLimitLineWidth(limit);
        }

        private void updateControlStatus() {
            boolean useRSyntaxControl = this._rsyntaxActiveOpt.isSelected();
            boolean usePlainControl = this._plainActiveOpt.isSelected();
            this._stylesList.setEnabled(useRSyntaxControl);
            this._styleMaintPnl.setEnabled(useRSyntaxControl);
            this._chkTextLimitLineVisible.setEnabled(useRSyntaxControl);
            this._txtTextLimitLineWidth.setEnabled(useRSyntaxControl);
            if (useRSyntaxControl) {
                this._txtTextLimitLineWidth.setEnabled(this._chkTextLimitLineVisible.isSelected());
            }
            this._chkHighlightCurrentLine.setEnabled(useRSyntaxControl);
            this._chkLineNumbersEnabled.setEnabled(useRSyntaxControl);
            this._useCopyAsRtf.setEnabled(useRSyntaxControl);
        }

        private void createUserInterface(SyntaxPreferences prefs, SyntaxPluginResources rsrc) {
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._rsyntaxActiveOpt);
            bg.add(this._plainActiveOpt);
            this._rsyntaxActiveOpt.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    this.updateControlStatus();
                }
            });
            this._plainActiveOpt.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    this.updateControlStatus();
                }
            });
            this._chkTextLimitLineVisible.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateControlStatus();
                }
            });
            this._chkHighlightCurrentLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateControlStatus();
                }
            });
            this._chkLineNumbersEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateControlStatus();
                }
            });
            String text = s_stringMgr.getString("syntax.osterExplain");
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
            this.add((Component)new MultipleLineLabel(text), gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0);
            this.add((Component)this.createOptionsPanel(), gbc);
            gbc = new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
            this.add((Component)this.createStylePanel(rsrc), gbc);
            gbc = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new JPanel(), gbc);
        }

        private JPanel createOptionsPanel() {
            JPanel pnlRet = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this._rsyntaxActiveOpt, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this._plainActiveOpt, gbc);
            gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(40, 5, 0, 5), 0, 0);
            pnlRet.add((Component)this.createPnlLineLimit(), gbc);
            gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this._chkHighlightCurrentLine, gbc);
            gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this._chkLineNumbersEnabled, gbc);
            gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this._useCopyAsRtf, gbc);
            gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            pnlRet.add((Component)this.createTabConfigPanel(), gbc);
            return pnlRet;
        }

        private JPanel createTabConfigPanel() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            ret.add((Component)new JLabel(s_stringMgr.getString("syntax.tabLength")), gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            this._txtTabLength.setColumns(3);
            ret.add((Component)this._txtTabLength, gbc);
            gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
            ret.add((Component)this._chkReplaceTabsBySpaces, gbc);
            return ret;
        }

        private JPanel createPnlLineLimit() {
            JPanel pnlLineLimit = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
            pnlLineLimit.add((Component)this._chkTextLimitLineVisible, gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0);
            pnlLineLimit.add((Component)new JLabel(s_stringMgr.getString("syntax.textLimitLineWidth")), gbc);
            this._txtTextLimitLineWidth.setColumns(3);
            gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0);
            pnlLineLimit.add((Component)this._txtTextLimitLineWidth, gbc);
            return pnlLineLimit;
        }

        private JPanel createStylePanel(SyntaxPluginResources rsrc) {
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("syntax.styles")));
            this._styleMaintPnl = new StyleMaintenancePanel(this._stylesList, rsrc);
            pnl.add((Component)this._styleMaintPnl, "North");
            pnl.add((Component)this._stylesList, "Center");
            return pnl;
        }

        private class StylesListSelectionListener
        implements ListSelectionListener {
            private StylesListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MyPanel.this._styleMaintPnl.setStyle(((StylesList)evt.getSource()).getSelectedSyntaxStyle());
            }
        }
    }
}

