/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionKeys;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.AboutAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CascadeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllButCurrentSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DisplayPluginSummaryAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DumpApplicationAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExitAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.GlobalPreferencesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.InstallDefaultDriversAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.MaximizeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewSessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SavePreferencesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowLoadedDriversOnlyAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileHorizontalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileVerticalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewHelpAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewLogsAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToLeftAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToRightAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultWindowsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionWindowAction;
import net.sourceforge.squirrel_sql.client.session.action.CommitAction;
import net.sourceforge.squirrel_sql.client.session.action.ConvertToStringBufferAction;
import net.sourceforge.squirrel_sql.client.session.action.CopyQualifiedObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySimpleObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySqlAction;
import net.sourceforge.squirrel_sql.client.session.action.CutSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.DeleteSelectedTablesAction;
import net.sourceforge.squirrel_sql.client.session.action.DumpSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.EditWhereColsAction;
import net.sourceforge.squirrel_sql.client.session.action.EscapeDateAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteAllSqlsAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.FileDetachAction;
import net.sourceforge.squirrel_sql.client.session.action.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenRecentAction;
import net.sourceforge.squirrel_sql.client.session.action.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.FileReloadAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.action.FilterObjectsAction;
import net.sourceforge.squirrel_sql.client.session.action.FormatSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoNextResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoPreviousResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.IMainPanelTabAction;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.action.InQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.NewAliasConnectionAction;
import net.sourceforge.squirrel_sql.client.session.action.NewObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.NewSQLWorksheetAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.OpenSqlHistoryAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAltAcceleratorAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.ReconnectAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshObjectTreeItemAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveNewLinesAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.RenameSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.RerunCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.RollbackAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.session.action.SetDefaultCatalogAction;
import net.sourceforge.squirrel_sql.client.session.action.ShowNativeSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.ShowTableReferencesAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleAutoCommitAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleMinimizeResultsAction;
import net.sourceforge.squirrel_sql.client.session.action.ToolsPopupAction;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ActionCollection {
    private static ILogger s_log;
    private final IApplication _app;
    private final Map<String, Action> _actionColl = new HashMap<String, Action>();
    private static final StringManager s_stringMgr;

    public ActionCollection(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (s_log == null) {
            s_log = LoggerController.createLogger(this.getClass());
        }
        this._app = app;
        this.preloadActions();
        this.enableInternalFrameOptions(false);
    }

    public void add(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        this._actionColl.put(action.getClass().getName(), action);
    }

    public synchronized Action get(Class<? extends Action> actionClass) {
        if (actionClass == null) {
            throw new IllegalArgumentException("null Action Class passed.");
        }
        return this.get(actionClass.getName());
    }

    public synchronized Action get(String actionClassName) {
        if (actionClassName == null) {
            throw new IllegalArgumentException("null Action Class Name passed.");
        }
        Action action = this._actionColl.get(actionClassName);
        if (action == null) {
            String errMsg = s_stringMgr.getString("ActionCollection.actionNotFound", actionClassName);
            s_log.error(errMsg);
            action = this.createAction(actionClassName);
        }
        return action;
    }

    public void enableAction(Class actionClass, boolean enable) throws IllegalArgumentException {
        if (actionClass == null) {
            throw new IllegalArgumentException("null Action Class passed.");
        }
        Action action = this.get(actionClass);
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    public void internalFrameOpenedOrClosed(int nbrInternalFramesOpen) {
        this.enableInternalFrameOptions(nbrInternalFramesOpen > 0);
    }

    public void deactivationChanged(IWidget frame) {
        boolean isSQLFrame = frame instanceof SQLInternalFrame;
        boolean isTreeFrame = frame instanceof ObjectTreeInternalFrame;
        boolean isSessionInternalFrame = frame instanceof SessionInternalFrame;
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            Action act = it.next();
            if (act instanceof ISessionAction) {
                ((ISessionAction)((Object)act)).setSession(null);
            }
            if (isSQLFrame && act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(null);
            }
            if (isTreeFrame && act instanceof IObjectTreeAction) {
                ((IObjectTreeAction)((Object)act)).setObjectTree(null);
            }
            if (isSessionInternalFrame && act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(null);
            }
            if (!isSessionInternalFrame || !(act instanceof IObjectTreeAction)) continue;
            ((IObjectTreeAction)((Object)act)).setObjectTree(null);
        }
    }

    public synchronized void activationChanged(IWidget frame) {
        boolean isSQLFrame = frame instanceof SQLInternalFrame;
        boolean isTreeFrame = frame instanceof ObjectTreeInternalFrame;
        boolean isSessionInternalFrame = frame instanceof SessionInternalFrame;
        ISession session = null;
        if (frame instanceof ISessionWidget) {
            session = ((ISessionWidget)frame).getSession();
        }
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            SessionInternalFrame sif;
            Action act = it.next();
            if (act instanceof ISessionAction) {
                ((ISessionAction)((Object)act)).setSession(session);
            }
            if (isSQLFrame && act instanceof ISQLPanelAction) {
                ((ISQLPanelAction)((Object)act)).setSQLPanel(((SQLInternalFrame)frame).getSQLPanel().getSQLPanelAPI());
            }
            if (isTreeFrame && act instanceof IObjectTreeAction) {
                ((IObjectTreeAction)((Object)act)).setObjectTree(((ObjectTreeInternalFrame)frame).getObjectTreePanel());
            }
            if (isSessionInternalFrame && act instanceof IMainPanelTabAction) {
                ((IMainPanelTabAction)((Object)act)).setSelectedMainPanelTab(session.getSelectedMainTab());
            }
            if (isSessionInternalFrame && act instanceof ISQLPanelAction) {
                sif = (SessionInternalFrame)frame;
                if (sif.getSessionPanel().isSQLTabSelected()) {
                    ((ISQLPanelAction)((Object)act)).setSQLPanel(sif.getSessionPanel().getSQLPaneAPI());
                } else {
                    ((ISQLPanelAction)((Object)act)).setSQLPanel(null);
                }
            }
            if (!isSessionInternalFrame || !(act instanceof IObjectTreeAction)) continue;
            sif = (SessionInternalFrame)frame;
            if (sif.getSessionPanel().isObjectTreeTabSelected()) {
                ((IObjectTreeAction)((Object)act)).setObjectTree(((SessionInternalFrame)frame).getSessionPanel().getObjectTreePanel());
                continue;
            }
            ((IObjectTreeAction)((Object)act)).setObjectTree(null);
        }
    }

    public synchronized void loadActionKeys(ActionKeys[] actionKeys) {
        if (actionKeys == null) {
            throw new IllegalArgumentException("null ActionKeys[] passed");
        }
        for (int i = 0; i < actionKeys.length; ++i) {
            int mnemonic;
            ActionKeys ak = actionKeys[i];
            Action action = this.get(ak.getActionClassName());
            if (action == null) continue;
            String accel = ak.getAccelerator();
            if (accel != null && accel.length() > 0) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
            }
            if ((mnemonic = ak.getMnemonic()) == 0) continue;
            action.putValue("MnemonicKey", mnemonic);
        }
    }

    public Iterator<Action> actions() {
        return this._actionColl.values().iterator();
    }

    public synchronized void setCurrentSession(ISession session) {
        Iterator<Action> it = this.actions();
        while (it.hasNext()) {
            Action act = it.next();
            if (!(act instanceof ISessionAction)) continue;
            ((ISessionAction)((Object)act)).setSession(session);
        }
    }

    private Action createAction(String actionClassName) {
        Action action = null;
        try {
            String msg = s_stringMgr.getString("ActionCollection.createActionInfo", actionClassName);
            s_log.info(msg);
            action = (Action)Class.forName(actionClassName).newInstance();
            this._actionColl.put(actionClassName, action);
        }
        catch (Exception ex) {
            String msg = s_stringMgr.getString("ActionCollection.createActionError", actionClassName);
            s_log.error(msg, ex);
        }
        return action;
    }

    private void enableInternalFrameOptions(boolean enable) {
        this.enableAction(CascadeAction.class, enable);
        this.enableAction(MaximizeAction.class, enable);
        this.enableAction(TileAction.class, enable);
        this.enableAction(TileHorizontalAction.class, enable);
        this.enableAction(TileVerticalAction.class, enable);
        this.enableAction(CloseAllSessionsAction.class, enable);
        this.enableAction(CloseAllButCurrentSessionsAction.class, enable);
    }

    private void preloadActions() {
        this.add(new AboutAction(this._app));
        this.add(new CascadeAction(this._app));
        this.add(new ToolsPopupAction(this._app));
        this.add(new CloseAllSessionsAction(this._app));
        this.add(new CloseAllButCurrentSessionsAction(this._app));
        this.add(new CloseAllSQLResultTabsAction(this._app));
        this.add(new CloseAllSQLResultTabsButCurrentAction(this._app));
        this.add(new CloseAllSQLResultTabsToLeftAction(this._app));
        this.add(new CloseAllSQLResultTabsToRightAction(this._app));
        this.add(new CloseCurrentSQLResultTabAction(this._app));
        this.add(new ToggleCurrentSQLResultTabStickyAction(this._app));
        this.add(new CloseAllSQLResultWindowsAction(this._app));
        this.add(new ToggleMinimizeResultsAction(this._app));
        this.add(new ViewObjectAtCursorInObjectTreeAction(this._app));
        this.add(new CloseSessionAction(this._app));
        this.add(new CloseSessionWindowAction(this._app));
        this.add(new CommitAction(this._app));
        this.add(new CopyQualifiedObjectNameAction(this._app));
        this.add(new CopySimpleObjectNameAction(this._app));
        this.add(new DisplayPluginSummaryAction(this._app));
        this.add(new DeleteSelectedTablesAction(this._app));
        this.add(new ShowTableReferencesAction(this._app));
        this.add(new DumpApplicationAction(this._app));
        this.add(new SavePreferencesAction(this._app));
        this.add(new DumpSessionAction(this._app));
        this.add(new ExecuteSqlAction(this._app));
        this.add(new ExecuteAllSqlsAction(this._app));
        this.add(new ExitAction(this._app));
        this.add(new FileNewAction(this._app));
        this.add(new FileDetachAction(this._app));
        this.add(new FileOpenAction(this._app));
        this.add(new FileOpenRecentAction(this._app));
        this.add(new FileAppendAction(this._app));
        this.add(new FileSaveAction(this._app));
        this.add(new FileSaveAsAction(this._app));
        this.add(new FileCloseAction(this._app));
        this.add(new FilePrintAction(this._app));
        this.add(new FileReloadAction(this._app));
        this.add(new GlobalPreferencesAction(this._app));
        this.add(new GotoNextResultsTabAction(this._app));
        this.add(new GotoPreviousResultsTabAction(this._app));
        this.add(new InstallDefaultDriversAction(this._app));
        this.add(new MaximizeAction(this._app));
        this.add(new NewObjectTreeAction(this._app));
        this.add(new NewSQLWorksheetAction(this._app));
        this.add(new NewAliasConnectionAction(this._app));
        this.add(new NewSessionPropertiesAction(this._app));
        this.add(new NextSessionAction(this._app));
        this.add(new PreviousSessionAction(this._app));
        this.add(new ReconnectAction(this._app));
        this.add(new RefreshSchemaInfoAction(this._app));
        this.add(new RefreshObjectTreeItemAction(this._app));
        this.add(new RollbackAction(this._app));
        this.add(new SessionPropertiesAction(this._app));
        this.add(new FilterObjectsAction(this._app));
        this.add(new SetDefaultCatalogAction(this._app));
        this.add(new ShowLoadedDriversOnlyAction(this._app));
        this.add(new ShowNativeSQLAction(this._app));
        this.add(new SQLFilterAction(this._app));
        this.add(new EditWhereColsAction(this._app));
        this.add(new TileAction(this._app));
        this.add(new TileHorizontalAction(this._app));
        this.add(new TileVerticalAction(this._app));
        this.add(new ToggleAutoCommitAction(this._app));
        this.add(new ViewHelpAction(this._app));
        this.add(new ViewLogsAction(this._app));
        this.add(new PreviousSqlAction(this._app));
        this.add(new NextSqlAction(this._app));
        this.add(new SelectSqlAction(this._app));
        this.add(new OpenSqlHistoryAction(this._app));
        this.add(new FormatSQLAction(this._app));
        this.add(new RenameSessionAction(this._app));
        this.add(new RerunCurrentSQLResultTabAction(this._app));
        this.add(new InQuotesAction(this._app));
        this.add(new RemoveQuotesAction(this._app));
        this.add(new ConvertToStringBufferAction(this._app));
        this.add(new EscapeDateAction(this._app));
        this.add(new CutSqlAction(this._app));
        this.add(new CopySqlAction(this._app));
        this.add(new RemoveNewLinesAction(this._app));
        this.add(new PasteFromHistoryAction(this._app));
        this.add(new PasteFromHistoryAltAcceleratorAction(this._app));
    }

    static {
        s_stringMgr = StringManagerFactory.getStringManager(ActionCollection.class);
    }
}

