/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.cli;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.cli.CliExceptionUtil;
import net.sourceforge.squirrel_sql.client.cli.CliSessionAdapter;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;

public class CliSession
extends CliSessionAdapter {
    private final SQLConnection _sqlConnection;
    private final QueryTokenizer _tokenizer;
    private final SessionProperties _sessionProperties;

    public CliSession(ISQLAlias aliasToConnectTo) {
        try {
            IIdentifier driverID = aliasToConnectTo.getDriverIdentifier();
            ISQLDriver sqlDriver = Main.getApplication().getDataCache().getDriver(driverID);
            SQLDriverManager sqlDriverManager = Main.getApplication().getSQLDriverManager();
            SQLDriverPropertyCollection props = aliasToConnectTo.getDriverPropertiesClone();
            if (!aliasToConnectTo.getUseDriverProperties()) {
                props.clear();
            }
            this._sqlConnection = sqlDriverManager.getConnection(sqlDriver, aliasToConnectTo, aliasToConnectTo.getUserName(), aliasToConnectTo.getPassword(), props);
            this._sessionProperties = Main.getApplication().getSquirrelPreferences().getSessionProperties();
            this._tokenizer = new QueryTokenizer(this._sessionProperties.getSQLStatementSeparator(), this._sessionProperties.getStartOfLineComment(), this._sessionProperties.getRemoveMultiLineComment());
        }
        catch (Exception e) {
            throw CliExceptionUtil.wrapRunntime(e);
        }
    }

    @Override
    public ISQLConnection getSQLConnection() {
        return this._sqlConnection;
    }

    @Override
    public ISQLDatabaseMetaData getMetaData() {
        return this._sqlConnection.getSQLMetaData();
    }

    @Override
    public IQueryTokenizer getQueryTokenizer() {
        return this._tokenizer;
    }

    @Override
    public SessionProperties getProperties() {
        return this._sessionProperties;
    }

    @Override
    public void close() throws SQLException {
        this._sqlConnection.getConnection().close();
    }
}

