/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliascolor;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;

public class AliasTreeColorer {
    private final Color _backgroundNonSelectionColor;
    private final Color _backgroundSelectionColor;

    public AliasTreeColorer(JTree tree) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        this._backgroundNonSelectionColor = defaultTreeCellRenderer.getBackgroundNonSelectionColor();
        this._backgroundSelectionColor = defaultTreeCellRenderer.getBackgroundSelectionColor();
    }

    public void colorAliasRendererComponent(DefaultTreeCellRenderer defaultTreeCellRenderer, DefaultMutableTreeNode node, JLabel cellRendererComp) {
        AliasFolder aliasFolder;
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(this._backgroundNonSelectionColor);
        defaultTreeCellRenderer.setBackgroundSelectionColor(this._backgroundSelectionColor);
        if (node.getUserObject() instanceof SQLAlias) {
            SQLAlias sqlAlias = (SQLAlias)node.getUserObject();
            if (sqlAlias.getColorProperties().isOverrideAliasBackgroundColor()) {
                this.colorRenderer(defaultTreeCellRenderer, sqlAlias.getColorProperties().getAliasBackgroundColorRgbValue());
            }
        } else if (node.getUserObject() instanceof AliasFolder && -1 != (aliasFolder = (AliasFolder)node.getUserObject()).getColorRGB()) {
            this.colorRenderer(defaultTreeCellRenderer, aliasFolder.getColorRGB());
        }
    }

    private void colorRenderer(DefaultTreeCellRenderer defaultTreeCellRenderer, int aliasBackgroundColorRgbValue) {
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(new Color(aliasBackgroundColorRgbValue));
        defaultTreeCellRenderer.setBackgroundSelectionColor(new Color(aliasBackgroundColorRgbValue).darker());
    }
}

