/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.sql.SQLException;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.ICompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommandListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectToAliasCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectToAliasCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectToAliasCommand.class);
    private IApplication _app;
    private SQLAlias _sqlAlias;
    private boolean _createSession;
    private ICompletionCallback _callback;

    public ConnectToAliasCommand(IApplication app, SQLAlias sqlAlias) {
        this(app, sqlAlias, true, null);
    }

    public ConnectToAliasCommand(IApplication app, SQLAlias sqlAlias, boolean createSession, ICompletionCallback callback) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null ISQLAlias passed");
        }
        this._app = app;
        this._sqlAlias = sqlAlias;
        this._createSession = createSession;
        this._callback = callback != null ? callback : new ConnectToAliasCallBack(app, this._sqlAlias);
    }

    @Override
    public void execute() {
        try {
            final SheetHandler hdl = new SheetHandler(this._app, this._sqlAlias, this._createSession, this._callback);
            if (SwingUtilities.isEventDispatchThread()) {
                this.createConnectionInternalFrame(hdl);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectToAliasCommand.this.createConnectionInternalFrame(hdl);
                    }
                });
            }
        }
        catch (Exception ex) {
            this._app.showErrorDialog(ex);
        }
    }

    private void createConnectionInternalFrame(SheetHandler hdl) {
        ConnectionInternalFrame sheet = new ConnectionInternalFrame(this._app, this._sqlAlias, hdl);
        this._app.getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        sheet.moveToFront();
    }

    private static final class Runner
    implements Runnable {
        private final ISession _session;
        private final ConnectionInternalFrame _connSheet;
        private ICompletionCallback _callback;

        Runner(ISession session, ConnectionInternalFrame connSheet, ICompletionCallback callback) {
            this._session = session;
            this._connSheet = connSheet;
            this._callback = callback;
        }

        @Override
        public void run() {
            IApplication app = this._session.getApplication();
            try {
                app.getPluginManager().sessionCreated(this._session);
                SessionInternalFrame sessionInternalFrame = app.getWindowManager().createInternalFrame(this._session);
                this._callback.sessionInternalFrameCreated(sessionInternalFrame);
                this._connSheet.executed(true);
            }
            catch (Throwable th) {
                app.showErrorDialog(s_stringMgr.getString("ConnectToAliasCommand.error.opensession"), th);
            }
        }
    }

    private static class SheetHandler
    implements ConnectionInternalFrame.IHandler {
        private ConnectionInternalFrame _connSheet;
        private IApplication _app;
        private SQLAlias _alias;
        private boolean _createSession;
        private String _user;
        private String _password;
        private SQLDriverPropertyCollection _props;
        private boolean _stopConnection;
        private ICompletionCallback _callback;

        private SheetHandler(IApplication app, SQLAlias alias, boolean createSession, ICompletionCallback callback) {
            if (app == null) {
                throw new IllegalArgumentException("IApplication == null");
            }
            if (alias == null) {
                throw new IllegalArgumentException("ISQLAlias == null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("ICompletionCallback == null");
            }
            this._app = app;
            this._alias = alias;
            this._createSession = createSession;
            this._callback = callback;
        }

        @Override
        public void performOK(ConnectionInternalFrame connSheet, String user, String password, SQLDriverPropertyCollection props) {
            this._stopConnection = false;
            this._connSheet = connSheet;
            this._user = user;
            this._password = password;
            this._props = props;
            this.doConnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performCancelConnect(ConnectionInternalFrame connSheet) {
            SheetHandler sheetHandler = this;
            synchronized (sheetHandler) {
                this._stopConnection = true;
            }
        }

        @Override
        public void performClose(ConnectionInternalFrame connSheet) {
        }

        public void doConnect() {
            IIdentifier driverID = this._alias.getDriverIdentifier();
            final ISQLDriver sqlDriver = this._app.getDataCache().getDriver(driverID);
            try {
                final OpenConnectionCommand cmd = new OpenConnectionCommand(this._app, this._alias, this._user, this._password, this._props);
                cmd.execute(new OpenConnectionCommandListener(){

                    @Override
                    public void openConnectionFinished(Throwable t) {
                        this.afterExecuteFinished(sqlDriver, cmd, t);
                    }
                });
            }
            catch (Throwable ex) {
                this._connSheet.executed(false);
                this._callback.errorOccured(ex, this._stopConnection);
            }
        }

        private void afterExecuteFinished(ISQLDriver sqlDriver, OpenConnectionCommand cmd, Throwable t) {
            try {
                if (null != t) {
                    throw t;
                }
                if (this._alias.isAutoLogon()) {
                    this._alias.setUserName(this._user);
                    this._alias.setPassword(this._password);
                }
                SQLConnection conn = cmd.getSQLConnection();
                if (this._stopConnection) {
                    if (conn != null) {
                        this.closeConnection(conn);
                        conn = null;
                    }
                } else {
                    this._callback.connected(conn);
                    if (this._createSession) {
                        this.createSession(sqlDriver, conn);
                    } else {
                        this._connSheet.executed(true);
                    }
                }
            }
            catch (Throwable th) {
                this._connSheet.executed(false);
                this._callback.errorOccured(th, this._stopConnection);
            }
        }

        private void closeConnection(ISQLConnection conn) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    s_log.error(s_stringMgr.getString("ConnectToAliasCommand.error.closeconnection"), ex);
                }
            }
        }

        private ISession createSession(ISQLDriver sqlDriver, SQLConnection conn) {
            SessionManager sm = this._app.getSessionManager();
            ISession session = sm.createSession(this._app, sqlDriver, this._alias, conn, this._user, this._password);
            this._callback.sessionCreated(session);
            SwingUtilities.invokeLater(new Runner(session, this._connSheet, this._callback));
            return session;
        }
    }
}

