/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action.findaliases;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.FindAliasListCellRenderer;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.FindAliasesDialog;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindAliasesCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindAliasesCtrl.class);
    public static final String PREF_KEY_FIND_ALIAS_SHEET_WIDTH = "Squirrel.findAliasSheet.width";
    public static final String PREF_KEY_FIND_ALIAS_SHEET_HEIGHT = "Squirrel.findAliasSheet.height";
    public static final String PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN = "Squirrel.findAliasSheet.check.leave.open";
    public static final String PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH = "Squirrel.findAliasSheet.remember.last.search";
    public static final String PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING = "Squirrel.findAliasSheet.last.search.string";
    private FindAliasesDialog _dlg = new FindAliasesDialog();

    public FindAliasesCtrl(IAliasesList al) {
        this._dlg.setSize(this.getDimension());
        GUIUtils.centerWithinParent(this._dlg);
        GUIUtils.enableCloseByEscape(this._dlg, dialog -> this.onClosing());
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindAliasesCtrl.this.onClosing();
            }
        });
        this._dlg.lstResult.setCellRenderer(new FindAliasListCellRenderer());
        this._dlg.lstResult.setFocusable(false);
        this._dlg.lstResult.setSelectionMode(0);
        this._dlg.lstResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindAliasesCtrl.this.onListClicked(e);
            }
        });
        this._dlg.chkLeaveOpen.setFocusable(false);
        this._dlg.chkLeaveOpen.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, false));
        this._dlg.btnConnect.addActionListener(e -> this.onConnect());
        this._dlg.btnGoto.addActionListener(e -> this.onGoto(al));
        this._dlg.btnClose.addActionListener(e -> this.onClose());
        this._dlg.txtToSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindAliasesCtrl.this.updateList();
            }
        });
        this._dlg.chkRememberLastSearch.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH, false));
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            this._dlg.txtToSearch.setText(Preferences.userRoot().get(PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING, null));
        }
        this._dlg.txtToSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FindAliasesCtrl.this.onKeyPressed(e);
            }
        });
        SwingUtilities.invokeLater(() -> this._dlg.txtToSearch.requestFocus());
        this._dlg.getRootPane().setDefaultButton(this._dlg.btnConnect);
        this.updateList();
        this._dlg.setVisible(true);
    }

    private void onClose() {
        this.onClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            int selIx = this._dlg.lstResult.getSelectedIndex();
            if (0 < selIx) {
                this._dlg.lstResult.setSelectedIndex(selIx - 1);
                this._dlg.lstResult.ensureIndexIsVisible(selIx - 1);
            }
        } else if (e.getKeyCode() == 40) {
            int selIx = this._dlg.lstResult.getSelectedIndex();
            if (this._dlg.lstResult.getModel().getSize() - 1 > selIx) {
                this._dlg.lstResult.setSelectedIndex(selIx + 1);
                this._dlg.lstResult.ensureIndexIsVisible(selIx + 1);
            }
        }
    }

    private void onConnect() {
        ISQLAlias selectedAlias = (ISQLAlias)this._dlg.lstResult.getSelectedValue();
        if (null == selectedAlias) {
            return;
        }
        ConnectToAliasCallBack completionCallback = null;
        if (this._dlg.chkLeaveOpen.isSelected()) {
            completionCallback = new ConnectToAliasCallBack(Main.getApplication(), (SQLAlias)selectedAlias){

                @Override
                public void sessionCreated(ISession session) {
                    FindAliasesCtrl.this._dlg.requestFocus();
                    ((FindAliasesCtrl)FindAliasesCtrl.this)._dlg.txtToSearch.requestFocus();
                    super.sessionCreated(session);
                }
            };
        }
        new ConnectToAliasCommand(Main.getApplication(), (SQLAlias)selectedAlias, true, completionCallback).execute();
        if (!this._dlg.chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        }
    }

    private void onGoto(IAliasesList al) {
        ISQLAlias selectedAlias = (ISQLAlias)this._dlg.lstResult.getSelectedValue();
        if (null == selectedAlias) {
            return;
        }
        IApplication app = Main.getApplication();
        AliasesListInternalFrame aliasesFrame = Main.getApplication().getWindowManager().getAliasesListInternalFrame();
        new ViewAliasesAction(app, aliasesFrame).actionPerformed(new ActionEvent(this._dlg, 1, "Dummy"));
        al.goToAlias(selectedAlias);
        if (!this._dlg.chkLeaveOpen.isSelected()) {
            this.onClosing();
            this._dlg.setVisible(false);
            this._dlg.dispose();
        } else {
            this._dlg.txtToSearch.requestFocus();
        }
    }

    private void updateList() {
        String filterText = this._dlg.txtToSearch.getText();
        Object formerSelectedValue = this._dlg.lstResult.getSelectedValue();
        Vector<ISQLAlias> allAliases = new Vector<ISQLAlias>(Main.getApplication().getDataCache().getAliasList());
        Vector<ISQLAlias> matchingAliases = new Vector<ISQLAlias>();
        for (ISQLAlias alias : allAliases) {
            if (!this.matches(alias, filterText)) continue;
            matchingAliases.add(alias);
        }
        Collections.sort(matchingAliases, new Comparator<ISQLAlias>(){

            @Override
            public int compare(ISQLAlias o1, ISQLAlias o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this._dlg.lstResult.setListData(matchingAliases);
        this._dlg.lstResult.setSelectedValue(formerSelectedValue, true);
        if (-1 == this._dlg.lstResult.getSelectedIndex()) {
            this._dlg.lstResult.setSelectedIndex(0);
            this._dlg.lstResult.ensureIndexIsVisible(0);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.onConnect();
        }
    }

    private boolean matches(ISQLAlias alias, String filterText) {
        if (StringUtilities.isEmpty(filterText, true)) {
            return true;
        }
        return null != alias.getName() && -1 < alias.getName().toLowerCase().indexOf(filterText.toLowerCase()) || null != alias.getUrl() && -1 < alias.getUrl().toLowerCase().indexOf(filterText.toLowerCase()) || null != alias.getUserName() && -1 < alias.getUserName().toLowerCase().indexOf(filterText.toLowerCase());
    }

    private void onClosing() {
        Preferences.userRoot().putInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, this._dlg.getWidth());
        Preferences.userRoot().putInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, this._dlg.getHeight());
        Preferences.userRoot().putBoolean(PREF_KEY_FIND_ALIAS_CHECK_LEAVE_OPEN, this._dlg.chkLeaveOpen.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_FIND_ALIAS_REMEMBER_LAST_SEARCH, this._dlg.chkRememberLastSearch.isSelected());
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            Preferences.userRoot().put(PREF_KEY_FIND_ALIAS_LAST_SEARCH_STRING, this._dlg.txtToSearch.getText());
        }
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_FIND_ALIAS_SHEET_WIDTH, 600), Preferences.userRoot().getInt(PREF_KEY_FIND_ALIAS_SHEET_HEIGHT, 400));
    }
}

