/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.RerunCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CurrentSqlLabelController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.QueryInfoPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ReadMoreResultsHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultLabelNameSwitcher;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanelFacade;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SelectRowColLabelController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabToggleButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn.FindColumnCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.AdditionalResultTabsController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.CloseAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.CreateResultTabFrameAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.FindColumnAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.FindInResultAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.MarkDuplicatesToggleAction;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MarkDuplicatesHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ReadMoreResultsHandlerListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetViewerFindDecorator;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultTab
extends JPanel
implements IHasIdentifier,
IResultTab {
    private IIdentifier _id;
    private ISession _session;
    private SQLExecutionInfo _exInfo;
    private DataSetViewerFindDecorator _dataSetViewerFindDecorator;
    private IDataSetViewer _metaDataOutput;
    private JScrollPane _metaDataSp = new JScrollPane();
    private JTabbedPane _tabResultTabs;
    private SQLResultExecuterPanelFacade _sqlResultExecuterPanelFacade;
    private CurrentSqlLabelController _currentSqlLblCtrl = new CurrentSqlLabelController();
    private String _sql;
    private QueryInfoPanel _queryInfoPanel = new QueryInfoPanel();
    private PropertyChangeListener _propsListener;
    private boolean _allowEditing;
    private IDataSetUpdateableTableModel _creator;
    private ResultSetDataSet _rsds;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultTab.class);
    private static ILogger s_log = LoggerController.createLogger(ResultTab.class);
    private ResultTabListener _resultTabListener;
    private ReadMoreResultsHandler _readMoreResultsHandler;
    private boolean _tabIsClosing;
    private SelectRowColLabelController _selectRowColLabelController = new SelectRowColLabelController();
    private ResultLabelNameSwitcher _resultLabelNameSwitcher;
    private AdditionalResultTabsController _additionalResultTabsController;
    private TabToggleButton _btnToggleMarkDuplicates;

    public ResultTab(ISession session, SQLResultExecuterPanelFacade sqlResultExecuterPanelFacade, IIdentifier id, SQLExecutionInfo exInfo, IDataSetUpdateableTableModel creator, ResultTabListener resultTabListener) throws IllegalArgumentException {
        this._resultTabListener = resultTabListener;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        if (sqlResultExecuterPanelFacade == null) {
            throw new IllegalArgumentException("Null SQLPanel passed");
        }
        if (id == null) {
            throw new IllegalArgumentException("Null IIdentifier passed");
        }
        this._session = session;
        this._sqlResultExecuterPanelFacade = sqlResultExecuterPanelFacade;
        this._id = id;
        this._exInfo = exInfo;
        this.init(creator);
        this._readMoreResultsHandler = new ReadMoreResultsHandler(this._session);
        this.createGUI();
        this.propertiesHaveChanged(null);
    }

    private void init(IDataSetUpdateableTableModel creator) {
        this._creator = creator;
        this._creator.addListener(new DataSetUpdateableTableModelListener(){

            @Override
            public void forceEditMode(boolean mode) {
                ResultTab.this.onForceEditMode(mode);
            }
        });
        this._allowEditing = new EditableSqlCheck(this._exInfo).allowsEditing();
        SessionProperties props = this._session.getProperties();
        if (this._allowEditing) {
            IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.getInstance(props.getSQLResultsOutputClassName(), this._creator, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._dataSetViewerFindDecorator = new DataSetViewerFindDecorator(dataSetViewer, this._session.getApplication().getMessageHandler(), this._session);
            this._selectRowColLabelController.setDataSetViewer(dataSetViewer);
        } else {
            IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.getInstance(props.getReadOnlySQLResultsOutputClassName(), null, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._dataSetViewerFindDecorator = new DataSetViewerFindDecorator(dataSetViewer, this._session.getApplication().getMessageHandler(), this._session);
            this._selectRowColLabelController.setDataSetViewer(dataSetViewer);
        }
        if (this._session.getProperties().getShowResultsMetaData()) {
            this._metaDataOutput = BaseDataSetViewerDestination.getInstance(props.getMetaDataOutputClassName(), null, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._metaDataSp.setViewportView(this._metaDataOutput.getComponent());
            this._metaDataSp.setRowHeader(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._propsListener == null) {
            this._propsListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ResultTab.this.propertiesHaveChanged(evt);
                }
            };
            this._session.getProperties().addPropertyChangeListener(this._propsListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
    }

    @Override
    public void showResults(ResultSetDataSet rsds, ResultSetMetaDataDataSet mdds) throws DataSetException {
        this._sql = StringUtilities.cleanString(this._exInfo.getQueryHolder().getOriginalQuery());
        this._rsds = rsds;
        this._dataSetViewerFindDecorator.getDataSetViewer().show(this._rsds, null);
        this.initContinueReadChannel(this._dataSetViewerFindDecorator);
        int rowCount = this._rsds.currentRowCount();
        this._currentSqlLblCtrl.setSql(this._sql);
        this._currentSqlLblCtrl.reInit(this._rsds.currentRowCount(), this._rsds.areAllPossibleResultsOfSQLRead());
        this._additionalResultTabsController.setCurrentResult(this._rsds);
        this._resultLabelNameSwitcher.setCurrentResult(this._rsds, this._dataSetViewerFindDecorator.getDataSetViewer());
        if (mdds != null && this._metaDataOutput != null) {
            this._metaDataOutput.show(mdds, null);
        }
        this._queryInfoPanel.load(rowCount, this._exInfo);
    }

    private void initContinueReadChannel(DataSetViewerFindDecorator resultSetOutput) {
        final ReadMoreResultsHandlerListener readMoreResultsHandlerListener = new ReadMoreResultsHandlerListener(){

            @Override
            public void moreResultsHaveBeenRead() {
                ResultTab.this.onMoreResultsHaveBeenRead();
            }
        };
        resultSetOutput.getDataSetViewer().setContinueReadChannel(new ContinueReadChannel(){

            @Override
            public void readMoreResults() {
                ResultTab.this.onReadMoreResults(readMoreResultsHandlerListener);
            }

            @Override
            public void closeStatementAndResultSet() {
                ResultTab.this.onCloseStatementAndResultSet();
            }
        });
    }

    private void onCloseStatementAndResultSet() {
        this._rsds.closeStatementAndResultSet();
    }

    private void onReadMoreResults(ReadMoreResultsHandlerListener readMoreResultsHandlerListener) {
        if (this._rsds.isAllResultsRead()) {
            return;
        }
        this._readMoreResultsHandler.readMoreResults(this._rsds, readMoreResultsHandlerListener);
    }

    private void onMoreResultsHaveBeenRead() {
        try {
            TableState resultSortableTableState = this.getTableState(this._dataSetViewerFindDecorator.getDataSetViewer());
            this._dataSetViewerFindDecorator.getDataSetViewer().show(this._rsds, null);
            this.restoreTableState(resultSortableTableState, this._dataSetViewerFindDecorator.getDataSetViewer());
            this._dataSetViewerFindDecorator.resetFind();
            this._currentSqlLblCtrl.reInit(this._rsds.currentRowCount(), this._rsds.areAllPossibleResultsOfSQLRead());
            this._queryInfoPanel.displayRowCount(this._rsds.currentRowCount());
            this._additionalResultTabsController.moreResultsHaveBeenRead();
            this._resultLabelNameSwitcher.moreResultsHaveBeenRead(this._rsds);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        this.closeTab();
    }

    @Override
    public String getSqlString() {
        return this._exInfo != null ? this._exInfo.getSQL() : null;
    }

    @Override
    public String getViewableSqlString() {
        return StringUtilities.cleanString(this.getSqlString());
    }

    @Override
    public String getTitle() {
        String title = this._sql;
        if (title.length() < 20) {
            return title;
        }
        return title.substring(0, 15);
    }

    @Override
    public void closeTab() {
        if (this._tabIsClosing) {
            return;
        }
        try {
            this._tabIsClosing = true;
            if (this._metaDataOutput != null) {
                this._metaDataOutput.clear();
            }
            if (this._dataSetViewerFindDecorator != null) {
                this._dataSetViewerFindDecorator.getDataSetViewer().clear();
            }
            this._exInfo = null;
            this._currentSqlLblCtrl.clear();
            this._sql = "";
            this._sqlResultExecuterPanelFacade.closeResultTab(this);
            this._rsds.closeStatementAndResultSet();
        }
        finally {
            this._tabIsClosing = false;
        }
    }

    @Override
    public void returnToTabbedPane() {
        this.add((Component)this._tabResultTabs, "Center");
        this._sqlResultExecuterPanelFacade.returnToTabbedPane(this);
    }

    @Override
    public Component getOutputComponent() {
        return this._tabResultTabs;
    }

    @Override
    public void reRunSQL() {
        this._resultTabListener.rerunSQL(this._exInfo.getSQL(), this);
    }

    private void propertiesHaveChanged(PropertyChangeEvent evt) {
        SessionProperties props = this._session.getProperties();
        if (evt == null || evt.getPropertyName().equals("sqlResultsTabPlacement")) {
            this._tabResultTabs.setTabPlacement(props.getSQLResultsTabPlacement());
        }
    }

    private void onForceEditMode(boolean editable) {
        try {
            if (editable) {
                if (this._allowEditing) {
                    TableState resultSortableTableState = this.getTableState(this._dataSetViewerFindDecorator.getDataSetViewer());
                    IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.getInstance(SessionProperties.IDataSetDestinations.EDITABLE_TABLE, this._creator, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
                    this._dataSetViewerFindDecorator.replaceDataSetViewer(dataSetViewer);
                    this._rsds.resetCursor();
                    this._dataSetViewerFindDecorator.getDataSetViewer().show(this._rsds, null);
                    this.initContinueReadChannel(this._dataSetViewerFindDecorator);
                    this.restoreTableState(resultSortableTableState, this._dataSetViewerFindDecorator.getDataSetViewer());
                } else {
                    String msg = s_stringMgr.getString("ResultTab.cannotedit");
                    JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
                }
            } else {
                SessionProperties props = this._session.getProperties();
                String readOnlyOutput = props.getReadOnlySQLResultsOutputClassName();
                TableState resultSortableTableState = this.getTableState(this._dataSetViewerFindDecorator.getDataSetViewer());
                IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.getInstance(readOnlyOutput, this._creator, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
                this._dataSetViewerFindDecorator.replaceDataSetViewer(dataSetViewer);
                this._rsds.resetCursor();
                this._dataSetViewerFindDecorator.getDataSetViewer().show(this._rsds, null);
                this.initContinueReadChannel(this._dataSetViewerFindDecorator);
                this.restoreTableState(resultSortableTableState, this._dataSetViewerFindDecorator.getDataSetViewer());
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void restoreTableState(TableState resultSortableTableState, IDataSetViewer resultSetOutput) {
        if (null != resultSortableTableState) {
            resultSetOutput.applyResultSortableTableState(resultSortableTableState);
        }
    }

    private TableState getTableState(IDataSetViewer resultSetOutput) {
        TableState resultSortableTableState = null;
        if (null != resultSetOutput) {
            resultSortableTableState = resultSetOutput.getResultSortableTableState();
        }
        return resultSortableTableState;
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        int sqlResultsTabPlacement = this._session.getProperties().getSQLResultsTabPlacement();
        this._tabResultTabs = UIFactory.getInstance().createTabbedPane(sqlResultsTabPlacement);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(15, 0));
        panel.add((Component)this.createRightPanel(), "East");
        panel.add((Component)this._currentSqlLblCtrl.getLabel(), "Center");
        this.add((Component)panel, "North");
        this.add((Component)this._tabResultTabs, "Center");
        this._tabResultTabs.addTab(null, this._dataSetViewerFindDecorator.getComponent());
        this._resultLabelNameSwitcher = new ResultLabelNameSwitcher(s_stringMgr.getString("ResultTab.resultsTabTitle"), 0, this._session, this._tabResultTabs);
        if (this._session.getProperties().getShowResultsMetaData()) {
            this._metaDataSp.setBorder(BorderFactory.createEmptyBorder());
            String metadataTabTitle = s_stringMgr.getString("ResultTab.metadataTabTitle");
            this._tabResultTabs.addTab(metadataTabTitle, this._metaDataSp);
        }
        JScrollPane sp = new JScrollPane(this._queryInfoPanel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        String infoTabTitle = s_stringMgr.getString("ResultTab.infoTabTitle");
        this._tabResultTabs.addTab(infoTabTitle, sp);
        this._additionalResultTabsController = new AdditionalResultTabsController(this._session, this._tabResultTabs, this._dataSetViewerFindDecorator.getDataSetViewer() instanceof DataSetViewerTablePanel);
    }

    private JPanel createRightPanel() {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)this.createButtonsPanel(), "East");
        ret.add((Component)this._selectRowColLabelController.getLabel(), "Center");
        return ret;
    }

    private JPanel createButtonsPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new GridLayout(1, 3, 0, 0));
        ret.add(this._readMoreResultsHandler.getLoadingLabel());
        ret.add(new TabButton(this.getRerunCurrentSQLResultTabAction()));
        this._btnToggleMarkDuplicates = new TabToggleButton(new MarkDuplicatesToggleAction(this));
        ret.add(this._btnToggleMarkDuplicates);
        ret.add(new TabButton(new FindColumnAction(this)));
        ret.add(new TabButton(new FindInResultAction(this)));
        ret.add(new TabButton(new CreateResultTabFrameAction(this._sqlResultExecuterPanelFacade, this)));
        ret.add(new TabButton(new CloseAction(this._session, this)));
        return ret;
    }

    private RerunCurrentSQLResultTabAction getRerunCurrentSQLResultTabAction() {
        RerunCurrentSQLResultTabAction rtn = new RerunCurrentSQLResultTabAction(this._session.getApplication(), this);
        rtn.setSQLPanel(this._session.getSQLPanelAPIOfActiveSessionWindow());
        return rtn;
    }

    @Override
    public void toggleShowFindPanel() {
        this._tabResultTabs.setSelectedIndex(0);
        if (!this._dataSetViewerFindDecorator.toggleShowFindPanel()) {
            this._session.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("ResultTab.tableSearchNotSupported"));
            s_log.warn(s_stringMgr.getString("ResultTab.tableSearchNotSupported"));
        }
    }

    @Override
    public void findColumn() {
        if (!(this._dataSetViewerFindDecorator.getDataSetViewer() instanceof DataSetViewerTablePanel)) {
            this._session.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("ResultTab.ColumnSearchNotSupported"));
            s_log.warn(s_stringMgr.getString("ResultTab.ColumnSearchNotSupported"));
            return;
        }
        DataSetViewerTablePanel dataSetViewerTablePanel = (DataSetViewerTablePanel)this._dataSetViewerFindDecorator.getDataSetViewer();
        this._tabResultTabs.setSelectedIndex(0);
        FindColumnCtrl findColumnCtrl = new FindColumnCtrl(GUIUtils.getOwningFrame(this._tabResultTabs), dataSetViewerTablePanel);
        if (null != findColumnCtrl.getColumnToGoTo()) {
            dataSetViewerTablePanel.scrollColumnToVisible(findColumnCtrl.getColumnToGoTo().getExtTableColumn());
        } else if (null != findColumnCtrl.getColumnsToMoveToFront()) {
            dataSetViewerTablePanel.moveColumnsToFront(findColumnCtrl.getColumnsToMoveToFront());
        }
    }

    @Override
    public void markDuplicates() {
        DataSetViewerTablePanel dataSetViewerTablePanel = (DataSetViewerTablePanel)this._dataSetViewerFindDecorator.getDataSetViewer();
        MarkDuplicatesHandler markDuplicatesHandler = dataSetViewerTablePanel.getTable().getColoringService().getMarkDuplicatesHandler();
        this._tabResultTabs.setSelectedIndex(0);
        markDuplicatesHandler.markDuplicates(this._btnToggleMarkDuplicates.isSelected());
    }

    @Override
    public boolean isMarkDuplicates() {
        DataSetViewerTablePanel dataSetViewerTablePanel = (DataSetViewerTablePanel)this._dataSetViewerFindDecorator.getDataSetViewer();
        MarkDuplicatesHandler markDuplicatesHandler = dataSetViewerTablePanel.getTable().getColoringService().getMarkDuplicatesHandler();
        return markDuplicatesHandler.isMarkDuplicates();
    }

    public void wasReturnedToTabbedPane() {
        DataSetViewerTablePanel dataSetViewerTablePanel = (DataSetViewerTablePanel)this._dataSetViewerFindDecorator.getDataSetViewer();
        MarkDuplicatesHandler markDuplicatesHandler = dataSetViewerTablePanel.getTable().getColoringService().getMarkDuplicatesHandler();
        this._btnToggleMarkDuplicates.setSelected(markDuplicatesHandler.isMarkDuplicates());
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public TableState getResultSortableTableState() {
        return this._dataSetViewerFindDecorator.getDataSetViewer().getResultSortableTableState();
    }

    public void applyResultSortableTableState(TableState sortableTableState) {
        this._dataSetViewerFindDecorator.getDataSetViewer().applyResultSortableTableState(sortableTableState);
    }
}

