/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.session.DefaultSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ObjectTreeSearch;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.FindInObjectTreePanel;

public class FindInObjectTreeController {
    private static final String PREF_KEY_OBJECT_TREE_SEARCH_FILTER = "Squirrel.objTreeSearchFilter";
    private FindInObjectTreePanel _findInObjectTreePanel;
    private DefaultSQLEntryPanel _filterEditSQLEntryPanel;
    private ISession _session;

    public FindInObjectTreeController(ISession session) {
        this._session = session;
        this._filterEditSQLEntryPanel = new DefaultSQLEntryPanel(session);
        this._filterEditSQLEntryPanel.setMarkCurrentSQLActive(false);
        this._findInObjectTreePanel = new FindInObjectTreePanel(this._filterEditSQLEntryPanel.getTextComponent(), session.getApplication().getResources());
        AbstractAction findAction = new AbstractAction("ObjectTree.Find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this.onEnter();
            }
        };
        AbstractAction transferFocusAction = new AbstractAction("ObjectTree.TransferFocus"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this._filterEditSQLEntryPanel.getTextComponent().transferFocus();
            }
        };
        this._filterEditSQLEntryPanel.getTextComponent().registerKeyboardAction(findAction, KeyStroke.getKeyStroke(10, 0, false), 0);
        this._filterEditSQLEntryPanel.getTextComponent().registerKeyboardAction(transferFocusAction, KeyStroke.getKeyStroke(9, 64, false), 0);
        boolean filter = Preferences.userRoot().getBoolean(PREF_KEY_OBJECT_TREE_SEARCH_FILTER, false);
        this._findInObjectTreePanel._btnApplyAsFilter.setSelected(filter);
        this._findInObjectTreePanel._btnFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this.onFind(false);
            }
        });
        this._findInObjectTreePanel._btnApplyAsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this.onFind(false == ((FindInObjectTreeController)FindInObjectTreeController.this)._findInObjectTreePanel._btnApplyAsFilter.isSelected());
            }
        });
    }

    private void onFind(boolean unfilterTreeFirst) {
        if (unfilterTreeFirst) {
            this._session.getProperties().setObjectFilterInclude(null);
            this._session.getObjectTreeAPIOfActiveSessionWindow().refreshSelectedNodes();
        }
        if (this._findInObjectTreePanel._btnApplyAsFilter.isSelected()) {
            this._session.getProperties().setObjectFilterInclude(this._filterEditSQLEntryPanel.getText());
            this._session.getObjectTreeAPIOfActiveSessionWindow().refreshSelectedNodes();
            new ObjectTreeSearch().viewObjectInObjectTree(this._session.getProperties().getObjectFilterInclude(), this._session);
        } else {
            new ObjectTreeSearch().viewObjectInObjectTree(this._filterEditSQLEntryPanel.getText(), this._session);
        }
    }

    private void onEnter() {
        this._findInObjectTreePanel._btnFind.doClick();
    }

    public JPanel getFindInObjectTreePanel() {
        return this._findInObjectTreePanel;
    }

    public ISQLEntryPanel getFindEntryPanel() {
        return this._filterEditSQLEntryPanel;
    }

    public void dispose() {
        Preferences.userRoot().putBoolean(PREF_KEY_OBJECT_TREE_SEARCH_FILTER, this._findInObjectTreePanel._btnApplyAsFilter.isSelected());
    }
}

