/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class FormattedSourceTab
extends BaseSourceTab {
    private static final ILogger s_log = LoggerController.createLogger(FormattedSourceTab.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormattedSourceTab.class);
    private ICodeReformator formatter = null;
    private boolean compressWhitespace = true;
    private CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    protected String statementSeparator = null;
    protected boolean appendSeparator = true;

    public FormattedSourceTab(String hint) {
        super(hint);
    }

    protected void setupFormatter(String stmtSep, CommentSpec[] commentSpecs) {
        if (commentSpecs != null) {
            this.commentSpecs = commentSpecs;
        }
        this.statementSeparator = stmtSep;
        this.formatter = new CodeReformator(CodeReformatorConfigFactory.createConfig(stmtSep, this.commentSpecs));
    }

    protected void setupFormatter(ICodeReformator codeReformator, String stmtSep, CommentSpec[] commentSpecs) {
        if (commentSpecs != null) {
            this.commentSpecs = commentSpecs;
        }
        this.statementSeparator = stmtSep;
        this.formatter = codeReformator;
    }

    protected void setCompressWhitespace(boolean compressWhitespace) {
        this.compressWhitespace = compressWhitespace;
    }

    protected String processResult(StringBuilder buf) {
        return buf.toString();
    }

    private String format(String toFormat) {
        String result = toFormat;
        try {
            result = this.formatter.reformat(toFormat);
        }
        catch (IllegalStateException e) {
            s_log.error("format: Formatting SQL failed: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        String sqlStatement = this.getSqlStatement();
        String[] bindValues = this.getBindValues();
        if (s_log.isDebugEnabled()) {
            s_log.debug("Running SQL for index source tab: " + sqlStatement);
            s_log.debug("With the following bind variable values: ");
            int parameterIndex = 1;
            for (String bindValue : bindValues) {
                s_log.debug("[" + parameterIndex++ + "] => '" + bindValue + "'");
            }
        }
        PreparedStatement pstmt = conn.prepareStatement(sqlStatement);
        int parameterIndex = 1;
        for (String bindValue : bindValues) {
            pstmt.setString(parameterIndex++, bindValue);
        }
        return pstmt;
    }

    protected abstract String getSqlStatement();

    protected String[] getBindValues() {
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        return new String[]{doi.getSchemaName(), doi.getSimpleName()};
    }

    @Override
    protected BaseSourcePanel createSourcePanel() {
        return new FormattedSourcePanel(this.getSession());
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private final class FormattedSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;

        FormattedSourcePanel(ISession session) {
            super(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(ISession session, PreparedStatement stmt) {
            this.getTextArea().setText("");
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuilder buf = new StringBuilder(4096);
                while (rs.next()) {
                    String line = rs.getString(1);
                    if (line == null) {
                        s_log.debug("load: Null object source line; skipping...");
                        continue;
                    }
                    if (FormattedSourceTab.this.compressWhitespace) {
                        buf.append(line.trim() + " ");
                        continue;
                    }
                    buf.append(line);
                }
                if (FormattedSourceTab.this.appendSeparator && FormattedSourceTab.this.statementSeparator != null) {
                    buf.append("\n");
                    buf.append(FormattedSourceTab.this.statementSeparator);
                }
                String processedResult = FormattedSourceTab.this.processResult(buf);
                if (FormattedSourceTab.this.formatter != null && buf.length() != 0) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("Object source code before formatting: " + processedResult);
                    }
                    this.getTextArea().setText(FormattedSourceTab.this.format(processedResult));
                } else {
                    if (buf.length() == 0) {
                        buf.append(i18n.NO_SOURCE_AVAILABLE);
                    }
                    this.getTextArea().setText(processedResult);
                }
                this.getTextArea().setCaretPosition(0);
            }
            catch (Exception ex) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("Unexpected exception while formatting object source code", ex);
                }
                session.showErrorMessage(ex);
            }
            finally {
                SQLUtilities.closeResultSet(rs);
            }
        }
    }

    static interface i18n {
        public static final String NO_SOURCE_AVAILABLE = FormattedSourceTab.access$000().getString("FormatterSourceTab.noSourceAvailable");
    }
}

