/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyTabControllerCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.CallDepthComboModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.IntervalDetailsController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewHolder;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableColumnWidthsPersister;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.ScaleFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OverviewCtrl
implements LazyTabControllerCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OverviewCtrl.class);
    private OverviewHolder _overviewHolder = new OverviewHolder();
    private OverviewPanel _overviewPanel;
    private IApplication _app;
    private ISession _session;
    private static final String PREF_KEY_CHART_PANEL_SPLIT = "Squirrel.overview.chartPanel.splitloc";
    private ChartConfigController _chartConfigController;
    private boolean _dontReactToCallDepthChanges;

    public OverviewCtrl(ISession session) {
        this._session = session;
        this._app = session.getApplication();
        ChartConfigListener chartConfigListener = new ChartConfigListener(){

            @Override
            public void closeSplit() {
                ((OverviewCtrl)OverviewCtrl.this)._overviewPanel.btnCreateBarChart.doClick();
            }
        };
        this._chartConfigController = new ChartConfigController(this._app, chartConfigListener);
        this._overviewPanel = new OverviewPanel(this._app.getResources(), this._chartConfigController.getPanel());
        this._overviewPanel.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onNext();
            }
        });
        this._overviewPanel.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onPrev();
            }
        });
        this._overviewPanel.btnShowInTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onShowInTable();
            }
        });
        this._overviewPanel.btnShowInTableWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onShowInTableWin();
            }
        });
        CallDepthComboModel[] depthComboModels = CallDepthComboModel.createModels();
        this._overviewPanel.cboCallDepth.setModel(new DefaultComboBoxModel<CallDepthComboModel>(depthComboModels));
        this._overviewPanel.cboCallDepth.setSelectedItem(depthComboModels[0]);
        this._overviewPanel.cboCallDepth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OverviewCtrl.this.onCallDepthSelected(e);
            }
        });
        this._overviewPanel.btnReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onReport();
            }
        });
        this._overviewPanel.btnCreateBarChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewCtrl.this.onCreateBarChart();
            }
        });
        this._overviewPanel.split.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OverviewCtrl.this.adjustHiddenSpiltLocationOnResize();
            }
        });
    }

    private void adjustHiddenSpiltLocationOnResize() {
        if (!this._overviewPanel.btnCreateBarChart.isSelected()) {
            this._overviewPanel.split.setDividerLocation(Integer.MAX_VALUE);
        }
    }

    private void onCallDepthSelected(ItemEvent itemEvent) {
        if (2 == itemEvent.getStateChange() || this._dontReactToCallDepthChanges) {
            return;
        }
        this.initScales(this._overviewHolder.getDataScaleTable().getAllRows(), this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions(), true);
    }

    private void onCreateBarChart() {
        if (this._overviewPanel.btnCreateBarChart.isSelected()) {
            this._overviewPanel.split.setDividerSize(this._overviewPanel.standardDividerSize);
            int distToRight = Preferences.userRoot().getInt(PREF_KEY_CHART_PANEL_SPLIT, Math.max(0, this._overviewPanel.split.getWidth() - this._chartConfigController.getPanel().getPreferredSize().width));
            this._overviewPanel.split.setDividerLocation(this._overviewPanel.split.getWidth() - distToRight);
        } else {
            int distToRight = this._overviewPanel.split.getWidth() - this._overviewPanel.split.getDividerLocation();
            Preferences.userRoot().putInt(PREF_KEY_CHART_PANEL_SPLIT, distToRight);
            this._overviewPanel.split.setDividerSize(0);
            this._overviewPanel.split.setDividerLocation(Integer.MAX_VALUE);
        }
    }

    private void onReport() {
        try {
            DataScaleTableModel dstm = this._overviewHolder.getDataScaleTable().getDataScaleTableModel();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("<html>");
            pw.println("<body>");
            for (int i = 0; i < dstm.getRowCount(); ++i) {
                DataScale dataScale = dstm.getDataScaleAt(i);
                pw.println("<h1>Column name " + dataScale.getColumn() + ":</h1>");
                pw.println("<table border=\"1\">");
                pw.println("<tr>");
                ArrayList<String> intervalReports = dataScale.getIntervalReports();
                for (String toolTip : intervalReports) {
                    pw.println("<td>" + toolTip + "</td>");
                }
                pw.println("<tr>");
                pw.println("</table>");
                pw.println();
            }
            pw.println("</body>");
            pw.println("</html>");
            pw.flush();
            sw.flush();
            pw.close();
            sw.close();
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(sw.getBuffer().toString());
            clip.setContents(data, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void onShowInTableWin() {
        DataSetViewerTablePanel simpleTable = this.createSimpleTable();
        this.openWindowForTable(simpleTable);
    }

    private void openWindowForTable(DataSetViewerTablePanel simpleTable) {
        Window parent = SwingUtilities.windowForComponent(this._overviewPanel.btnShowInTableWin);
        OverviewFrame overviewFrame = new OverviewFrame(simpleTable, this._app, parent);
        this._app.getMainFrame().addWidget(overviewFrame);
        overviewFrame.setLayer(JLayeredPane.PALETTE_LAYER);
        overviewFrame.setVisible(true);
        DialogWidget.centerWithinDesktop(overviewFrame);
    }

    private void onShowInTable() {
        this._overviewHolder.setOverview(this.createSimpleTable());
        this.initGui();
    }

    private void onShowIntervalInTable(Interval interval) {
        List<Object[]> rows = interval.getResultRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        this._overviewHolder.setOverview(this.createSimpleTable(rows, columnDisplayDefinitions));
        this.initGui();
    }

    private void onShowIntervalInTableWin(Interval interval) {
        List<Object[]> rows = interval.getResultRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        this.openWindowForTable(this.createSimpleTable(rows, columnDisplayDefinitions));
    }

    private DataSetViewerTablePanel createSimpleTable() {
        List<Object[]> allRows = this._overviewHolder.getDataScaleTable().getAllRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        return this.createSimpleTable(allRows, columnDisplayDefinitions);
    }

    private DataSetViewerTablePanel createSimpleTable(List<Object[]> allRows, ColumnDisplayDefinition[] columnDisplayDefinitions) {
        try {
            SimpleDataSet ods = new SimpleDataSet(allRows, columnDisplayDefinitions);
            DataSetViewerTablePanel dsv = new DataSetViewerTablePanel();
            dsv.init(null, new DataModelImplementationDetails(this._session), this._session);
            dsv.show(ods);
            return dsv;
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void onPrev() {
        this._overviewHolder.setParent();
        this.updateCallDepth();
        this.initGui();
    }

    private void updateCallDepth() {
        if (null != this._overviewHolder.getDataScaleTable()) {
            CallDepthComboModel callDepth = this._overviewHolder.getDataScaleTable().getDataScaleTableModel().getCallDepth();
            try {
                this._dontReactToCallDepthChanges = true;
                this._overviewPanel.cboCallDepth.setSelectedItem(callDepth);
            }
            finally {
                this._dontReactToCallDepthChanges = false;
            }
        }
    }

    private void onNext() {
        this._overviewHolder.setKid();
        this.updateCallDepth();
        this.initGui();
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("OverwiewCtrl.title_new");
    }

    @Override
    public OverviewPanel getPanel() {
        return this._overviewPanel;
    }

    @Override
    public void init(ResultSetDataSet rsds) {
        if (!this._overviewHolder.isEmpty()) {
            return;
        }
        List<Object[]> rows = rsds.getAllDataForReadOnly();
        DataSetDefinition dataSetDefinition = rsds.getDataSetDefinition();
        ColumnDisplayDefinition[] columnDefinitions = dataSetDefinition.getColumnDefinitions();
        this.initScales(rows, columnDefinitions, false);
    }

    private void onIntervalSelected(Interval interval, ColumnDisplayDefinition[] columnDefinitions, JButton intervalButtonClicked) {
        if (!interval.containsAllRows()) {
            this._overviewHolder.doClickTracing(intervalButtonClicked);
            List<Object[]> rows = interval.getResultRows();
            this.initScales(rows, columnDefinitions, false);
        }
    }

    private void initScales(List<Object[]> rows, final ColumnDisplayDefinition[] columnDefinitions, boolean keepFormerParent) {
        CallDepthComboModel selectedCallDepth = (CallDepthComboModel)this._overviewPanel.cboCallDepth.getSelectedItem();
        if (0 == rows.size()) {
            this.initScaleTable(new DataScale[0], rows, columnDefinitions, keepFormerParent, selectedCallDepth);
            return;
        }
        DataScale[] scales = new DataScale[columnDefinitions.length];
        DataScaleListener dataScaleListener = new DataScaleListener(){

            @Override
            public void intervalSelected(Interval interval, JButton intervalButtonClicked) {
                OverviewCtrl.this.onIntervalSelected(interval, columnDefinitions, intervalButtonClicked);
            }

            @Override
            public void showInTableWin(Interval interval) {
                OverviewCtrl.this.onShowIntervalInTableWin(interval);
            }

            @Override
            public void showInTable(Interval interval) {
                OverviewCtrl.this.onShowIntervalInTable(interval);
            }

            @Override
            public void showIntervalDetails(String intervalDetailsHtml, Point dialogLocation) {
                OverviewCtrl.this.onShowIntervalDetails(intervalDetailsHtml, dialogLocation);
            }
        };
        for (int i = 0; i < columnDefinitions.length; ++i) {
            scales[i] = new ScaleFactory(rows, i, columnDefinitions[i], selectedCallDepth.getCallDepth()).createScale(dataScaleListener);
        }
        this.initScaleTable(scales, rows, columnDefinitions, keepFormerParent, selectedCallDepth);
    }

    private void onShowIntervalDetails(String intervalDetailsHtml, Point dialogLocation) {
        new IntervalDetailsController(intervalDetailsHtml, GUIUtils.getOwningFrame(this._overviewPanel), dialogLocation);
    }

    private void initScaleTable(DataScale[] scales, List<Object[]> rows, ColumnDisplayDefinition[] columnDefinitions, boolean keepFormerParent, CallDepthComboModel callDepth) {
        DataScaleTableModel dataScaleTableModel = new DataScaleTableModel(scales, callDepth);
        DataScaleTable dataScaleTable = new DataScaleTable(dataScaleTableModel, rows, columnDefinitions);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        dataScaleTable.setColumnModel(tcm);
        for (int i = 0; i < DataScaleTableModel.getColumnNames().length; ++i) {
            TableColumn col = new TableColumn(i);
            col.setHeaderValue(DataScaleTableModel.getColumnNames()[i]);
            if (DataScaleTableModel.COL_NAME_COLUMN.equals(DataScaleTableModel.getColumnNames()[i])) {
                col.setPreferredWidth(DataScaleTableColumnWidthsPersister.getColumnWidthForColName(DataScaleTableModel.COL_NAME_COLUMN));
            } else if (DataScaleTableModel.COL_NAME_DATA.equals(DataScaleTableModel.getColumnNames()[i])) {
                col.setPreferredWidth(DataScaleTableColumnWidthsPersister.getColumnWidthForColName(DataScaleTableModel.COL_NAME_DATA));
            }
            tcm.addColumn(col);
        }
        this._overviewHolder.setOverview(dataScaleTable, keepFormerParent);
        this.initGui();
    }

    private void initGui() {
        this._overviewPanel.btnPrev.setEnabled(this._overviewHolder.hasParent());
        this._overviewPanel.btnNext.setEnabled(this._overviewHolder.hasKid());
        this._overviewPanel.btnShowInTable.setEnabled(this._overviewHolder.canShowInSimpleTable());
        this._overviewPanel.btnShowInTableWin.setEnabled(this._overviewHolder.canShowInSimpleTable());
        this._overviewPanel.scrollPane.setViewportView(this._overviewHolder.getComponent());
        if (this._overviewHolder.isScaleTable() && 0 < this._overviewHolder.getDataScaleTable().getAllRows().size()) {
            this._overviewPanel.btnReport.setEnabled(true);
            this._chartConfigController.setDataScaleTable(this._overviewHolder.getDataScaleTable());
            this._overviewPanel.btnCreateBarChart.setEnabled(true);
            this._overviewPanel.cboCallDepth.setEnabled(true);
        } else {
            this._overviewPanel.btnReport.setEnabled(false);
            if (this._overviewPanel.btnCreateBarChart.isSelected()) {
                this._overviewPanel.btnCreateBarChart.doClick();
            }
            this._overviewPanel.btnCreateBarChart.setEnabled(false);
            this._overviewPanel.cboCallDepth.setEnabled(false);
        }
    }

    public static boolean isOverviewPanel(Component component) {
        return component instanceof OverviewPanel;
    }
}

