/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.JumpToObjectTreeConfigCtrl;
import net.sourceforge.squirrel_sql.client.session.properties.SQLResultConfigCtrl;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontChooser;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class SQLPropertiesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPropertiesPanel.class);
    private JCheckBox _abortOnErrorChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.abortonerror"));
    private JCheckBox _showSQLErrorsInTabChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.showSQLErrorsInTab"));
    private JCheckBox _writeSQLErrorsToLogChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.writesqlerrorstolog"));
    private JCheckBox _loadColumsInBackgroundChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.loadColumsInBackground"));
    private JCheckBox _autoCommitChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.autocommit"));
    private JCheckBox _commitOnClose = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.commitonclose"));
    private SQLResultConfigCtrl _sqlResultConfigCtrl = new SQLResultConfigCtrl();
    private JumpToObjectTreeConfigCtrl _jumpToObjectTreeConfigCtrl = new JumpToObjectTreeConfigCtrl();
    private JTextField _stmtSepField = new JTextField(5);
    private JTextField _solCommentField = new JTextField(2);
    private JCheckBox _removeMultiLineComment = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.removeMultiLineComment"));
    private JCheckBox _limitSQLResultTabsChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.limitsqlresulttabs"));
    private IntegerField _limitSQLResultTabsField = new IntegerField(5);
    private JLabel _fontLbl = new JLabel();
    private FontButton _fontBtn = new FontButton(s_stringMgr.getString("SessionSQLPropertiesPanel.font"), this._fontLbl);
    private JCheckBox _shareSQLHistoryChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.sharesqlhistory"));
    private JCheckBox _limitSQLHistoryComboSizeChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.limitsqlhistorysize"));
    private IntegerField _limitSQLHistoryComboSizeField = new IntegerField(5);
    private JCheckBox _showResultsMetaChk = new JCheckBox(s_stringMgr.getString("SessionSQLPropertiesPanel.showresultsmd"));
    private final ControlMediator _controlMediator = new ControlMediator();
    private ISession _session;

    SQLPropertiesPanel(IApplication app, ISession session) {
        this._session = session;
        this.createGUI();
    }

    void loadData(SessionProperties props) {
        this._abortOnErrorChk.setSelected(props.getAbortOnError());
        this._showSQLErrorsInTabChk.setSelected(props.getShowSQLErrorsInTab());
        this._writeSQLErrorsToLogChk.setSelected(props.getWriteSQLErrorsToLog());
        this._loadColumsInBackgroundChk.setSelected(props.getLoadColumnsInBackground());
        this._autoCommitChk.setSelected(props.getAutoCommit());
        this._commitOnClose.setSelected(props.getCommitOnClosingConnection());
        this._sqlResultConfigCtrl.loadData(props);
        this._jumpToObjectTreeConfigCtrl.loadData(props);
        if (null != this._session) {
            IQueryTokenizer queryTokenizer = this._session.getQueryTokenizer();
            TokenizerSessPropsInteractions qtp = queryTokenizer.getTokenizerSessPropsInteractions();
            if (qtp.isTokenizerDefinesStatementSeparator()) {
                this._stmtSepField.setText(queryTokenizer.getSQLStatementSeparator());
                this._stmtSepField.setEditable(false);
            } else {
                this._stmtSepField.setText(props.getSQLStatementSeparator());
                this._stmtSepField.setEditable(true);
            }
            if (qtp.isTokenizerDefinesStartOfLineComment()) {
                this._solCommentField.setText(queryTokenizer.getLineCommentBegin());
                this._solCommentField.setEditable(false);
            } else {
                this._solCommentField.setText(props.getStartOfLineComment());
                this._solCommentField.setEditable(true);
            }
            if (qtp.isTokenizerDefinesStatementSeparator()) {
                this._removeMultiLineComment.setSelected(queryTokenizer.isRemoveMultiLineComment());
                this._removeMultiLineComment.setEnabled(false);
            } else {
                this._removeMultiLineComment.setSelected(props.getRemoveMultiLineComment());
                this._removeMultiLineComment.setEnabled(true);
            }
        } else {
            this._stmtSepField.setText(props.getSQLStatementSeparator());
            this._solCommentField.setText(props.getStartOfLineComment());
            this._removeMultiLineComment.setSelected(props.getRemoveMultiLineComment());
        }
        this._shareSQLHistoryChk.setSelected(props.getSQLShareHistory());
        this._limitSQLHistoryComboSizeChk.setSelected(props.getLimitSQLEntryHistorySize());
        this._limitSQLHistoryComboSizeField.setInt(props.getSQLEntryHistorySize());
        this._limitSQLResultTabsChk.setSelected(props.getLimitSQLResultTabs());
        this._limitSQLResultTabsField.setInt(props.getSqlResultTabLimit());
        this._showResultsMetaChk.setSelected(props.getShowResultsMetaData());
        FontInfo fi = props.getFontInfo();
        if (fi == null) {
            fi = new FontInfo(UIManager.getFont("TextArea.font"));
        }
        this._fontLbl.setText(fi.toString());
        this._fontBtn.setSelectedFont(fi.createFont());
        this.updateControlStatus();
    }

    void applyChanges(SessionProperties props) {
        props.setAbortOnError(this._abortOnErrorChk.isSelected());
        props.setShowSQLErrorsInTab(this._showSQLErrorsInTabChk.isSelected());
        props.setWriteSQLErrorsToLog(this._writeSQLErrorsToLogChk.isSelected());
        props.setLoadColumnsInBackground(this._loadColumsInBackgroundChk.isSelected());
        props.setAutoCommit(this._autoCommitChk.isSelected());
        props.setCommitOnClosingConnection(this._commitOnClose.isSelected());
        props.setSQLLimitRows(this._sqlResultConfigCtrl.isLimitRows());
        props.setSQLNbrRowsToShow(this._sqlResultConfigCtrl.getNbrRowsToShow());
        props.setSQLReadOn(this._sqlResultConfigCtrl.isReadOn());
        props.setSQLReadOnBlockSize(this._sqlResultConfigCtrl.getReadOnBlockSize());
        props.setSQLUseFetchSize(this._sqlResultConfigCtrl.isUseFetchSize());
        props.setSQLFetchSize(this._sqlResultConfigCtrl.getFetchSize());
        props.setAllowCtrlBJumpToObjectTree(this._jumpToObjectTreeConfigCtrl.isAllowCtrlBJumpToObjectTree());
        props.setAllowCtrlMouseClickJumpToObjectTree(this._jumpToObjectTreeConfigCtrl.isAllowCtrlMouseClickJumpToObjectTree());
        props.setSQLStatementSeparator(this._stmtSepField.getText());
        props.setStartOfLineComment(this._solCommentField.getText());
        props.setRemoveMultiLineComment(this._removeMultiLineComment.isSelected());
        props.setFontInfo(this._fontBtn.getFontInfo());
        props.setSQLShareHistory(this._shareSQLHistoryChk.isSelected());
        props.setLimitSQLEntryHistorySize(this._limitSQLHistoryComboSizeChk.isSelected());
        props.setSQLEntryHistorySize(this._limitSQLHistoryComboSizeField.getInt());
        props.setLimitSQLResultTabs(this._limitSQLResultTabsChk.isSelected());
        if (0 >= this._limitSQLResultTabsField.getInt()) {
            props.setSqlResultTabLimit(15);
        } else {
            props.setSqlResultTabLimit(this._limitSQLResultTabsField.getInt());
        }
        props.setShowResultsMetaData(this._showResultsMetaChk.isSelected());
    }

    private void updateControlStatus() {
        this._commitOnClose.setEnabled(!this._autoCommitChk.isSelected());
        this._limitSQLResultTabsField.setEnabled(this._limitSQLResultTabsChk.isSelected());
        boolean shareSQLHistory = this._shareSQLHistoryChk.isSelected();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.createSQLPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createFontPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createSQLHistoryPanel(), gbc);
    }

    private JPanel createSQLPanel() {
        TokenizerSessPropsInteractions tep;
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sql")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        this._autoCommitChk.addChangeListener(this._controlMediator);
        this._stmtSepField.setColumns(5);
        this._limitSQLResultTabsChk.addChangeListener(this._controlMediator);
        this._limitSQLResultTabsField.setColumns(5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)this._autoCommitChk, gbc);
        gbc.gridx += 2;
        gbc.gridwidth = 0;
        pnl.add((Component)this._commitOnClose, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        pnl.add((Component)this._showResultsMetaChk, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 0;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(oldInsets.top + 10, oldInsets.left, oldInsets.bottom + 10, oldInsets.right);
        pnl.add((Component)this._jumpToObjectTreeConfigCtrl.createJumpToObjectTreeConfigPanel(), gbc);
        gbc.insets = oldInsets;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        oldInsets = gbc.insets;
        gbc.insets = new Insets(oldInsets.top + 10, oldInsets.left, oldInsets.bottom + 10, oldInsets.right);
        pnl.add((Component)this._sqlResultConfigCtrl.createResultLimitAndReadOnPanel(), gbc);
        gbc.insets = oldInsets;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)this._limitSQLResultTabsChk, gbc);
        gbc.gridwidth = 1;
        gbc.gridx += 2;
        pnl.add((Component)this._limitSQLResultTabsField, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.tabs")), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        pnl.add((Component)this._abortOnErrorChk, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        pnl.add((Component)this._showSQLErrorsInTabChk, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        pnl.add((Component)this._writeSQLErrorsToLogChk, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        pnl.add((Component)this.createLoadColumnsInBackkgroundPanel(), gbc);
        if (null != this._session && ((tep = this._session.getQueryTokenizer().getTokenizerSessPropsInteractions()).isTokenizerDefinesRemoveMultiLineComment() || tep.isTokenizerDefinesStartOfLineComment() || tep.isTokenizerDefinesStatementSeparator())) {
            ++gbc.gridy;
            gbc.gridwidth = 4;
            MultipleLineLabel lbl = new MultipleLineLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.tokenizerNotEditableMsg"));
            lbl.setForeground(Color.red);
            pnl.add((Component)lbl, gbc);
            gbc.gridwidth = 1;
        }
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        pnl.add((Component)new JLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.stmtsep")), gbc);
        ++gbc.gridx;
        pnl.add((Component)this._stmtSepField, gbc);
        ++gbc.gridx;
        pnl.add((Component)new RightLabel(s_stringMgr.getString("SessionSQLPropertiesPanel.solcomment")), gbc);
        ++gbc.gridx;
        pnl.add((Component)this._solCommentField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        pnl.add((Component)this._removeMultiLineComment, gbc);
        return pnl;
    }

    private JPanel createLoadColumnsInBackkgroundPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0);
        String loadColsInBackgroundDescription = s_stringMgr.getString("SessionSQLPropertiesPanel.loadColsInBackgroundDescription");
        ret.add((Component)new MultipleLineLabel(loadColsInBackgroundDescription), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._loadColumsInBackgroundChk, gbc);
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.columnLoading")));
        return ret;
    }

    private JPanel createFontPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sqlentryarea")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this._fontBtn.addActionListener(new FontButtonListener());
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._fontBtn, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        pnl.add((Component)this._fontLbl, gbc);
        return pnl;
    }

    private JPanel createSQLHistoryPanel() {
        this._shareSQLHistoryChk.addChangeListener(this._controlMediator);
        this._limitSQLHistoryComboSizeChk.addChangeListener(this._controlMediator);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("SessionSQLPropertiesPanel.sqlhistory")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._shareSQLHistoryChk, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._limitSQLHistoryComboSizeChk, gbc);
        ++gbc.gridx;
        pnl.add((Component)this._limitSQLHistoryComboSizeField, gbc);
        return pnl;
    }

    private final class ControlMediator
    implements ChangeListener,
    ActionListener {
        private ControlMediator() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            SQLPropertiesPanel.this.updateControlStatus();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SQLPropertiesPanel.this.updateControlStatus();
        }
    }

    private static final class FontButtonListener
    implements ActionListener {
        private FontButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof FontButton) {
                FontButton btn = (FontButton)evt.getSource();
                FontInfo fi = btn.getFontInfo();
                Font font = null;
                if (fi != null) {
                    font = fi.createFont();
                }
                if ((font = new FontChooser().showDialog(font)) != null) {
                    btn.setSelectedFont(font);
                    btn._lbl.setText(new FontInfo(font).toString());
                }
            }
        }
    }

    private static final class FontButton
    extends JButton {
        private FontInfo _fi;
        private JLabel _lbl;
        private Font _font;

        FontButton(String text, JLabel lbl) {
            super(text);
            this._lbl = lbl;
        }

        FontInfo getFontInfo() {
            return this._fi;
        }

        Font getSelectedFont() {
            return this._font;
        }

        void setSelectedFont(Font font) {
            this._font = font;
            if (this._fi == null) {
                this._fi = new FontInfo(font);
            } else {
                this._fi.setFont(font);
            }
        }
    }

    private static final class RightLabel
    extends JLabel {
        RightLabel(String title) {
            super(title, 4);
        }
    }
}

