/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Color;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MarkDuplicatesHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.rowcolor.RowColorHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindColorHandler;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public class ColoringService {
    private RowColorHandler _rowColorHandler;
    private FindColorHandler _findColorHandler;
    private MarkDuplicatesHandler _markDuplicatesHandler;

    public ColoringService(DataSetViewerTable dataSetViewerTable) {
        this._rowColorHandler = new RowColorHandler(dataSetViewerTable);
        this._findColorHandler = new FindColorHandler();
        this._markDuplicatesHandler = new MarkDuplicatesHandler(dataSetViewerTable);
    }

    public void colorCell(CellRenderer cellRenderer, IDataTypeComponent dataTypeObject, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color markDuplicateBackground;
        if (-42 == table.getColumnModel().getColumn(column).getModelIndex()) {
            return;
        }
        Color customBackground = null;
        customBackground = dataTypeObject != null && !dataTypeObject.isEditableInCell(value) && dataTypeObject.isEditableInPopup(value) ? SquirrelConstants.MULTI_LINE_CELL_COLOR : this._rowColorHandler.getBackgroundForRow(row, isSelected);
        Color findBackground = this._findColorHandler.getBackgroundForCell(row, column);
        if (null != findBackground) {
            customBackground = findBackground;
        }
        if (null != (markDuplicateBackground = this._markDuplicatesHandler.getBackgroundForCell(row, column, value))) {
            customBackground = markDuplicateBackground;
        }
        if (null != customBackground) {
            cellRenderer.setBackground(customBackground);
        }
    }

    public RowColorHandler getRowColorHandler() {
        return this._rowColorHandler;
    }

    public FindColorHandler getFindColorHandler() {
        return this._findColorHandler;
    }

    public MarkDuplicatesHandler getMarkDuplicatesHandler() {
        return this._markDuplicatesHandler;
    }
}

