/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColoringService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetTableControls;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.RectangleSelectionHandler;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public final class DataSetViewerTable
extends JTable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetViewerTable.class);
    private ILogger s_log = LoggerController.createLogger(DataSetViewerTable.class);
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private final int _multiplier;
    private static final String data = "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG";
    private TablePopupMenu _tablePopupMenu;
    private RectangleSelectionHandler _rectangleSelectionHandler = new RectangleSelectionHandler(this);
    private RowNumberTableColumn _rntc;
    private ButtonTableHeader _tableHeader = new ButtonTableHeader();
    private ColoringService _coloringService = new ColoringService(this);

    DataSetViewerTable(DataSetViewerTablePanel dataSetViewerTablePanel, IDataSetTableControls creator, IDataSetUpdateableModel updateableObject, int listSelectionMode, ISession session) {
        super(new SortableTableModel(new DataSetViewerTableModel(dataSetViewerTablePanel)));
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length();
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        boolean allowUpdate = false;
        if (updateableObject != null && !creator.isTableEditable()) {
            allowUpdate = true;
        }
        this.createGUI(allowUpdate, updateableObject, listSelectionMode, session);
        this._dataSetViewerTablePanel.setCellEditors(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this._rectangleSelectionHandler.paintRectWhenNeeded(g);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        TableCellEditor cellEditor = super.getCellEditor(row, col);
        this._dataSetViewerTablePanel.setCurrentCellEditor((DefaultCellEditor)cellEditor);
        return cellEditor;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyChar() == '\b' && this.getEditorComponent() != null && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>")) {
            return;
        }
        super.processKeyEvent(e);
        if (this.getEditorComponent() != null && e.getID() == 400 && ((RestorableJTextField)this.getEditorComponent()).getText().length() == 7 && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>" + e.getKeyChar())) {
            ((RestorableJTextField)this.getEditorComponent()).updateText("" + e.getKeyChar());
        }
    }

    @Override
    public void setValueAt(Object newValueString, int row, int col) {
        if (!(newValueString instanceof String)) {
            super.setValueAt(newValueString, row, col);
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        int modelIndex = this.getColumnModel().getColumn(col).getModelIndex();
        ColumnDisplayDefinition colDef = this._dataSetViewerTablePanel.getColumnDefinitions()[modelIndex];
        Object newValueObject = CellComponentFactory.validateAndConvert(colDef, this.getValueAt(row, col), (String)newValueString, messageBuffer);
        if (messageBuffer.length() > 0) {
            String msg = s_stringMgr.getString("dataSetViewerTablePanel.textCantBeConverted", messageBuffer);
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug("setValueAt: msg from DataTypeComponent was: " + msg);
            }
            JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("dataSetViewerTablePanel.conversionError"), 0);
        } else {
            super.setValueAt(newValueObject, row, col);
        }
    }

    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        TableColumnModel tcm = this.createColumnModel(colDefs);
        this.setColumnModel(tcm);
        this.getDataSetViewerTableModel().setHeadings(colDefs);
        this._dataSetViewerTablePanel.setCellEditors(this);
        this._tablePopupMenu.reset();
    }

    public DataSetViewerTableModel getDataSetViewerTableModel() {
        return (DataSetViewerTableModel)((SortableTableModel)this.getModel()).getActualModel();
    }

    public SortableTableModel getSortableTableModel() {
        return (SortableTableModel)this.getModel();
    }

    private void displayPopupMenu(MouseEvent evt) {
        this._tablePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private TableColumnModel createColumnModel(ColumnDisplayDefinition[] colDefs) {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        this._rntc = new RowNumberTableColumn();
        for (int i = 0; i < colDefs.length; ++i) {
            int colWidth;
            ColumnDisplayDefinition colDef = colDefs[i];
            if (null == colDef.getAbsoluteWidth()) {
                colWidth = colDef.getDisplayWidth() * this._multiplier;
                if (colWidth > 50 * this._multiplier) {
                    colWidth = 50 * this._multiplier;
                } else if (colWidth < 3 * this._multiplier) {
                    colWidth = 3 * this._multiplier;
                }
            } else {
                colWidth = colDef.getAbsoluteWidth();
            }
            CellRenderer tableCellRenderer = CellComponentFactory.getTableCellRenderer(colDefs[i]);
            tableCellRenderer.setColoringService(this._coloringService);
            ExtTableColumn col = new ExtTableColumn(i, colWidth, tableCellRenderer, null);
            String headerValue = colDef.getColumnHeading();
            col.setHeaderValue(headerValue);
            col.setColumnDisplayDefinition(colDef);
            cm.addColumn(col);
        }
        return cm;
    }

    void setShowRowNumbers(boolean show) {
        try {
            int rowNumColIx = this.getColumnModel().getColumnIndex(RowNumberTableColumn.ROW_NUMBER_COL_IDENTIFIER);
            this._tableHeader.columnIndexWillBeRemoved(rowNumColIx);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.getColumnModel().removeColumn(this._rntc);
        if (show) {
            this._tableHeader.columnIndexWillBeAdded(0);
            this.getColumnModel().addColumn(this._rntc);
            this.getColumnModel().moveColumn(this.getColumnModel().getColumnCount() - 1, 0);
        }
        this._tablePopupMenu.ensureRowNumersMenuItemIsUpToDate(show);
    }

    public boolean isShowingRowNumbers() {
        try {
            this.getColumnModel().getColumnIndex(RowNumberTableColumn.ROW_NUMBER_COL_IDENTIFIER);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void createGUI(boolean allowUpdate, IDataSetUpdateableModel updateableObject, int selectionMode, ISession session) {
        this.setSelectionMode(selectionMode);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(0);
        this.setTableHeader(this._tableHeader);
        this._tableHeader.setTable(this);
        this._tablePopupMenu = new TablePopupMenu(allowUpdate, updateableObject, this._dataSetViewerTablePanel, session);
        this._tablePopupMenu.setTable(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataSetViewerTable.this.onMousePressed(evt, false);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataSetViewerTable.this.onMouseReleased(evt);
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataSetViewerTable.this.onMousePressed(evt, true);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataSetViewerTable.this.onMouseReleased(evt);
            }
        });
    }

    private void onMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt);
        }
    }

    private void onMousePressed(MouseEvent evt, boolean clickedOnTableHeader) {
        if (evt.isPopupTrigger()) {
            this.displayPopupMenu(evt);
        } else if (evt.getClickCount() == 2 && !clickedOnTableHeader) {
            int columnIndexAtX;
            Point pt = evt.getPoint();
            TableColumnModel cm = this.getColumnModel();
            int modelIndex = cm.getColumn(columnIndexAtX = cm.getColumnIndexAtX(pt.x)).getModelIndex();
            if (-42 != modelIndex) {
                ColumnDisplayDefinition[] colDefs = this._dataSetViewerTablePanel.getColumnDefinitions();
                CellDataPopup.showDialog(this, colDefs[modelIndex], evt, this._dataSetViewerTablePanel.isTableEditable());
            }
        }
    }

    public void initColWidths() {
        this._tableHeader.initColWidths();
    }

    public ColoringService getColoringService() {
        return this._coloringService;
    }
}

