/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public class MarkDuplicatesHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, TreeMap<Object, Color>> _duplicateValuesByColumnModelIndex;

    public MarkDuplicatesHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._duplicateValuesByColumnModelIndex = null;
                return;
            }
            this._duplicateValuesByColumnModelIndex = new HashMap();
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            Comparator treeMapKeyComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            for (int i = 0; i < dataSetViewerTableModel.getColumnCount(); ++i) {
                int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(i).getModelIndex();
                TreeMap colorByDuplicateValue = new TreeMap(treeMapKeyComparator);
                this._duplicateValuesByColumnModelIndex.put(columnModelIndex, colorByDuplicateValue);
                HashSet<Object> buf = new HashSet<Object>();
                for (int j = 0; j < dataSetViewerTableModel.getRowCount(); ++j) {
                    Object val = dataSetViewerTableModel.getValueAt(j, i);
                    if (buf.contains(val)) {
                        colorByDuplicateValue.put(val, null);
                        continue;
                    }
                    buf.add(val);
                }
                int count = 0;
                for (Object value : colorByDuplicateValue.keySet()) {
                    if (0 == ++count % 2) {
                        colorByDuplicateValue.put(value, SquirrelConstants.DUPLICATE_COLOR_DARKER);
                        continue;
                    }
                    colorByDuplicateValue.put(value, SquirrelConstants.DUPLICATE_COLOR);
                }
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._duplicateValuesByColumnModelIndex) {
            return null;
        }
        int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        if (-42 == columnModelIndex) {
            return null;
        }
        return this._duplicateValuesByColumnModelIndex.get(columnModelIndex).get(value);
    }

    public boolean isMarkDuplicates() {
        return null != this._duplicateValuesByColumnModelIndex;
    }
}

