/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.rowcolor.RowColorHandlerState;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;

public class TableState {
    private boolean _applySorting;
    private int _sortedColumn;
    private ColumnOrder _columnOrder;
    private Rectangle _visibleRect;
    private HashMap<Integer, Integer> _columnWidthsByModelIndex = new HashMap();
    private HashMap<Integer, Integer> _columnIndexByModelIndex = new HashMap();
    private int _selectedRow;
    private RowColorHandlerState _rowColorHandlerState;
    private boolean _isShowingRowNumbers;

    public TableState(JTable table) {
        if (table.getModel() instanceof SortableTableModel) {
            this._applySorting = true;
            this._sortedColumn = ((SortableTableModel)table.getModel()).getSortedColumn();
            this._columnOrder = ((SortableTableModel)table.getModel()).getColumnOrder();
        }
        this._selectedRow = table.getSelectedRow();
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            this._columnWidthsByModelIndex.put(column.getModelIndex(), column.getWidth());
            this._columnIndexByModelIndex.put(column.getModelIndex(), i);
        }
        this._visibleRect = table.getVisibleRect();
        if (table instanceof DataSetViewerTable) {
            this._rowColorHandlerState = ((DataSetViewerTable)table).getColoringService().getRowColorHandler().getState();
            this._isShowingRowNumbers = ((DataSetViewerTable)table).isShowingRowNumbers();
        }
    }

    public void apply(final JTable table) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TableState.this.doApply(table);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void doApply(JTable table) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            Integer width = this._columnWidthsByModelIndex.get(table.getColumnModel().getColumn(i).getModelIndex());
            if (null == width) continue;
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        for (Integer modelIndex : this._columnIndexByModelIndex.keySet()) {
            this.moveTo(table.getColumnModel(), modelIndex, this._columnIndexByModelIndex.get(modelIndex));
        }
        if (this._applySorting && table.getModel() instanceof SortableTableModel && -1 != this._sortedColumn) {
            ((SortableTableModel)table.getModel()).sortByColumn(this._sortedColumn, this._columnOrder);
        }
        if (-1 != this._selectedRow) {
            table.getSelectionModel().setSelectionInterval(this._selectedRow, this._selectedRow);
        }
        if (table instanceof DataSetViewerTable) {
            ((DataSetViewerTable)table).getColoringService().getRowColorHandler().applyState(this._rowColorHandlerState);
            if (this._isShowingRowNumbers) {
                ((DataSetViewerTable)table).setShowRowNumbers(true);
            }
        }
        table.scrollRectToVisible(this._visibleRect);
    }

    private void moveTo(TableColumnModel columnModel, int modelIndex, int columnIndex) {
        if (columnIndex >= columnModel.getColumnCount() || columnIndex < 0) {
            return;
        }
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (modelIndex != columnModel.getColumn(i).getModelIndex()) continue;
            columnModel.moveColumn(i, columnIndex);
            break;
        }
    }
}

