/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColoringService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;

public final class CellRenderer
extends DefaultTableCellRenderer
implements SquirrelTableCellRenderer {
    private final IDataTypeComponent _dataTypeObject;
    private ColoringService _coloringService;

    CellRenderer(IDataTypeComponent dataTypeObject) {
        this._dataTypeObject = dataTypeObject;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.putClientProperty("html.disable", Boolean.TRUE);
        this._coloringService.colorCell(this, this._dataTypeObject, table, value, isSelected, hasFocus, row, column);
        return label;
    }

    @Override
    public void setValue(Object value) {
        if (this._dataTypeObject != null) {
            super.setValue(this._dataTypeObject.renderObject(value));
        } else {
            super.setValue(DefaultColumnRenderer.getInstance().renderObject(value));
        }
    }

    @Override
    public Object renderValue(Object value) {
        if (this._dataTypeObject != null) {
            return this._dataTypeObject.renderObject(value);
        }
        return DefaultColumnRenderer.getInstance().renderObject(value);
    }

    public void setColoringService(ColoringService coloringService) {
        this._coloringService = coloringService;
    }
}

