/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.rowcolor;

import java.awt.Color;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.rowcolor.RowColorHandlerState;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class RowColorHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, Color> _colorByRow = new HashMap();

    public RowColorHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    public Color getFirstColorInSelection() {
        for (int row : this._dataSetViewerTable.getSelectedRows()) {
            if (null == this._colorByRow.get(this._dataSetViewerTable.getSortableTableModel().transformToModelRow(row))) continue;
            return this._colorByRow.get(this._dataSetViewerTable.getSortableTableModel().transformToModelRow(row));
        }
        return null;
    }

    public void setColorForSelectedRows(Color newColor) {
        for (int viewRow : this._dataSetViewerTable.getSelectedRows()) {
            int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(viewRow);
            if (null == newColor) {
                this._colorByRow.remove(modelRow);
                continue;
            }
            this._colorByRow.put(modelRow, newColor);
        }
        this._dataSetViewerTable.repaint();
    }

    public Color getBackgroundForRow(int viewRow, boolean isSelected) {
        Color backGround = isSelected ? this._dataSetViewerTable.getSelectionBackground() : this._dataSetViewerTable.getBackground();
        if (0 == this._colorByRow.size()) {
            return backGround;
        }
        int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(viewRow);
        if (null != this._colorByRow.get(modelRow)) {
            backGround = isSelected ? this._colorByRow.get(modelRow).darker() : this._colorByRow.get(modelRow);
        }
        return backGround;
    }

    public RowColorHandlerState getState() {
        return new RowColorHandlerState(Utilities.cloneObject(this._colorByRow, this._colorByRow.getClass().getClassLoader()));
    }

    public void applyState(RowColorHandlerState rowColorHandlerState) {
        this._colorByRow = rowColorHandlerState.getColorByRow();
    }

    public HashMap<Integer, Color> getColorByRow() {
        return this._colorByRow;
    }
}

